/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import jakarta.servlet.Servlet;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.jax.rs.whiteboard.internal.AriesJaxrsServiceRuntime;
import org.apache.aries.jax.rs.whiteboard.internal.DefaultApplication;
import org.apache.aries.jax.rs.whiteboard.internal.Maps;
import org.apache.aries.jax.rs.whiteboard.internal.Registry;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.CxfJaxrsServiceRegistrator;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.PrototypeServiceReferenceResourceProvider;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.SingletonServiceReferenceResourceProvider;
import org.apache.aries.jax.rs.whiteboard.internal.utils.LogUtils;
import org.apache.aries.jax.rs.whiteboard.internal.utils.PropertyHolder;
import org.apache.aries.jax.rs.whiteboard.internal.utils.ServiceTuple;
import org.apache.aries.jax.rs.whiteboard.internal.utils.Utils;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Whiteboard {
    public static final Map<String, Class<?>> SUPPORTED_EXTENSION_INTERFACES = Collections.unmodifiableMap(Stream.of(ContainerRequestFilter.class, ContainerResponseFilter.class, ReaderInterceptor.class, WriterInterceptor.class, MessageBodyReader.class, MessageBodyWriter.class, ContextResolver.class, ExceptionMapper.class, ParamConverterProvider.class, jakarta.ws.rs.core.Feature.class, DynamicFeature.class, Feature.class, ContextProvider.class).collect(Collectors.toMap(Class::getName, Function.identity())));
    static final String DEFAULT_NAME = ".default";
    private static final Logger _log = LoggerFactory.getLogger(Whiteboard.class);
    private final String _applicationBasePrefix;
    private final Registry<CxfJaxrsServiceRegistrator> _applicationRegistry = new Registry();
    private final AriesJaxrsServiceRuntime _runtime;
    private final Map<String, ?> _configurationMap;
    private volatile BundleContext _bundleContext;
    private volatile ServiceRegistrationChangeCounter _counter;
    private volatile ServiceReference<JaxrsServiceRuntime> _runtimeReference;
    private final OSGi<Void> _program;
    private final List<Object> _endpoints = new ArrayList<Object>();
    private volatile ServiceRegistration<JaxrsServiceRuntime> _runtimeRegistration;
    private OSGiResult _osgiResult;
    private static final Filter _extensionsFilter;
    private static final Filter _resourcesFilter;
    private static Filter _applicationsFilter;

    private Whiteboard(Dictionary<String, ?> configuration) {
        this._runtime = new AriesJaxrsServiceRuntime(this);
        this._configurationMap = Maps.from(configuration);
        this._applicationBasePrefix = Utils.canonicalizeAddress(Utils.getString(this._configurationMap.get("application.base.prefix")));
        this._program = OSGi.all((OSGi[])new OSGi[]{OSGi.ignore(this.registerDefaultApplication()), OSGi.ignore(this.getAllServices())});
    }

    public static Whiteboard createWhiteboard(Dictionary<String, ?> configuration) {
        return new Whiteboard(configuration);
    }

    public void start(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._runtimeRegistration = this.registerJaxRSServiceRuntime(new HashMap<String, Object>(this._configurationMap));
        this._runtimeReference = this._runtimeRegistration.getReference();
        this._counter = new ServiceRegistrationChangeCounter(this._runtimeRegistration);
        this._osgiResult = this._program.run(bundleContext);
    }

    public void stop() {
        this._osgiResult.close();
        this._runtimeRegistration.unregister();
        this._applicationRegistry.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpEndpoints(List<String> endpoints) {
        ServiceRegistration<JaxrsServiceRuntime> serviceRegistration = this._runtimeRegistration;
        synchronized (serviceRegistration) {
            this._endpoints.addAll(endpoints);
            Utils.updateProperty(this._runtimeRegistration, "osgi.jaxrs.endpoint", this._endpoints);
        }
    }

    public ServiceReference<JaxrsServiceRuntime> getServiceReference() {
        return this._runtimeReference;
    }

    private OSGi<?> applicationExtensions(OSGi<CachingServiceReference<Object>> extensions) {
        return Whiteboard.onlyValid(Whiteboard.onlySupportedInterfaces(extensions, this._runtime::addInvalidExtension, this._runtime::removeInvalidExtension), this._runtime::addInvalidExtension, this._runtime::removeInvalidExtension).flatMap(extensionReference -> this.chooseApplication((CachingServiceReference<?>)extensionReference, this._runtime::addApplicationDependentExtension, this._runtime::removeApplicationDependentExtension).flatMap(registrator -> this.waitForExtensionDependencies((CachingServiceReference<?>)extensionReference, (CxfJaxrsServiceRegistrator)registrator, er -> this._runtime.addDependentExtensionInApplication(registrator.getProperties(), (CachingServiceReference<?>)er), er -> this._runtime.removeDependentExtensionFromApplication(registrator.getProperties(), (CachingServiceReference<?>)er)).then(this.safeRegisterExtension((CachingServiceReference<?>)extensionReference, (CxfJaxrsServiceRegistrator)registrator))));
    }

    private OSGi<?> applicationResources(OSGi<CachingServiceReference<Object>> resources) {
        return Whiteboard.onlyValid(resources, this._runtime::addInvalidResource, this._runtime::removeInvalidResource).flatMap(resourceReference -> this.chooseApplication((CachingServiceReference<?>)resourceReference, this._runtime::addApplicationDependentResource, this._runtime::removeApplicationDependentResource).flatMap(registrator -> this.waitForExtensionDependencies((CachingServiceReference<?>)resourceReference, (CxfJaxrsServiceRegistrator)registrator, this._runtime::addDependentService, this._runtime::removeDependentService).then(this.safeRegisterEndpoint((CachingServiceReference)resourceReference, (CxfJaxrsServiceRegistrator)registrator))));
    }

    private OSGi<?> getAllServices() {
        OSGi<CachingServiceReference<Application>> applicationsForWhiteboard = this.getApplicationsForWhiteboard();
        return Utils.highestPer(sr -> OSGi.just((Object)AriesJaxrsServiceRuntime.getServiceName(arg_0 -> ((CachingServiceReference)sr).getProperty(arg_0))), this.countChanges(OSGi.all((OSGi[])new OSGi[]{this.getResourcesForWhiteboard(), this.getApplicationExtensionsForWhiteboard(), applicationsForWhiteboard})), this::registerShadowedService, this::unregisterShadowedService).effects(this._runtime::addServiceForName, this._runtime::removedServiceForName).distribute(new Function[]{p -> OSGi.ignore(this.applications((OSGi<CachingServiceReference<Application>>)p.filter(this::isApplication))), p -> OSGi.ignore(this.applicationResources((OSGi<CachingServiceReference<Object>>)p.filter(this::isResource))), p -> OSGi.ignore(this.applicationExtensions((OSGi<CachingServiceReference<Object>>)p.filter(this::isExtension)))});
    }

    private boolean isApplication(CachingServiceReference<?> sr) {
        return _applicationsFilter.match(sr.getServiceReference());
    }

    private boolean isExtension(CachingServiceReference<?> sr) {
        return _extensionsFilter.match(sr.getServiceReference());
    }

    private boolean isResource(CachingServiceReference<?> sr) {
        return _resourcesFilter.match(sr.getServiceReference());
    }

    private <T> boolean matchesWhiteboard(CachingServiceReference<T> ref) {
        Filter filter;
        String target = (String)ref.getProperty("osgi.jaxrs.whiteboard.target");
        if (target == null) {
            return true;
        }
        try {
            filter = FrameworkUtil.createFilter((String)target);
        }
        catch (InvalidSyntaxException ise) {
            if (_log.isErrorEnabled()) {
                _log.error("Invalid '{}' filter syntax in {}", (Object)"osgi.jaxrs.whiteboard.target", ref);
            }
            return false;
        }
        return filter.match(this._runtimeReference);
    }

    private void registerShadowedService(CachingServiceReference<?> sr) {
        if (this.isApplication(sr)) {
            this._runtime.addClashingApplication(sr);
        }
        if (this.isExtension(sr)) {
            this._runtime.addClashingExtension(sr);
        }
        if (this.isResource(sr)) {
            this._runtime.addClashingResource(sr);
        }
    }

    private void unregisterShadowedService(CachingServiceReference<?> sr) {
        if (this.isApplication(sr)) {
            this._runtime.removeClashingApplication(sr);
        }
        if (this.isExtension(sr)) {
            this._runtime.removeClashingExtension(sr);
        }
        if (this.isResource(sr)) {
            this._runtime.removeClashingResource(sr);
        }
    }

    private static <T> OSGi<? extends ResourceProvider> getResourceProvider(ServiceTuple<T> serviceTuple) {
        CachingServiceReference cachingServiceReference = serviceTuple.getCachingServiceReference();
        String scope = Utils.getString(cachingServiceReference.getProperty("service.scope"));
        if (Objects.equals(scope, "prototype")) {
            boolean applicationScoped = Boolean.parseBoolean(Utils.getString(cachingServiceReference.getProperty("org.apache.aries.jax.rs.whiteboard.application.scoped")));
            if (applicationScoped) {
                return OSGi.just((Object)serviceTuple.getServiceObjects().getService()).effects(__ -> {}, arg_0 -> serviceTuple.getServiceObjects().ungetService(arg_0)).map(service -> new SingletonServiceReferenceResourceProvider(cachingServiceReference, service));
            }
            return OSGi.just((Object)new PrototypeServiceReferenceResourceProvider(cachingServiceReference, serviceTuple.getService().getClass(), serviceTuple.getServiceObjects())).effects(__ -> {}, __ -> serviceTuple.dispose(), __ -> {}, __ -> {});
        }
        return OSGi.just((Object)new SingletonServiceReferenceResourceProvider(serviceTuple.getCachingServiceReference(), serviceTuple.getService()));
    }

    private static <T> OSGi<CachingServiceReference<T>> onlyValid(OSGi<CachingServiceReference<T>> serviceReferences, Consumer<CachingServiceReference<T>> onAddingInvalid, Consumer<CachingServiceReference<T>> onRemovingInvalid) {
        return serviceReferences.flatMap(serviceReference -> {
            OSGi error = OSGi.effects(() -> onAddingInvalid.accept((CachingServiceReference)serviceReference), () -> onRemovingInvalid.accept((CachingServiceReference)serviceReference)).effects(LogUtils.ifDebugEnabled(_log, () -> "Invalid service {}"), LogUtils.ifDebugEnabled(_log, () -> "Invalid service {} is gone")).then(OSGi.nothing());
            Object propertyObject = serviceReference.getProperty("osgi.jaxrs.name");
            if (propertyObject != null && !propertyObject.toString().equals(DEFAULT_NAME) && propertyObject.toString().startsWith(".")) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Invalid property {} in service {}", (Object)DEFAULT_NAME, serviceReference);
                }
                return error;
            }
            if (!Whiteboard.testFilters(serviceReference.getProperty("osgi.jaxrs.application.select"))) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Invalid value for property {} in service {}", (Object)"osgi.jaxrs.application.select", serviceReference);
                }
                return error;
            }
            if (!Whiteboard.testFilters(serviceReference.getProperty("osgi.jaxrs.extension.select"))) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Invalid value for property {} in service {}", (Object)"osgi.jaxrs.extension.select", serviceReference);
                }
                return error;
            }
            return OSGi.just((Object)serviceReference);
        });
    }

    private static boolean testFilters(Object propertyObject) {
        if (propertyObject != null) {
            try {
                String[] properties;
                for (String property : properties = Utils.canonicalize(propertyObject)) {
                    FrameworkUtil.createFilter((String)property);
                }
            }
            catch (InvalidSyntaxException e) {
                return false;
            }
        }
        return true;
    }

    private OSGi<ApplicationReferenceWithContext> waitForApplicationContext(OSGi<CachingServiceReference<Application>> application, Consumer<CachingServiceReference<Application>> onWaitingForContext, Consumer<CachingServiceReference<Application>> onResolvedContext) {
        return application.flatMap(serviceReference -> {
            Object propertyObject = serviceReference.getProperty("osgi.http.whiteboard.context.select");
            if (propertyObject == null && (propertyObject = this._configurationMap.get("osgi.http.whiteboard.context.select")) == null) {
                return OSGi.just((Object)new ApplicationReferenceWithContext(null, (CachingServiceReference<Application>)serviceReference));
            }
            String contextSelect = propertyObject.toString();
            try {
                FrameworkUtil.createFilter((String)contextSelect);
            }
            catch (InvalidSyntaxException e) {
                return OSGi.effects(() -> this._runtime.addInvalidApplication((CachingServiceReference<?>)serviceReference), () -> this._runtime.removeInvalidApplication((CachingServiceReference<?>)serviceReference)).then(OSGi.nothing());
            }
            return OSGi.effects(() -> onWaitingForContext.accept((CachingServiceReference<Application>)serviceReference), () -> onResolvedContext.accept((CachingServiceReference<Application>)serviceReference)).then(org.apache.aries.component.dsl.Utils.highest((OSGi)OSGi.serviceReferences(ServletContextHelper.class, (String)contextSelect)).flatMap(sr -> OSGi.just((Object)new ApplicationReferenceWithContext((CachingServiceReference<ServletContextHelper>)sr, (CachingServiceReference<Application>)serviceReference))).effects(__ -> onResolvedContext.accept((CachingServiceReference<Application>)serviceReference), __ -> onWaitingForContext.accept((CachingServiceReference<Application>)serviceReference)));
        });
    }

    private OSGi<?> applications(OSGi<CachingServiceReference<Application>> applications) {
        OSGi<CachingServiceReference<Application>> validApplications = Whiteboard.onlyValid(applications, this._runtime::addInvalidApplication, this._runtime::removeInvalidApplication);
        OSGi<ApplicationReferenceWithContext> applicationsWithContext = this.waitForApplicationContext(validApplications, this._runtime::addContextDependentApplication, this._runtime::removeContextDependentApplication);
        OSGi<ApplicationReferenceWithContext> highestRankedPerPath = Utils.highestPer(arwc -> OSGi.just((Object)arwc.getActualBasePath()), applicationsWithContext, t -> this._runtime.addShadowedApplication(t.getApplicationReference(), t.getActualBasePath()), t -> this._runtime.removeShadowedApplication(t.getApplicationReference()));
        return highestRankedPerPath.flatMap(application -> Utils.onlyGettables(this.waitForReadyService((OSGi<CachingServiceReference<Application>>)OSGi.just(application.getApplicationReference())), this._runtime::addNotGettableApplication, this._runtime::removeNotGettableApplication, _log).recoverWith((t, e) -> OSGi.just((Object)t).map(ServiceTuple::getCachingServiceReference).effects(this._runtime::addErroredApplication, this._runtime::removeErroredApplication).then(OSGi.nothing())).effects(__ -> {}, this::clearApplicationState).flatMap(at -> this.deployApplication((ServiceTuple<Application>)at, application.getContextReference()).foreach(registrator -> this._runtime.setApplicationForPath(this.getApplicationBase(arg_0 -> at.getCachingServiceReference().getProperty(arg_0)), (CachingServiceReference<Application>)at.getCachingServiceReference(), (CxfJaxrsServiceRegistrator)registrator), registrator -> this._runtime.unsetApplicationForPath(this.getApplicationBase(arg_0 -> at.getCachingServiceReference().getProperty(arg_0))))));
    }

    private ExtensionManagerBus createBus(Map<String, ServiceTuple<Object>> extensions) {
        BundleWiring wiring = (BundleWiring)this._bundleContext.getBundle().adapt(BundleWiring.class);
        HashMap properties = new HashMap(this._configurationMap);
        properties.putIfAbsent("replace.loopback.address.with.localhost", "false");
        HashMap cxfExtensions = new HashMap();
        if (extensions.isEmpty()) {
            cxfExtensions = null;
        } else {
            for (Map.Entry<String, ServiceTuple<Object>> entry : extensions.entrySet()) {
                String className = entry.getKey();
                ServiceTuple<Object> serviceTuple = entry.getValue();
                ClassLoader classLoader = this.getClassLoader(serviceTuple);
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    cxfExtensions.put(clazz, serviceTuple.getService());
                }
                catch (Exception e) {
                    if (!_log.isErrorEnabled()) continue;
                    _log.error("Could not load extension for CXF bus", (Throwable)e);
                }
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Creating CXF Bus with extensions {} and properties {}", extensions, properties);
        }
        ExtensionManagerBus bus = new ExtensionManagerBus(cxfExtensions, properties, wiring.getClassLoader());
        bus.initialize();
        if (_log.isDebugEnabled()) {
            _log.debug("Created CXF Bus with extensions {} and properties {}", extensions, properties);
        }
        return bus;
    }

    private void clearApplicationState(ServiceTuple<Application> tuple) {
        CachingServiceReference<Application> cachingServiceReference = tuple.getCachingServiceReference();
        this._runtime.unregisterApplicationExtensions(cachingServiceReference);
    }

    private OSGi<CxfJaxrsServiceRegistrator> applicationMatching(String filter) {
        return this._applicationRegistry.waitForService(filter);
    }

    private OSGi<CxfJaxrsServiceRegistrator> deployApplication(ServiceTuple<Application> tuple, CachingServiceReference<ServletContextHelper> contextReference) {
        CachingServiceReference<Application> serviceReference = tuple.getCachingServiceReference();
        Map<String, Object> properties = Utils.getApplicationProperties(serviceReference);
        properties.put("original.service.id", serviceReference.getProperty("service.id"));
        properties.put("original.service.bundleid", serviceReference.getProperty("service.bundleid"));
        return this.getCxfExtensions(tuple.getCachingServiceReference()).flatMap(extensions -> this.createRegistrator((Map<String, ServiceTuple<Object>>)extensions, tuple, properties).flatMap(registrator -> this.waitForApplicationDependencies(tuple.getCachingServiceReference(), this._applicationRegistry.registerService((CxfJaxrsServiceRegistrator)registrator, registrator.getProperties())).then(this.registerCXFServletService(registrator.getBus(), properties, contextReference).then(OSGi.just((Object)registrator)))));
    }

    public OSGi<Map<String, ServiceTuple<Object>>> getCxfExtensions(CachingServiceReference<Application> applicationReference) {
        OSGi cxfExtensionsForApplication = Utils.onlyGettables(OSGi.serviceReferences((String)"(cxf.extension=true)").filter(sr -> {
            Object appFilter = sr.getProperty("osgi.jaxrs.application.select");
            if (appFilter == null) {
                return true;
            }
            try {
                Filter filter = FrameworkUtil.createFilter((String)appFilter.toString());
                return filter.match(applicationReference.getServiceReference());
            }
            catch (InvalidSyntaxException e) {
                return false;
            }
        }).filter(this::matchesWhiteboard), __ -> {}, __ -> {}, _log);
        return org.apache.aries.component.dsl.Utils.accumulateInMap(cxfExtensionsForApplication, st -> OSGi.just(Arrays.asList(Utils.canonicalize(st.getCachingServiceReference().getProperty("objectClass")))), OSGi::just);
    }

    private ClassLoader getClassLoader(ServiceTuple<?> serviceTuple) {
        return ((BundleWiring)serviceTuple.getCachingServiceReference().getServiceReference().getBundle().adapt(BundleWiring.class)).getClassLoader();
    }

    private OSGi<CxfJaxrsServiceRegistrator> createRegistrator(Map<String, ServiceTuple<Object>> extensions, ServiceTuple<Application> tuple, Map<String, Object> props) {
        return OSGi.just(() -> new CxfJaxrsServiceRegistrator((Bus)this.createBus(extensions), tuple, props, this._runtime)).effects(__ -> {}, CxfJaxrsServiceRegistrator::enable, CxfJaxrsServiceRegistrator::close, __ -> {});
    }

    private OSGi<CachingServiceReference<Object>> getApplicationExtensionsForWhiteboard() {
        return OSGi.serviceReferences((String)_extensionsFilter.toString()).filter(this::matchesWhiteboard);
    }

    private OSGi<CachingServiceReference<Application>> getApplicationsForWhiteboard() {
        return OSGi.serviceReferences(Application.class, (String)_applicationsFilter.toString()).filter(this::matchesWhiteboard);
    }

    private String getApplicationReadyServiceFilter(CachingServiceReference<Application> reference) {
        Object applicationReadyServiceFilter = this._configurationMap.get("application.ready.service.filter");
        if (applicationReadyServiceFilter == null) {
            applicationReadyServiceFilter = reference.getProperty("application.ready.service.filter");
        }
        if (applicationReadyServiceFilter != null) {
            return String.valueOf(applicationReadyServiceFilter);
        }
        return null;
    }

    private OSGi<CachingServiceReference<Object>> getResourcesForWhiteboard() {
        return OSGi.serviceReferences((String)_resourcesFilter.toString()).filter(this::matchesWhiteboard);
    }

    private OSGi<ServiceRegistration<Application>> registerDefaultApplication() {
        return OSGi.register(Application.class, DefaultApplication::new, () -> {
            Object defaultApplicationBase = this._configurationMap.get("default.application.base");
            if (defaultApplicationBase == null || !(defaultApplicationBase instanceof String)) {
                defaultApplicationBase = "/";
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            Utils.mergePropertyMaps(properties, this._configurationMap);
            properties.put("osgi.jaxrs.name", DEFAULT_NAME);
            properties.put("osgi.jaxrs.application.base", defaultApplicationBase);
            properties.put("service.ranking", Integer.MIN_VALUE);
            properties.put("osgi.jaxrs.whiteboard.target", "(service.pid=" + this._configurationMap.get("service.pid") + ")");
            return properties;
        });
    }

    private ServiceRegistration<JaxrsServiceRuntime> registerJaxRSServiceRuntime(Map<String, Object> properties) {
        properties.putIfAbsent("service.ranking", Integer.MIN_VALUE);
        return this._bundleContext.registerService(JaxrsServiceRuntime.class, (Object)this._runtime, new Hashtable<String, Object>(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHttpEndpoints(List<String> endpoints) {
        ServiceRegistration<JaxrsServiceRuntime> serviceRegistration = this._runtimeRegistration;
        synchronized (serviceRegistration) {
            this._endpoints.removeAll(endpoints);
            Utils.updateProperty(this._runtimeRegistration, "osgi.jaxrs.endpoint", this._endpoints);
        }
    }

    private <T> OSGi<?> safeRegisterEndpoint(CachingServiceReference<T> serviceReference, CxfJaxrsServiceRegistrator registrator) {
        Map<String, ?> properties = registrator.getProperties();
        Bundle originalBundle = this._bundleContext.getBundle(((Long)Long.class.cast(properties.get("service.bundleid"))).longValue());
        return OSGi.changeContext((BundleContext)originalBundle.getBundleContext(), Utils.onlyGettables(OSGi.just(serviceReference), this._runtime::addNotGettableEndpoint, this._runtime::removeNotGettableEndpoint, _log)).recoverWith((t, e) -> OSGi.just((Object)serviceReference).effects(this._runtime::addErroredEndpoint, this._runtime::removeErroredEndpoint).effects(LogUtils.ifErrorEnabled(_log, () -> "ServiceReference {} for endpoint produced error: {}", e), LogUtils.ifErrorEnabled(_log, () -> "Errored ServiceReference {} for endpoint left")).then(OSGi.nothing())).flatMap(Whiteboard::getResourceProvider).effects(rp -> this._runtime.addApplicationEndpoint(properties::get, serviceReference, registrator.getBus(), rp.getResourceClass()), rp -> this._runtime.removeApplicationEndpoint(properties::get, serviceReference)).effects(registrator::add, registrator::remove).effects(LogUtils.ifDebugEnabled(_log, () -> "Registered endpoint " + serviceReference.getServiceReference() + " into application " + AriesJaxrsServiceRuntime.getServiceName(properties::get)), LogUtils.ifDebugEnabled(_log, () -> "Unregistered endpoint " + serviceReference.getServiceReference() + " from application " + AriesJaxrsServiceRuntime.getServiceName(properties::get)));
    }

    private OSGi<?> safeRegisterExtension(CachingServiceReference<?> serviceReference, CxfJaxrsServiceRegistrator registrator) {
        Map<String, ?> properties = registrator.getProperties();
        Bundle originalBundle = this._bundleContext.getBundle(((Long)Long.class.cast(properties.get("service.bundleid"))).longValue());
        return OSGi.just(() -> AriesJaxrsServiceRuntime.getServiceName(properties::get)).flatMap(applicationName -> OSGi.changeContext((BundleContext)originalBundle.getBundleContext(), Utils.onlyGettables(OSGi.just((Object)serviceReference), this._runtime::addNotGettableExtension, this._runtime::removeNotGettableExtension, _log)).recoverWith((t, e) -> OSGi.just(t.getCachingServiceReference()).effects(this._runtime::addErroredExtension, this._runtime::removeErroredExtension).effects(LogUtils.ifErrorEnabled(_log, () -> "ServiceReference {} for extension produced error: {}", e), LogUtils.ifErrorEnabled(_log, () -> "Errored ServiceReference {} for extension left")).then(OSGi.nothing())).effects(registrator::addProvider, registrator::removeProvider).effects(t -> this._runtime.addApplicationExtension(properties::get, serviceReference, t.getService().getClass()), __ -> this._runtime.removeApplicationExtension(properties::get, serviceReference)).effects(LogUtils.ifDebugEnabled(_log, () -> "Registered extension " + serviceReference.getServiceReference() + " into application " + AriesJaxrsServiceRuntime.getServiceName(properties::get)), LogUtils.ifDebugEnabled(_log, () -> "Unregistered extension  " + serviceReference.getServiceReference() + " from application " + AriesJaxrsServiceRuntime.getServiceName(properties::get))).effects(__ -> registrator.registerExtension(serviceReference), __ -> registrator.unregisterExtension(serviceReference)));
    }

    private OSGi<CxfJaxrsServiceRegistrator> waitForApplicationDependencies(CachingServiceReference<Application> applicationReference, OSGi<CxfJaxrsServiceRegistrator> registrators) {
        return registrators.flatMap(registrator -> {
            String[] extensionDependencies = Utils.canonicalize(applicationReference.getProperty("osgi.jaxrs.extension.select"));
            OSGi program = OSGi.just((Object)registrator);
            if (extensionDependencies.length == 0) {
                return program;
            }
            for (String extensionDependency : extensionDependencies) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Application {} has a dependency on {}", registrator, (Object)extensionDependency);
                }
                try {
                    Filter extensionFilter = this._bundleContext.createFilter(extensionDependency);
                    if (extensionFilter.match(this._runtimeReference)) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug("Application dependency {} provided by whiteboard {}", (Object)extensionDependency, this._runtimeReference);
                        continue;
                    }
                }
                catch (InvalidSyntaxException e) {
                    return program.effects(LogUtils.ifErrorEnabled(_log, () -> String.format("Application %s has invalid dependency %s", registrator, extensionDependency)), LogUtils.ifErrorEnabled(_log, () -> String.format("Application %s with invalid dependency has left", registrator))).effects(__ -> this._runtime.addErroredApplication(applicationReference), __ -> this._runtime.removeErroredApplication(applicationReference)).then(OSGi.nothing());
                }
                program = OSGi.once((OSGi)registrator.waitForExtension(extensionDependency).flatMap(sr -> {
                    Filter filter;
                    Object applicationSelectProperty = sr.getProperty("osgi.jaxrs.application.select");
                    if (applicationSelectProperty == null) {
                        return OSGi.just((Object)registrator);
                    }
                    try {
                        filter = this._bundleContext.createFilter(applicationSelectProperty.toString());
                    }
                    catch (InvalidSyntaxException e) {
                        return OSGi.nothing();
                    }
                    if (filter.match(applicationReference.getServiceReference())) {
                        return OSGi.just((Object)registrator);
                    }
                    return OSGi.nothing();
                })).effects(__ -> {}, __ -> this._runtime.addDependentApplication(applicationReference)).effects(LogUtils.ifDebugEnabled(_log, () -> "Application " + registrator + " dependency " + extensionDependency + " has been fullfiled"), LogUtils.ifDebugEnabled(_log, () -> "Application " + registrator + " dependency " + extensionDependency + " has gone")).then(program);
            }
            program = OSGi.effects(() -> this._runtime.addDependentApplication(applicationReference), () -> this._runtime.removeDependentApplication(applicationReference)).then(program);
            program = program.effects(__ -> this._runtime.removeDependentApplication(applicationReference), __ -> {});
            return program;
        });
    }

    private OSGi<CachingServiceReference<Application>> waitForReadyService(OSGi<CachingServiceReference<Application>> program) {
        return program.flatMap(reference -> {
            String applicationReadyServiceFilter = this.getApplicationReadyServiceFilter((CachingServiceReference<Application>)reference);
            if (applicationReadyServiceFilter != null) {
                return OSGi.effects(() -> this._runtime.addDependentApplication((CachingServiceReference<Application>)reference), () -> this._runtime.removeDependentApplication((CachingServiceReference<Application>)reference)).then(OSGi.once((OSGi)OSGi.serviceReferences((String)applicationReadyServiceFilter)).effects(LogUtils.ifDebugEnabled(_log, () -> "Ready service for " + reference + " has been tracked"), LogUtils.ifDebugEnabled(_log, () -> "Ready service for " + reference + " is gone")).then(OSGi.just((Object)reference).effects(__ -> {}, __ -> this._runtime.addDependentApplication((CachingServiceReference<Application>)reference)))).effects(this._runtime::removeDependentApplication, __ -> {});
            }
            return OSGi.just((Object)reference);
        });
    }

    private OSGi<?> waitForExtensionDependencies(CachingServiceReference<?> reference, CxfJaxrsServiceRegistrator cxfJaxrsServiceRegistrator, Consumer<CachingServiceReference<?>> onAddingDependent, Consumer<CachingServiceReference<?>> onRemovingDependent) {
        Map<String, ?> applicationRegistratorProperties = cxfJaxrsServiceRegistrator.getProperties();
        String[] extensionDependencies = Utils.canonicalize(reference.getProperty("osgi.jaxrs.extension.select"));
        OSGi program = OSGi.just(reference);
        if (extensionDependencies.length == 0) {
            return program;
        }
        for (String extensionDependency : extensionDependencies) {
            if (_log.isDebugEnabled()) {
                _log.debug("Extension {} has a dependency on {}", reference, (Object)extensionDependency);
            }
            try {
                String finalExtensionDependency = extensionDependency.replace("(objectClass=", "(original.objectClass=");
                Filter extensionFilter = this._bundleContext.createFilter(finalExtensionDependency);
                if (extensionFilter.match(this._runtimeReference) || extensionFilter.matches(applicationRegistratorProperties)) continue;
                program = OSGi.once((OSGi)cxfJaxrsServiceRegistrator.waitForExtension(extensionDependency).effects(__ -> {}, __ -> onAddingDependent.accept(reference))).effects(LogUtils.ifDebugEnabled(_log, () -> "Extension " + reference + " dependency " + extensionDependency + " has been fullfiled"), LogUtils.ifDebugEnabled(_log, () -> "Extension " + reference + " dependency " + extensionDependency + " has gone")).then(program);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        program = OSGi.effects(() -> onAddingDependent.accept(reference), () -> onRemovingDependent.accept(reference)).then(program);
        program = program.effects(__ -> onRemovingDependent.accept(reference), __ -> {});
        return program;
    }

    String getApplicationBase(PropertyHolder properties) {
        return this._applicationBasePrefix + Utils.getString(properties.get("osgi.jaxrs.application.base"));
    }

    private OSGi<CxfJaxrsServiceRegistrator> chooseApplication(CachingServiceReference<?> serviceReference, Consumer<CachingServiceReference<?>> onWaiting, Consumer<CachingServiceReference<?>> onResolved) {
        Object applicationSelectProperty = serviceReference.getProperty("osgi.jaxrs.application.select");
        if (applicationSelectProperty == null) {
            return this.applicationMatching(String.format("(%s=%s)", "osgi.jaxrs.name", DEFAULT_NAME));
        }
        return OSGi.just(AtomicInteger::new).flatMap(counter -> OSGi.effects(() -> onWaiting.accept(serviceReference), () -> {
            onResolved.accept(serviceReference);
            counter.set(0);
        }).then(this.applicationMatching(applicationSelectProperty.toString()).effects(__ -> {
            if (counter.getAndIncrement() == 0) {
                onResolved.accept(serviceReference);
            }
        }, __ -> {
            if (counter.decrementAndGet() == 0) {
                onWaiting.accept(serviceReference);
            }
        })));
    }

    private <T> OSGi<T> countChanges(OSGi<T> program) {
        return program.effects(__ -> {}, __ -> this._counter.inc(), __ -> {}, __ -> this._counter.inc());
    }

    private static CXFNonSpringServlet createCXFServlet(Bus bus) {
        CXFNonSpringServlet cxfNonSpringServlet = new CXFNonSpringServlet(){

            public void destroyBus() {
            }
        };
        cxfNonSpringServlet.setBus(bus);
        return cxfNonSpringServlet;
    }

    private static OSGi<CachingServiceReference<Object>> onlySupportedInterfaces(OSGi<CachingServiceReference<Object>> program, Consumer<CachingServiceReference<?>> onInvalidAdded, Consumer<CachingServiceReference<?>> onInvalidRemoved) {
        return program.flatMap(sr -> {
            if (Whiteboard.signalsValidInterface((CachingServiceReference<Object>)sr)) {
                return OSGi.just((Object)sr);
            }
            return OSGi.effects(() -> onInvalidAdded.accept((CachingServiceReference<?>)sr), () -> onInvalidRemoved.accept((CachingServiceReference<?>)sr)).then(OSGi.nothing());
        });
    }

    private OSGi<ServiceRegistration<Servlet>> registerCXFServletService(final Bus bus, Map<String, Object> serviceProperties, CachingServiceReference<ServletContextHelper> contextReference) {
        Supplier<Map> contextPropertiesSup;
        String address = Utils.canonicalizeAddress(this.getApplicationBase(serviceProperties::get));
        String applicationName = AriesJaxrsServiceRuntime.getServiceName(serviceProperties::get);
        OSGi program = OSGi.effects((Runnable)OSGi.NOOP, (Runnable)OSGi.NOOP);
        if (contextReference == null) {
            contextPropertiesSup = () -> {
                HashMap<String, Object> contextProperties = new HashMap<String, Object>();
                Utils.mergePropertyMaps(contextProperties, serviceProperties);
                Utils.mergePropertyMaps(contextProperties, this._configurationMap);
                contextProperties.putIfAbsent("osgi.http.whiteboard.target", "(osgi.http.endpoint=*)");
                String contextName = "".equals(address) ? "default" : "context.for" + applicationName;
                contextProperties.put("osgi.http.whiteboard.context.name", contextName);
                contextProperties.put("osgi.http.whiteboard.context.path", address.equals("") ? "/" : address);
                return contextProperties;
            };
            if (!"".equals(address)) {
                program = OSGi.register(ServletContextHelper.class, () -> new ServletContextHelper(this._bundleContext.getBundle(((Long)serviceProperties.get("original.service.bundleid")).longValue())){}, contextPropertiesSup);
            }
        } else {
            contextPropertiesSup = () -> {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("osgi.http.whiteboard.context.name", contextReference.getProperty("osgi.http.whiteboard.context.name"));
                return properties;
            };
        }
        Supplier<Map> servletPropertiesSup = () -> {
            HashMap<String, Object> servletProperties = new HashMap<String, Object>();
            Utils.mergePropertyMaps(servletProperties, serviceProperties);
            Utils.mergePropertyMaps(servletProperties, this._configurationMap);
            Map contextProperties = (Map)contextPropertiesSup.get();
            servletProperties.put("osgi.http.whiteboard.context.select", String.format("(%s=%s)", "osgi.http.whiteboard.context.name", contextProperties.get("osgi.http.whiteboard.context.name")));
            servletProperties.putIfAbsent("osgi.http.whiteboard.target", "(osgi.http.endpoint=*)");
            servletProperties.putIfAbsent("servlet.init.hide-service-list-page", "true");
            if (contextReference == null) {
                servletProperties.put("osgi.http.whiteboard.servlet.pattern", "/*");
            } else {
                servletProperties.put("osgi.http.whiteboard.servlet.pattern", address + "/*");
            }
            servletProperties.put("osgi.http.whiteboard.servlet.asyncSupported", true);
            servletProperties.put("osgi.http.whiteboard.servlet.name", "cxf-servlet");
            return servletProperties;
        };
        return program.then(OSGi.register(Servlet.class, (ServiceFactory)new PrototypeServiceFactory<Servlet>(){

            public Servlet getService(Bundle bundle, ServiceRegistration<Servlet> registration) {
                return Whiteboard.createCXFServlet(bus);
            }

            public void ungetService(Bundle bundle, ServiceRegistration<Servlet> registration, Servlet service) {
            }
        }, servletPropertiesSup));
    }

    private static boolean signalsValidInterface(CachingServiceReference<Object> serviceReference) {
        String[] objectClasses = Utils.canonicalize(serviceReference.getProperty("objectClass"));
        return Arrays.stream(objectClasses).anyMatch(SUPPORTED_EXTENSION_INTERFACES::containsKey);
    }

    static {
        try {
            _applicationsFilter = FrameworkUtil.createFilter((String)String.format("(&(objectClass=%s)(%s=*))", Application.class.getName(), "osgi.jaxrs.application.base"));
            _extensionsFilter = FrameworkUtil.createFilter((String)String.format("(%s=true)", "osgi.jaxrs.extension"));
            _resourcesFilter = FrameworkUtil.createFilter((String)String.format("(%s=true)", "osgi.jaxrs.resource"));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private class ApplicationReferenceWithContext
    implements Comparable<ApplicationReferenceWithContext> {
        private CachingServiceReference<ServletContextHelper> _contextReference;
        private CachingServiceReference<Application> _applicationReference;

        @Override
        public int compareTo(ApplicationReferenceWithContext o) {
            return this._applicationReference.compareTo(o._applicationReference);
        }

        public ApplicationReferenceWithContext(CachingServiceReference<ServletContextHelper> contextReference, CachingServiceReference<Application> applicationReference) {
            this._contextReference = contextReference;
            this._applicationReference = applicationReference;
        }

        public String getActualBasePath() {
            String applicationBase = Whiteboard.this.getApplicationBase(arg_0 -> this._applicationReference.getProperty(arg_0));
            if (this._contextReference == null) {
                return applicationBase;
            }
            Object property = this._contextReference.getProperty("osgi.http.whiteboard.context.path");
            if (property == null) {
                return applicationBase;
            }
            String contextPath = property.toString();
            return contextPath + applicationBase;
        }

        public CachingServiceReference<ServletContextHelper> getContextReference() {
            return this._contextReference;
        }

        public CachingServiceReference<Application> getApplicationReference() {
            return this._applicationReference;
        }
    }

    private static class ServiceRegistrationChangeCounter
    implements ChangeCounter {
        private static final String changecount = "service.changecount";
        private final AtomicLong _atomicLong = new AtomicLong();
        private final ServiceRegistration<?> _serviceRegistration;

        ServiceRegistrationChangeCounter(ServiceRegistration<?> serviceRegistration) {
            this._serviceRegistration = serviceRegistration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void inc() {
            long l = this._atomicLong.incrementAndGet();
            ServiceRegistration<?> serviceRegistration = this._serviceRegistration;
            synchronized (serviceRegistration) {
                Utils.updateProperty(this._serviceRegistration, changecount, l);
            }
        }
    }

    private static interface ChangeCounter {
        public void inc();
    }
}

