/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.MediaType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.jax.rs.whiteboard.internal.Whiteboard;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.CxfJaxrsServiceRegistrator;
import org.apache.aries.jax.rs.whiteboard.internal.introspection.ClassIntrospector;
import org.apache.aries.jax.rs.whiteboard.internal.utils.PropertyHolder;
import org.apache.aries.jax.rs.whiteboard.internal.utils.Utils;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.osgi.service.jaxrs.runtime.dto.ApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.BaseDTO;
import org.osgi.service.jaxrs.runtime.dto.BaseExtensionDTO;
import org.osgi.service.jaxrs.runtime.dto.ExtensionDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedExtensionDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceMethodInfoDTO;
import org.osgi.service.jaxrs.runtime.dto.RuntimeDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AriesJaxrsServiceRuntime
implements JaxrsServiceRuntime {
    private static final Logger _log = LoggerFactory.getLogger(AriesJaxrsServiceRuntime.class);
    private ConcurrentHashMap<String, CachingServiceReference<?>> _servicesForName = new ConcurrentHashMap();
    private Whiteboard _whiteboard;
    private Set<CachingServiceReference<?>> _applicationDependentExtensions = ConcurrentHashMap.newKeySet();
    private Set<CachingServiceReference<?>> _applicationDependentResources = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<String, Collection<EndpointRuntimeInformation>> _applicationEndpoints = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Collection<ExtensionRuntimeInformation>> _applicationExtensions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ApplicationRuntimeInformation> _applications = new ConcurrentHashMap();
    private Collection<CachingServiceReference<?>> _clashingApplications = new CopyOnWriteArrayList();
    private Collection<CachingServiceReference<?>> _clashingExtensions = new CopyOnWriteArrayList();
    private Collection<CachingServiceReference<?>> _clashingResources = new CopyOnWriteArrayList();
    private Set<CachingServiceReference<Application>> _contextDependentApplications = ConcurrentHashMap.newKeySet();
    private volatile ApplicationRuntimeInformation _defaultApplicationProperties;
    private Set<CachingServiceReference<Application>> _dependentApplications = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<String, Collection<CachingServiceReference<?>>> _dependentExtensions = new ConcurrentHashMap();
    private Set<CachingServiceReference<?>> _dependentServices = ConcurrentHashMap.newKeySet();
    private Collection<CachingServiceReference<Application>> _erroredApplications = new CopyOnWriteArrayList<CachingServiceReference<Application>>();
    private Collection<CachingServiceReference<?>> _erroredEndpoints = new CopyOnWriteArrayList();
    private Collection<CachingServiceReference<?>> _erroredExtensions = new CopyOnWriteArrayList();
    private Collection<CachingServiceReference<?>> _invalidApplications = new CopyOnWriteArrayList();
    private Collection<CachingServiceReference<?>> _invalidExtensions = new CopyOnWriteArrayList();
    private Collection<CachingServiceReference<?>> _invalidResources = new CopyOnWriteArrayList();
    private Collection<CachingServiceReference<Application>> _shadowedApplications = new CopyOnWriteArrayList<CachingServiceReference<Application>>();
    private Collection<CachingServiceReference<Application>> _ungettableApplications = new CopyOnWriteArrayList<CachingServiceReference<Application>>();
    private Collection<CachingServiceReference<?>> _ungettableEndpoints = new CopyOnWriteArrayList();
    private Collection<CachingServiceReference<?>> _ungettableExtensions = new CopyOnWriteArrayList();

    public AriesJaxrsServiceRuntime(Whiteboard whiteboard) {
        this._whiteboard = whiteboard;
    }

    public static String getServiceName(PropertyHolder properties) {
        Object property = properties.get("osgi.jaxrs.name");
        if (property == null) {
            return Utils.generateApplicationName(properties);
        }
        return property.toString();
    }

    public void addApplicationDependentExtension(CachingServiceReference<?> cachingServiceReference) {
        this._applicationDependentExtensions.add(cachingServiceReference);
    }

    public void addApplicationDependentResource(CachingServiceReference<?> cachingServiceReference) {
        this._applicationDependentResources.add(cachingServiceReference);
    }

    public void addApplicationEndpoint(PropertyHolder registratorReference, CachingServiceReference<?> endpointImmutableServiceReference, Bus bus, Class<?> theClass) {
        this._applicationEndpoints.compute(AriesJaxrsServiceRuntime.getServiceName(registratorReference), AriesJaxrsServiceRuntime.merger(new EndpointRuntimeInformation(endpointImmutableServiceReference, bus, theClass)));
        if (_log.isDebugEnabled()) {
            _log.debug("Resource service {} has been registered into application {}", endpointImmutableServiceReference, registratorReference.get("original.service.id"));
        }
    }

    public void addApplicationExtension(PropertyHolder registratorProperties, CachingServiceReference<?> extensionImmutableServiceReference, Class<?> theClass) {
        this._applicationExtensions.compute(AriesJaxrsServiceRuntime.getServiceName(registratorProperties), AriesJaxrsServiceRuntime.merger(new ExtensionRuntimeInformation(extensionImmutableServiceReference, theClass)));
        if (_log.isDebugEnabled()) {
            _log.debug("Extension {} has been registered to application {}", extensionImmutableServiceReference, registratorProperties.get("original.service.id"));
        }
    }

    public void addClashingApplication(CachingServiceReference<?> serviceReference) {
        this._clashingApplications.add(serviceReference);
        String serviceName = AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0));
        if (_log.isDebugEnabled()) {
            _log.debug("Application {} clashes with {} for name {}", new Object[]{serviceReference, this._servicesForName.get(serviceName), serviceName});
        }
    }

    public void addClashingExtension(CachingServiceReference<?> serviceReference) {
        this._clashingExtensions.add(serviceReference);
        String serviceName = AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0));
        if (_log.isDebugEnabled()) {
            _log.debug("Extension {} clashes with {} for name {}", new Object[]{serviceReference, this._servicesForName.get(serviceName), serviceName});
        }
    }

    public void addClashingResource(CachingServiceReference<?> serviceReference) {
        this._clashingResources.add(serviceReference);
        String serviceName = AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0));
        if (_log.isDebugEnabled()) {
            _log.debug("Resource {} clashes with {} for name {}", new Object[]{serviceReference, this._servicesForName.get(serviceName), serviceName});
        }
    }

    public void addContextDependentApplication(CachingServiceReference<Application> serviceReference) {
        this._contextDependentApplications.add(serviceReference);
        if (_log.isDebugEnabled()) {
            _log.debug("Application {} depends on context filter {}", serviceReference, serviceReference.getProperty("osgi.http.whiteboard.context.select"));
        }
    }

    public void addDependentApplication(CachingServiceReference<Application> applicationReference) {
        this._dependentApplications.add(applicationReference);
    }

    public void addDependentExtensionInApplication(Map<String, ?> applicationReference, CachingServiceReference<?> cachingServiceReference) {
        this._dependentExtensions.compute(AriesJaxrsServiceRuntime.getServiceName(applicationReference::get), AriesJaxrsServiceRuntime.merger(cachingServiceReference));
    }

    public void addDependentService(CachingServiceReference<?> serviceReference) {
        this._dependentServices.add(serviceReference);
    }

    public void addErroredApplication(CachingServiceReference<Application> serviceReference) {
        this._erroredApplications.add(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Application {} is registered with error", serviceReference);
        }
    }

    public <T> void addErroredEndpoint(CachingServiceReference<T> serviceReference) {
        if (_log.isWarnEnabled()) {
            _log.warn("Resource {} is registered with error", serviceReference);
        }
        this._erroredEndpoints.add(serviceReference);
    }

    public void addErroredExtension(CachingServiceReference<?> cachingServiceReference) {
        if (_log.isWarnEnabled()) {
            _log.warn("Extension {} is registered with error", cachingServiceReference);
        }
        this._erroredExtensions.add(cachingServiceReference);
    }

    public void addInvalidApplication(CachingServiceReference<?> serviceReference) {
        if (_log.isWarnEnabled()) {
            _log.warn("Application {} is not valid", serviceReference);
        }
        this._invalidApplications.add(serviceReference);
    }

    public void addInvalidExtension(CachingServiceReference<?> serviceReference) {
        if (_log.isWarnEnabled()) {
            _log.warn("Extension {} is not valid", serviceReference);
        }
        this._invalidExtensions.add(serviceReference);
    }

    public void addInvalidResource(CachingServiceReference<?> serviceReference) {
        if (_log.isWarnEnabled()) {
            _log.warn("Resource {} is not valid", serviceReference);
        }
        this._invalidResources.add(serviceReference);
    }

    public boolean addNotGettableApplication(CachingServiceReference<Application> serviceReference) {
        if (_log.isWarnEnabled()) {
            _log.warn("Application from reference {} can't be got", serviceReference);
        }
        return this._ungettableApplications.add(serviceReference);
    }

    public <T> boolean addNotGettableEndpoint(CachingServiceReference<T> serviceReference) {
        if (_log.isWarnEnabled()) {
            _log.warn("Resource from reference {} can't be got", serviceReference);
        }
        return this._ungettableEndpoints.add(serviceReference);
    }

    public <T> void addNotGettableExtension(CachingServiceReference<T> serviceReference) {
        if (_log.isWarnEnabled()) {
            _log.warn("Extension from reference {} can't be got", serviceReference);
        }
        this._ungettableExtensions.add(serviceReference);
    }

    public void addServiceForName(CachingServiceReference<?> serviceReference) {
        this._servicesForName.put(AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0)), serviceReference);
        if (_log.isDebugEnabled()) {
            _log.debug("Registered service {} for name {}", serviceReference, (Object)AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0)));
        }
    }

    public boolean addShadowedApplication(CachingServiceReference<Application> serviceReference, String actualBasePath) {
        ApplicationRuntimeInformation applicationRuntimeInformation;
        if (_log.isDebugEnabled() && (applicationRuntimeInformation = this._applications.get(actualBasePath)) != null) {
            _log.debug("Application reference {} is shadowed by {}", serviceReference, applicationRuntimeInformation._cachingServiceReference);
        }
        return this._shadowedApplications.add(serviceReference);
    }

    public RuntimeDTO getRuntimeDTO() {
        RuntimeDTO runtimeDTO = new RuntimeDTO();
        if (this._defaultApplicationProperties != null) {
            runtimeDTO.defaultApplication = this.buildApplicationDTO(this._defaultApplicationProperties);
        }
        runtimeDTO.applicationDTOs = (ApplicationDTO[])this.applicationDTOStream().toArray(ApplicationDTO[]::new);
        runtimeDTO.failedApplicationDTOs = (FailedApplicationDTO[])Stream.concat(this.contextDependentApplicationsDTOStream(), Stream.concat(this.invalidApplicationsDTOStream(), Stream.concat(this.shadowedApplicationsDTOStream(), Stream.concat(this.unreferenciableApplicationsDTOStream(), Stream.concat(this.clashingApplicationsDTOStream(), Stream.concat(this.dependentApplicationsDTOStream(), this.erroredApplicationsDTOStream())))))).toArray(FailedApplicationDTO[]::new);
        runtimeDTO.failedResourceDTOs = (FailedResourceDTO[])Stream.concat(this.invalidResourcesDTOStream(), Stream.concat(this.clashingResourcesDTOStream(), Stream.concat(this.unreferenciableEndpointsDTOStream(), Stream.concat(this.dependentServiceStreamDTO(), Stream.concat(this.applicationDependentResourcesDTOStream(), this.erroredEndpointsStreamDTO()))))).toArray(FailedResourceDTO[]::new);
        runtimeDTO.failedExtensionDTOs = (FailedExtensionDTO[])Stream.concat(this.clashingExtensionsDTOStream(), Stream.concat(this.unreferenciableExtensionsDTOStream(), Stream.concat(this.applicationDependentExtensionsDTOStream(), Stream.concat(this.erroredExtensionsDTOStream(), Stream.concat(this.dependentExtensionsStreamDTO(), this.invalidExtensionsDTOStream()))))).toArray(FailedExtensionDTO[]::new);
        ServiceReference<JaxrsServiceRuntime> serviceReference = this._whiteboard.getServiceReference();
        ServiceReferenceDTO serviceDTO = new ServiceReferenceDTO();
        serviceDTO.bundle = serviceReference.getBundle().getBundleId();
        serviceDTO.id = (Long)serviceReference.getProperty("service.id");
        serviceDTO.usingBundles = Arrays.stream(serviceReference.getUsingBundles()).mapToLong(Bundle::getBundleId).toArray();
        serviceDTO.properties = Utils.getProperties(serviceReference);
        runtimeDTO.serviceDTO = serviceDTO;
        return runtimeDTO;
    }

    public void removedServiceForName(CachingServiceReference<?> serviceReference) {
        this._servicesForName.remove(AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0)));
        if (_log.isDebugEnabled()) {
            _log.debug("Unregistered service {} for name {}", serviceReference, (Object)AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0)));
        }
    }

    public void unregisterApplicationExtensions(CachingServiceReference<?> applicationReference) {
        this._dependentExtensions.remove(AriesJaxrsServiceRuntime.getServiceName(arg_0 -> applicationReference.getProperty(arg_0)));
    }

    private Stream<FailedApplicationDTO> contextDependentApplicationsDTOStream() {
        return this._contextDependentApplications.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedApplicationDTO(101, sr));
    }

    public void removeApplicationDependentExtension(CachingServiceReference<?> cachingServiceReference) {
        this._applicationDependentExtensions.remove(cachingServiceReference);
    }

    public void removeApplicationDependentResource(CachingServiceReference<?> cachingServiceReference) {
        this._applicationDependentResources.remove(cachingServiceReference);
    }

    public void removeApplicationEndpoint(PropertyHolder registratorProperties, CachingServiceReference<?> cachingServiceReference) {
        this._applicationEndpoints.compute(AriesJaxrsServiceRuntime.getServiceName(registratorProperties), AriesJaxrsServiceRuntime.remover(new EndpointRuntimeInformation(cachingServiceReference, null, null)));
        if (_log.isDebugEnabled()) {
            _log.debug("Endpoint {} has been removed from application {}", cachingServiceReference, registratorProperties.get("original.service.id"));
        }
    }

    public void removeApplicationExtension(PropertyHolder registratorProperties, CachingServiceReference<?> extensionImmutableServiceReference) {
        this._applicationExtensions.computeIfPresent(AriesJaxrsServiceRuntime.getServiceName(registratorProperties), AriesJaxrsServiceRuntime.remover(new ExtensionRuntimeInformation(extensionImmutableServiceReference, null)));
        if (_log.isDebugEnabled()) {
            _log.debug("Extension {} has been removed from application {}", extensionImmutableServiceReference, registratorProperties.get("original.service.id"));
        }
    }

    public void removeClashingApplication(CachingServiceReference<?> serviceReference) {
        this._clashingApplications.remove(serviceReference);
        if (_log.isDebugEnabled()) {
            _log.debug("Application {} no longer clashes for name {}", serviceReference, (Object)AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0)));
        }
    }

    public void removeClashingExtension(CachingServiceReference<?> serviceReference) {
        this._clashingExtensions.remove(serviceReference);
        if (_log.isDebugEnabled()) {
            _log.debug("Extension {} no longer clashes for name {}", serviceReference, (Object)AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0)));
        }
    }

    public void removeClashingResource(CachingServiceReference<?> serviceReference) {
        this._clashingResources.remove(serviceReference);
        if (_log.isDebugEnabled()) {
            _log.debug("Resource {} no longer clashes for name {}", serviceReference, (Object)AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0)));
        }
    }

    public void removeContextDependentApplication(CachingServiceReference<Application> serviceReference) {
        this._contextDependentApplications.remove(serviceReference);
        if (_log.isDebugEnabled()) {
            _log.debug("Application {} no longer depends on context filter {}", serviceReference, serviceReference.getProperty("osgi.http.whiteboard.context.select"));
        }
    }

    public void removeDependentApplication(CachingServiceReference<Application> applicationReference) {
        this._dependentApplications.remove(applicationReference);
    }

    public void removeDependentExtensionFromApplication(Map<String, ?> properties, CachingServiceReference<?> cachingServiceReference) {
        this._dependentExtensions.compute(AriesJaxrsServiceRuntime.getServiceName(properties::get), AriesJaxrsServiceRuntime.remover(cachingServiceReference));
    }

    public void removeDependentService(CachingServiceReference<?> serviceReference) {
        this._dependentServices.remove(serviceReference);
    }

    public void removeErroredApplication(CachingServiceReference<Application> serviceReference) {
        this._erroredApplications.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Errored application {} is gone", serviceReference);
        }
    }

    public <T> void removeErroredEndpoint(CachingServiceReference<T> serviceReference) {
        this._erroredEndpoints.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Errored resource {} is gone", serviceReference);
        }
    }

    public void removeErroredExtension(CachingServiceReference<?> serviceReference) {
        this._erroredExtensions.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Errored extension {} is gone", serviceReference);
        }
    }

    public void removeInvalidApplication(CachingServiceReference<?> serviceReference) {
        this._invalidApplications.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Invalid application {} is gone", serviceReference);
        }
    }

    public void removeInvalidExtension(CachingServiceReference<?> serviceReference) {
        this._invalidExtensions.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Invalid extension {} is gone", serviceReference);
        }
    }

    public void removeInvalidResource(CachingServiceReference<?> serviceReference) {
        this._invalidResources.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Invalid resource {} is gone", serviceReference);
        }
    }

    public void removeNotGettableApplication(CachingServiceReference<Application> serviceReference) {
        this._ungettableApplications.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Ungettable application reference {} is gone", serviceReference);
        }
    }

    public <T> void removeNotGettableEndpoint(CachingServiceReference<T> serviceReference) {
        this._ungettableEndpoints.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Ungettable resource reference {} is gone", serviceReference);
        }
    }

    public <T> void removeNotGettableExtension(CachingServiceReference<T> serviceReference) {
        this._ungettableExtensions.remove(serviceReference);
        if (_log.isWarnEnabled()) {
            _log.warn("Ungettable extension reference {} is gone", serviceReference);
        }
    }

    public boolean removeShadowedApplication(CachingServiceReference<Application> serviceReference) {
        if (_log.isDebugEnabled()) {
            _log.debug("Application {} is no longer shadowed", serviceReference);
        }
        return this._shadowedApplications.remove(serviceReference);
    }

    public ApplicationRuntimeInformation setApplicationForPath(String path, CachingServiceReference<Application> serviceReference, CxfJaxrsServiceRegistrator cxfJaxRsServiceRegistrator) {
        ApplicationRuntimeInformation ari = new ApplicationRuntimeInformation(serviceReference, cxfJaxRsServiceRegistrator);
        return this._applications.compute(path, (__, prop) -> {
            if (".default".equals(AriesJaxrsServiceRuntime.getServiceName(arg_0 -> ari._cachingServiceReference.getProperty(arg_0)))) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Setting application {} as default", (Object)serviceReference);
                }
                this._defaultApplicationProperties = ari;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Registering application {} for path {}", (Object)serviceReference, (Object)path);
            }
            return ari;
        });
    }

    public ApplicationRuntimeInformation unsetApplicationForPath(String path) {
        return this._applications.remove(path);
    }

    private static FailedApplicationDTO buildFailedApplicationDTO(int reason, CachingServiceReference<?> serviceReference) {
        FailedApplicationDTO failedApplicationDTO = new FailedApplicationDTO();
        Object nameProperty = serviceReference.getProperty("osgi.jaxrs.name");
        failedApplicationDTO.name = nameProperty == null ? Utils.generateApplicationName(arg_0 -> serviceReference.getProperty(arg_0)) : nameProperty.toString();
        failedApplicationDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedApplicationDTO.failureReason = reason;
        return failedApplicationDTO;
    }

    private static <T> BiFunction<String, Collection<T>, Collection<T>> merger(T t) {
        return (__, collection) -> {
            if (collection == null) {
                collection = Collections.newSetFromMap(new ConcurrentHashMap());
            }
            collection.add(t);
            return collection;
        };
    }

    private static <T extends BaseDTO> T populateBaseDTO(T baseDTO, CachingServiceReference<?> serviceReference) {
        baseDTO.name = AriesJaxrsServiceRuntime.getServiceName(arg_0 -> serviceReference.getProperty(arg_0));
        baseDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        return baseDTO;
    }

    private static void populateBaseExtensionDTO(BaseExtensionDTO extensionDTO, CachingServiceReference<?> serviceReference) {
        AriesJaxrsServiceRuntime.populateBaseDTO(extensionDTO, serviceReference);
        extensionDTO.extensionTypes = (String[])Arrays.stream(Utils.canonicalize(serviceReference.getProperty("objectClass"))).filter(Whiteboard.SUPPORTED_EXTENSION_INTERFACES::containsKey).toArray(String[]::new);
    }

    private static ExtensionDTO populateExtensionDTO(ExtensionDTO extensionDTO, ExtensionRuntimeInformation eri) {
        AriesJaxrsServiceRuntime.populateBaseExtensionDTO((BaseExtensionDTO)extensionDTO, eri._cachingServiceReference);
        Consumes consumes = (Consumes)AnnotationUtils.getClassAnnotation(eri._class, Consumes.class);
        Produces produces = (Produces)AnnotationUtils.getClassAnnotation(eri._class, Produces.class);
        Set nameBindings = AnnotationUtils.getNameBindings((Annotation[])eri._class.getAnnotations());
        if (nameBindings.isEmpty()) {
            nameBindings = null;
        }
        extensionDTO.consumes = consumes == null ? null : (String[])JAXRSUtils.getConsumeTypes((Consumes)consumes).stream().map(MediaType::toString).toArray(String[]::new);
        extensionDTO.produces = produces == null ? null : (String[])JAXRSUtils.getProduceTypes((Produces)produces).stream().map(MediaType::toString).toArray(String[]::new);
        extensionDTO.nameBindings = nameBindings == null ? null : nameBindings.toArray(new String[0]);
        return extensionDTO;
    }

    private static ResourceDTO populateResourceDTO(ResourceDTO resourceDTO, EndpointRuntimeInformation endpointRuntimeInformation) {
        AriesJaxrsServiceRuntime.populateBaseDTO(resourceDTO, endpointRuntimeInformation._cachingServiceReference);
        resourceDTO.resourceMethods = ClassIntrospector.getResourceMethodInfos(endpointRuntimeInformation._class, endpointRuntimeInformation._bus).toArray(new ResourceMethodInfoDTO[0]);
        return resourceDTO;
    }

    private static <T> BiFunction<String, Collection<T>, Collection<T>> remover(T t) {
        return (__, collection) -> {
            if (collection != null) {
                collection.remove(t);
                if (collection.isEmpty()) {
                    return null;
                }
            }
            return collection;
        };
    }

    private Stream<ApplicationDTO> applicationDTOStream() {
        return this._applications.values().stream().filter(p -> !".default".equals(p._cachingServiceReference.getProperty("osgi.jaxrs.name"))).map(this::buildApplicationDTO);
    }

    private Stream<FailedExtensionDTO> applicationDependentExtensionsDTOStream() {
        return this._applicationDependentExtensions.stream().map(sr -> this.buildFailedExtensionDTO(7, (CachingServiceReference<?>)sr));
    }

    private Stream<FailedResourceDTO> applicationDependentResourcesDTOStream() {
        return this._applicationDependentResources.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedResourceDTO(7, sr));
    }

    private ApplicationDTO buildApplicationDTO(ApplicationRuntimeInformation ari) {
        ApplicationDTO applicationDTO = new ApplicationDTO(){};
        applicationDTO.name = AriesJaxrsServiceRuntime.getServiceName(arg_0 -> ari._cachingServiceReference.getProperty(arg_0));
        applicationDTO.base = this._whiteboard.getApplicationBase(arg_0 -> ari._cachingServiceReference.getProperty(arg_0));
        applicationDTO.serviceId = (Long)ari._cachingServiceReference.getProperty("service.id");
        applicationDTO.resourceDTOs = (ResourceDTO[])this.getApplicationEndpointsStream(applicationDTO.name).toArray(ResourceDTO[]::new);
        applicationDTO.extensionDTOs = (ExtensionDTO[])this.getApplicationExtensionsStream(applicationDTO.name).toArray(ExtensionDTO[]::new);
        HashMap<String, Set> nameBoundExtensions = new HashMap<String, Set>();
        HashMap<ExtensionDTO, Set> extensionResources = new HashMap<ExtensionDTO, Set>();
        for (ExtensionDTO extensionDTO2 : applicationDTO.extensionDTOs) {
            if (extensionDTO2.nameBindings == null) continue;
            for (String string : extensionDTO2.nameBindings) {
                Set extensionDTOS = nameBoundExtensions.computeIfAbsent(string, __ -> new HashSet());
                extensionDTOS.add(extensionDTO2);
            }
        }
        for (ExtensionDTO extensionDTO3 : applicationDTO.resourceDTOs) {
            for (String string : extensionDTO3.resourceMethods) {
                if (((ResourceMethodInfoDTO)string).nameBindings == null) continue;
                for (String nameBinding : ((ResourceMethodInfoDTO)string).nameBindings) {
                    Set extensionDTOS = (Set)nameBoundExtensions.get(nameBinding);
                    if (extensionDTOS == null) continue;
                    for (ExtensionDTO extensionDTO32 : extensionDTOS) {
                        Set resourceDTOS2 = extensionResources.computeIfAbsent(extensionDTO32, __ -> new HashSet());
                        resourceDTOS2.add(extensionDTO3);
                    }
                }
            }
        }
        extensionResources.forEach((extensionDTO, resourceDTOS) -> {
            extensionDTO.filteredByName = resourceDTOS.toArray(new ResourceDTO[0]);
        });
        CxfJaxrsServiceRegistrator cxfJaxRsServiceRegistrator = ari._cxfJaxRsServiceRegistrator;
        Bus bus = cxfJaxRsServiceRegistrator.getBus();
        Iterable<Class<?>> resourceClasses = cxfJaxRsServiceRegistrator.getStaticResourceClasses();
        ArrayList<ResourceMethodInfoDTO> arrayList = new ArrayList<ResourceMethodInfoDTO>();
        for (Class clazz : resourceClasses) {
            arrayList.addAll(ClassIntrospector.getResourceMethodInfos(clazz, bus));
        }
        applicationDTO.resourceMethods = arrayList.toArray(new ResourceMethodInfoDTO[0]);
        return applicationDTO;
    }

    private FailedExtensionDTO buildFailedExtensionDTO(int reason, CachingServiceReference<?> serviceReference) {
        FailedExtensionDTO failedExtensionDTO = new FailedExtensionDTO();
        AriesJaxrsServiceRuntime.populateBaseExtensionDTO((BaseExtensionDTO)failedExtensionDTO, serviceReference);
        failedExtensionDTO.failureReason = reason;
        return failedExtensionDTO;
    }

    private static FailedResourceDTO buildFailedResourceDTO(int reason, CachingServiceReference<?> serviceReference) {
        FailedResourceDTO failedResourceDTO = new FailedResourceDTO();
        AriesJaxrsServiceRuntime.populateBaseDTO(failedResourceDTO, serviceReference);
        failedResourceDTO.failureReason = reason;
        return failedResourceDTO;
    }

    private Stream<FailedApplicationDTO> clashingApplicationsDTOStream() {
        return this._clashingApplications.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedApplicationDTO(6, sr));
    }

    private Stream<FailedExtensionDTO> clashingExtensionsDTOStream() {
        return this._clashingExtensions.stream().map(sr -> this.buildFailedExtensionDTO(6, (CachingServiceReference<?>)sr));
    }

    private Stream<FailedResourceDTO> clashingResourcesDTOStream() {
        return this._clashingResources.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedResourceDTO(6, sr));
    }

    private Stream<FailedApplicationDTO> dependentApplicationsDTOStream() {
        return this._dependentApplications.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedApplicationDTO(5, sr));
    }

    private Stream<FailedExtensionDTO> dependentExtensionsStreamDTO() {
        return this._dependentExtensions.values().stream().flatMap(Collection::stream).map(sr -> this.buildFailedExtensionDTO(5, (CachingServiceReference<?>)sr));
    }

    private Stream<FailedResourceDTO> dependentServiceStreamDTO() {
        return this._dependentServices.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedResourceDTO(5, sr));
    }

    private Stream<FailedApplicationDTO> erroredApplicationsDTOStream() {
        return this._erroredApplications.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedApplicationDTO(0, sr));
    }

    private Stream<FailedResourceDTO> erroredEndpointsStreamDTO() {
        return this._erroredEndpoints.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedResourceDTO(0, sr));
    }

    private Stream<FailedExtensionDTO> erroredExtensionsDTOStream() {
        return this._erroredExtensions.stream().map(sr -> this.buildFailedExtensionDTO(0, (CachingServiceReference<?>)sr));
    }

    private Stream<ResourceDTO> getApplicationEndpointsStream(String name) {
        Collection<EndpointRuntimeInformation> endpointRuntimeInformations = this._applicationEndpoints.get(name);
        Stream<Object> applicationEndpointStream = endpointRuntimeInformations != null ? endpointRuntimeInformations.stream() : Stream.empty();
        return applicationEndpointStream.map(sr -> AriesJaxrsServiceRuntime.populateResourceDTO(new ResourceDTO(), sr));
    }

    private Stream<ExtensionDTO> getApplicationExtensionsStream(String name) {
        Collection<ExtensionRuntimeInformation> extensionRuntimeInformations = this._applicationExtensions.get(name);
        Stream<Object> applicationExtensionStream = extensionRuntimeInformations != null ? extensionRuntimeInformations.stream() : Stream.empty();
        return applicationExtensionStream.map(sr -> AriesJaxrsServiceRuntime.populateExtensionDTO(new ExtensionDTO(), sr));
    }

    private Stream<FailedExtensionDTO> invalidExtensionsDTOStream() {
        return this._invalidExtensions.stream().map(sr -> this.buildFailedExtensionDTO(4, (CachingServiceReference<?>)sr));
    }

    private Stream<FailedApplicationDTO> invalidApplicationsDTOStream() {
        return this._invalidApplications.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedApplicationDTO(3, sr));
    }

    private Stream<FailedResourceDTO> invalidResourcesDTOStream() {
        return this._invalidResources.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedResourceDTO(3, sr));
    }

    private Stream<FailedApplicationDTO> shadowedApplicationsDTOStream() {
        return this._shadowedApplications.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedApplicationDTO(1, sr));
    }

    private Stream<FailedApplicationDTO> unreferenciableApplicationsDTOStream() {
        return this._ungettableApplications.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedApplicationDTO(2, sr));
    }

    private Stream<FailedResourceDTO> unreferenciableEndpointsDTOStream() {
        return this._ungettableEndpoints.stream().map(sr -> AriesJaxrsServiceRuntime.buildFailedResourceDTO(2, sr));
    }

    private Stream<FailedExtensionDTO> unreferenciableExtensionsDTOStream() {
        return this._ungettableExtensions.stream().map(sr -> this.buildFailedExtensionDTO(2, (CachingServiceReference<?>)sr));
    }

    private static class ApplicationRuntimeInformation {
        CachingServiceReference<?> _cachingServiceReference;
        CxfJaxrsServiceRegistrator _cxfJaxRsServiceRegistrator;

        public ApplicationRuntimeInformation(CachingServiceReference<?> cachingServiceReference, CxfJaxrsServiceRegistrator cxfJaxRsServiceRegistrator) {
            this._cachingServiceReference = cachingServiceReference;
            this._cxfJaxRsServiceRegistrator = cxfJaxRsServiceRegistrator;
        }

        public int hashCode() {
            return this._cachingServiceReference.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationRuntimeInformation that = (ApplicationRuntimeInformation)o;
            return this._cachingServiceReference.equals(that._cachingServiceReference);
        }
    }

    private static class ExtensionRuntimeInformation {
        CachingServiceReference<?> _cachingServiceReference;
        Class<?> _class;

        public ExtensionRuntimeInformation(CachingServiceReference<?> cachingServiceReference, Class<?> aClass) {
            this._cachingServiceReference = cachingServiceReference;
            this._class = aClass;
        }

        public int hashCode() {
            return this._cachingServiceReference.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtensionRuntimeInformation that = (ExtensionRuntimeInformation)o;
            return this._cachingServiceReference.equals(that._cachingServiceReference);
        }
    }

    private static class EndpointRuntimeInformation {
        Bus _bus;
        CachingServiceReference<?> _cachingServiceReference;
        Class<?> _class;

        public EndpointRuntimeInformation(CachingServiceReference<?> cachingServiceReference, Bus bus, Class<?> aClass) {
            this._cachingServiceReference = cachingServiceReference;
            this._bus = bus;
            this._class = aClass;
        }

        public int hashCode() {
            return this._cachingServiceReference.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointRuntimeInformation that = (EndpointRuntimeInformation)o;
            return this._cachingServiceReference.equals(that._cachingServiceReference);
        }
    }
}

