/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.notification.internal.scheduler;

import com.liferay.commerce.notification.internal.configuration.CommerceNotificationQueueEntryConfiguration;
import com.liferay.commerce.notification.service.CommerceNotificationQueueEntryLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.notification.internal.configuration.CommerceNotificationQueueEntryConfiguration"}, service={SchedulerJobConfiguration.class})
public class CheckCommerceNotificationQueueEntrySchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private volatile CommerceNotificationQueueEntryConfiguration _commerceNotificationQueueEntryConfiguration;
    @Reference
    private CommerceNotificationQueueEntryLocalService _commerceNotificationQueueEntryLocalService;
    private TriggerConfiguration _triggerConfiguration;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            this._commerceNotificationQueueEntryLocalService.sendCommerceNotificationQueueEntries();
            int deleteInterval = this._commerceNotificationQueueEntryConfiguration.deleteInterval();
            Date date = new Date(System.currentTimeMillis() - (long)deleteInterval * 60000L);
            this._commerceNotificationQueueEntryLocalService.deleteCommerceNotificationQueueEntries(date);
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceNotificationQueueEntryConfiguration = (CommerceNotificationQueueEntryConfiguration)ConfigurableUtil.createConfigurable(CommerceNotificationQueueEntryConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((int)this._commerceNotificationQueueEntryConfiguration.checkInterval(), (TimeUnit)TimeUnit.MINUTE);
    }
}

