/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.account.model.impl;

import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountUserRelLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceAccountUserRel service. Represents a row in the &quot;CommerceAccountUserRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceAccountUserRelImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceAccountUserRelImpl
 * @see CommerceAccountUserRel
 * @generated
 */
public abstract class CommerceAccountUserRelBaseImpl
	extends CommerceAccountUserRelModelImpl implements CommerceAccountUserRel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce account user rel model instance should use the <code>CommerceAccountUserRel</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceAccountUserRelLocalServiceUtil.addCommerceAccountUserRel(
				this);
		}
		else {
			CommerceAccountUserRelLocalServiceUtil.updateCommerceAccountUserRel(
				this);
		}
	}

}