/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.account.model.impl;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountModel;
import com.liferay.commerce.account.model.CommerceAccountSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceAccount service. Represents a row in the &quot;CommerceAccount&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceAccountModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceAccountImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceAccountImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceAccountModelImpl
	extends BaseModelImpl<CommerceAccount> implements CommerceAccountModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce account model instance should use the <code>CommerceAccount</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceAccount";

	public static final Object[][] TABLE_COLUMNS = {
		{"externalReferenceCode", Types.VARCHAR},
		{"commerceAccountId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"parentCommerceAccountId", Types.BIGINT}, {"name", Types.VARCHAR},
		{"logoId", Types.BIGINT}, {"email", Types.VARCHAR},
		{"taxId", Types.VARCHAR}, {"type_", Types.INTEGER},
		{"active_", Types.BOOLEAN}, {"displayDate", Types.TIMESTAMP},
		{"defaultBillingAddressId", Types.BIGINT},
		{"defaultShippingAddressId", Types.BIGINT},
		{"expirationDate", Types.TIMESTAMP},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceAccountId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("parentCommerceAccountId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("logoId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("email", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("taxId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("defaultBillingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("defaultShippingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceAccount (externalReferenceCode VARCHAR(75) null,commerceAccountId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,parentCommerceAccountId LONG,name VARCHAR(255) null,logoId LONG,email VARCHAR(75) null,taxId VARCHAR(75) null,type_ INTEGER,active_ BOOLEAN,displayDate DATE null,defaultBillingAddressId LONG,defaultShippingAddressId LONG,expirationDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table CommerceAccount";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceAccount.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceAccount.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 16L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static CommerceAccount toModel(CommerceAccountSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceAccount model = new CommerceAccountImpl();

		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommerceAccountId(soapModel.getCommerceAccountId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setParentCommerceAccountId(
			soapModel.getParentCommerceAccountId());
		model.setName(soapModel.getName());
		model.setLogoId(soapModel.getLogoId());
		model.setEmail(soapModel.getEmail());
		model.setTaxId(soapModel.getTaxId());
		model.setType(soapModel.getType());
		model.setActive(soapModel.isActive());
		model.setDisplayDate(soapModel.getDisplayDate());
		model.setDefaultBillingAddressId(
			soapModel.getDefaultBillingAddressId());
		model.setDefaultShippingAddressId(
			soapModel.getDefaultShippingAddressId());
		model.setExpirationDate(soapModel.getExpirationDate());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<CommerceAccount> toModels(
		CommerceAccountSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceAccount> models = new ArrayList<CommerceAccount>(
			soapModels.length);

		for (CommerceAccountSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.account.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.account.model.CommerceAccount"));

	public CommerceAccountModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceAccountId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceAccountId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceAccountId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceAccount.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceAccount.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceAccount, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceAccount, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAccount, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceAccount)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceAccount, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceAccount, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceAccount)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceAccount, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceAccount, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<CommerceAccount, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<CommerceAccount, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<CommerceAccount, Object>>();

		attributeGetterFunctions.put(
			"externalReferenceCode", CommerceAccount::getExternalReferenceCode);
		attributeGetterFunctions.put(
			"commerceAccountId", CommerceAccount::getCommerceAccountId);
		attributeGetterFunctions.put(
			"companyId", CommerceAccount::getCompanyId);
		attributeGetterFunctions.put("userId", CommerceAccount::getUserId);
		attributeGetterFunctions.put("userName", CommerceAccount::getUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceAccount::getCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceAccount::getModifiedDate);
		attributeGetterFunctions.put(
			"parentCommerceAccountId",
			CommerceAccount::getParentCommerceAccountId);
		attributeGetterFunctions.put("name", CommerceAccount::getName);
		attributeGetterFunctions.put("logoId", CommerceAccount::getLogoId);
		attributeGetterFunctions.put("email", CommerceAccount::getEmail);
		attributeGetterFunctions.put("taxId", CommerceAccount::getTaxId);
		attributeGetterFunctions.put("type", CommerceAccount::getType);
		attributeGetterFunctions.put("active", CommerceAccount::getActive);
		attributeGetterFunctions.put(
			"displayDate", CommerceAccount::getDisplayDate);
		attributeGetterFunctions.put(
			"defaultBillingAddressId",
			CommerceAccount::getDefaultBillingAddressId);
		attributeGetterFunctions.put(
			"defaultShippingAddressId",
			CommerceAccount::getDefaultShippingAddressId);
		attributeGetterFunctions.put(
			"expirationDate", CommerceAccount::getExpirationDate);
		attributeGetterFunctions.put(
			"lastPublishDate", CommerceAccount::getLastPublishDate);
		attributeGetterFunctions.put("status", CommerceAccount::getStatus);
		attributeGetterFunctions.put(
			"statusByUserId", CommerceAccount::getStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", CommerceAccount::getStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", CommerceAccount::getStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<CommerceAccount, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<CommerceAccount, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<CommerceAccount, ?>>();

		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommerceAccount, String>)
				CommerceAccount::setExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"commerceAccountId",
			(BiConsumer<CommerceAccount, Long>)
				CommerceAccount::setCommerceAccountId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceAccount, Long>)CommerceAccount::setCompanyId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceAccount, Long>)CommerceAccount::setUserId);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceAccount, String>)CommerceAccount::setUserName);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceAccount, Date>)CommerceAccount::setCreateDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceAccount, Date>)
				CommerceAccount::setModifiedDate);
		attributeSetterBiConsumers.put(
			"parentCommerceAccountId",
			(BiConsumer<CommerceAccount, Long>)
				CommerceAccount::setParentCommerceAccountId);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<CommerceAccount, String>)CommerceAccount::setName);
		attributeSetterBiConsumers.put(
			"logoId",
			(BiConsumer<CommerceAccount, Long>)CommerceAccount::setLogoId);
		attributeSetterBiConsumers.put(
			"email",
			(BiConsumer<CommerceAccount, String>)CommerceAccount::setEmail);
		attributeSetterBiConsumers.put(
			"taxId",
			(BiConsumer<CommerceAccount, String>)CommerceAccount::setTaxId);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<CommerceAccount, Integer>)CommerceAccount::setType);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<CommerceAccount, Boolean>)CommerceAccount::setActive);
		attributeSetterBiConsumers.put(
			"displayDate",
			(BiConsumer<CommerceAccount, Date>)CommerceAccount::setDisplayDate);
		attributeSetterBiConsumers.put(
			"defaultBillingAddressId",
			(BiConsumer<CommerceAccount, Long>)
				CommerceAccount::setDefaultBillingAddressId);
		attributeSetterBiConsumers.put(
			"defaultShippingAddressId",
			(BiConsumer<CommerceAccount, Long>)
				CommerceAccount::setDefaultShippingAddressId);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<CommerceAccount, Date>)
				CommerceAccount::setExpirationDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<CommerceAccount, Date>)
				CommerceAccount::setLastPublishDate);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<CommerceAccount, Integer>)CommerceAccount::setStatus);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<CommerceAccount, Long>)
				CommerceAccount::setStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<CommerceAccount, String>)
				CommerceAccount::setStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<CommerceAccount, Date>)CommerceAccount::setStatusDate);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceAccountId() {
		return _commerceAccountId;
	}

	@Override
	public void setCommerceAccountId(long commerceAccountId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceAccountId = commerceAccountId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getParentCommerceAccountId() {
		return _parentCommerceAccountId;
	}

	@Override
	public void setParentCommerceAccountId(long parentCommerceAccountId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentCommerceAccountId = parentCommerceAccountId;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public long getLogoId() {
		return _logoId;
	}

	@Override
	public void setLogoId(long logoId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_logoId = logoId;
	}

	@JSON
	@Override
	public String getEmail() {
		if (_email == null) {
			return "";
		}
		else {
			return _email;
		}
	}

	@Override
	public void setEmail(String email) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_email = email;
	}

	@JSON
	@Override
	public String getTaxId() {
		if (_taxId == null) {
			return "";
		}
		else {
			return _taxId;
		}
	}

	@Override
	public void setTaxId(String taxId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_taxId = taxId;
	}

	@JSON
	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	@JSON
	@Override
	public long getDefaultBillingAddressId() {
		return _defaultBillingAddressId;
	}

	@Override
	public void setDefaultBillingAddressId(long defaultBillingAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultBillingAddressId = defaultBillingAddressId;
	}

	@JSON
	@Override
	public long getDefaultShippingAddressId() {
		return _defaultShippingAddressId;
	}

	@Override
	public void setDefaultShippingAddressId(long defaultShippingAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultShippingAddressId = defaultShippingAddressId;
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceAccount.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceAccount toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceAccount>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceAccountImpl commerceAccountImpl = new CommerceAccountImpl();

		commerceAccountImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceAccountImpl.setCommerceAccountId(getCommerceAccountId());
		commerceAccountImpl.setCompanyId(getCompanyId());
		commerceAccountImpl.setUserId(getUserId());
		commerceAccountImpl.setUserName(getUserName());
		commerceAccountImpl.setCreateDate(getCreateDate());
		commerceAccountImpl.setModifiedDate(getModifiedDate());
		commerceAccountImpl.setParentCommerceAccountId(
			getParentCommerceAccountId());
		commerceAccountImpl.setName(getName());
		commerceAccountImpl.setLogoId(getLogoId());
		commerceAccountImpl.setEmail(getEmail());
		commerceAccountImpl.setTaxId(getTaxId());
		commerceAccountImpl.setType(getType());
		commerceAccountImpl.setActive(isActive());
		commerceAccountImpl.setDisplayDate(getDisplayDate());
		commerceAccountImpl.setDefaultBillingAddressId(
			getDefaultBillingAddressId());
		commerceAccountImpl.setDefaultShippingAddressId(
			getDefaultShippingAddressId());
		commerceAccountImpl.setExpirationDate(getExpirationDate());
		commerceAccountImpl.setLastPublishDate(getLastPublishDate());
		commerceAccountImpl.setStatus(getStatus());
		commerceAccountImpl.setStatusByUserId(getStatusByUserId());
		commerceAccountImpl.setStatusByUserName(getStatusByUserName());
		commerceAccountImpl.setStatusDate(getStatusDate());

		commerceAccountImpl.resetOriginalValues();

		return commerceAccountImpl;
	}

	@Override
	public int compareTo(CommerceAccount commerceAccount) {
		int value = 0;

		value = getName().compareTo(commerceAccount.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceAccount)) {
			return false;
		}

		CommerceAccount commerceAccount = (CommerceAccount)object;

		long primaryKey = commerceAccount.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceAccount> toCacheModel() {
		CommerceAccountCacheModel commerceAccountCacheModel =
			new CommerceAccountCacheModel();

		commerceAccountCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceAccountCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceAccountCacheModel.externalReferenceCode = null;
		}

		commerceAccountCacheModel.commerceAccountId = getCommerceAccountId();

		commerceAccountCacheModel.companyId = getCompanyId();

		commerceAccountCacheModel.userId = getUserId();

		commerceAccountCacheModel.userName = getUserName();

		String userName = commerceAccountCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceAccountCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceAccountCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceAccountCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceAccountCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceAccountCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceAccountCacheModel.parentCommerceAccountId =
			getParentCommerceAccountId();

		commerceAccountCacheModel.name = getName();

		String name = commerceAccountCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceAccountCacheModel.name = null;
		}

		commerceAccountCacheModel.logoId = getLogoId();

		commerceAccountCacheModel.email = getEmail();

		String email = commerceAccountCacheModel.email;

		if ((email != null) && (email.length() == 0)) {
			commerceAccountCacheModel.email = null;
		}

		commerceAccountCacheModel.taxId = getTaxId();

		String taxId = commerceAccountCacheModel.taxId;

		if ((taxId != null) && (taxId.length() == 0)) {
			commerceAccountCacheModel.taxId = null;
		}

		commerceAccountCacheModel.type = getType();

		commerceAccountCacheModel.active = isActive();

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			commerceAccountCacheModel.displayDate = displayDate.getTime();
		}
		else {
			commerceAccountCacheModel.displayDate = Long.MIN_VALUE;
		}

		commerceAccountCacheModel.defaultBillingAddressId =
			getDefaultBillingAddressId();

		commerceAccountCacheModel.defaultShippingAddressId =
			getDefaultShippingAddressId();

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			commerceAccountCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			commerceAccountCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			commerceAccountCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			commerceAccountCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		commerceAccountCacheModel.status = getStatus();

		commerceAccountCacheModel.statusByUserId = getStatusByUserId();

		commerceAccountCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commerceAccountCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commerceAccountCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commerceAccountCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commerceAccountCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commerceAccountCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceAccount, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceAccount, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAccount, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((CommerceAccount)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceAccount, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceAccount, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAccount, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceAccount)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceAccount>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceAccount.class, ModelWrapper.class);

	}

	private String _externalReferenceCode;
	private long _commerceAccountId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _parentCommerceAccountId;
	private String _name;
	private long _logoId;
	private String _email;
	private String _taxId;
	private int _type;
	private boolean _active;
	private Date _displayDate;
	private long _defaultBillingAddressId;
	private long _defaultShippingAddressId;
	private Date _expirationDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceAccount, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceAccount)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("commerceAccountId", _commerceAccountId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"parentCommerceAccountId", _parentCommerceAccountId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("logoId", _logoId);
		_columnOriginalValues.put("email", _email);
		_columnOriginalValues.put("taxId", _taxId);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put(
			"defaultBillingAddressId", _defaultBillingAddressId);
		_columnOriginalValues.put(
			"defaultShippingAddressId", _defaultShippingAddressId);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("type_", "type");
		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("externalReferenceCode", 1L);

		columnBitmasks.put("commerceAccountId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("parentCommerceAccountId", 128L);

		columnBitmasks.put("name", 256L);

		columnBitmasks.put("logoId", 512L);

		columnBitmasks.put("email", 1024L);

		columnBitmasks.put("taxId", 2048L);

		columnBitmasks.put("type_", 4096L);

		columnBitmasks.put("active_", 8192L);

		columnBitmasks.put("displayDate", 16384L);

		columnBitmasks.put("defaultBillingAddressId", 32768L);

		columnBitmasks.put("defaultShippingAddressId", 65536L);

		columnBitmasks.put("expirationDate", 131072L);

		columnBitmasks.put("lastPublishDate", 262144L);

		columnBitmasks.put("status", 524288L);

		columnBitmasks.put("statusByUserId", 1048576L);

		columnBitmasks.put("statusByUserName", 2097152L);

		columnBitmasks.put("statusDate", 4194304L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceAccount _escapedModel;

}