/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.account.model.impl;

import com.liferay.commerce.account.model.CommerceAccountGroupCommerceAccountRel;
import com.liferay.commerce.account.service.CommerceAccountGroupCommerceAccountRelLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceAccountGroupCommerceAccountRel service. Represents a row in the &quot;CAccountGroupCAccountRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceAccountGroupCommerceAccountRelImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceAccountGroupCommerceAccountRelImpl
 * @see CommerceAccountGroupCommerceAccountRel
 * @generated
 */
public abstract class CommerceAccountGroupCommerceAccountRelBaseImpl
	extends CommerceAccountGroupCommerceAccountRelModelImpl
	implements CommerceAccountGroupCommerceAccountRel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce account group commerce account rel model instance should use the <code>CommerceAccountGroupCommerceAccountRel</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceAccountGroupCommerceAccountRelLocalServiceUtil.
				addCommerceAccountGroupCommerceAccountRel(this);
		}
		else {
			CommerceAccountGroupCommerceAccountRelLocalServiceUtil.
				updateCommerceAccountGroupCommerceAccountRel(this);
		}
	}

}