/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.account.model.impl;

import com.liferay.commerce.account.model.CommerceAccountGroup;
import com.liferay.commerce.account.service.CommerceAccountGroupLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceAccountGroup service. Represents a row in the &quot;CommerceAccountGroup&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceAccountGroupImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceAccountGroupImpl
 * @see CommerceAccountGroup
 * @generated
 */
public abstract class CommerceAccountGroupBaseImpl
	extends CommerceAccountGroupModelImpl implements CommerceAccountGroup {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce account group model instance should use the <code>CommerceAccountGroup</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceAccountGroupLocalServiceUtil.addCommerceAccountGroup(this);
		}
		else {
			CommerceAccountGroupLocalServiceUtil.updateCommerceAccountGroup(
				this);
		}
	}

}