/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.account.model.impl;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceAccount service. Represents a row in the &quot;CommerceAccount&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceAccountImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceAccountImpl
 * @see CommerceAccount
 * @generated
 */
public abstract class CommerceAccountBaseImpl
	extends CommerceAccountModelImpl implements CommerceAccount {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce account model instance should use the <code>CommerceAccount</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceAccountLocalServiceUtil.addCommerceAccount(this);
		}
		else {
			CommerceAccountLocalServiceUtil.updateCommerceAccount(this);
		}
	}

}