/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.style.book.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalServiceUtil;

/**
 * The extended model base implementation for the StyleBookEntry service. Represents a row in the &quot;StyleBookEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link StyleBookEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see StyleBookEntryImpl
 * @see StyleBookEntry
 * @generated
 */
public abstract class StyleBookEntryBaseImpl
	extends StyleBookEntryModelImpl implements StyleBookEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a style book entry model instance should use the <code>StyleBookEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			StyleBookEntryLocalServiceUtil.addStyleBookEntry(this);
		}
		else {
			try {
				StyleBookEntryLocalServiceUtil.updateStyleBookEntry(this);
			}
			catch (PortalException portalException) {
				throw new SystemException(portalException);
			}
		}
	}

}