/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.site.cms.site.initializer.internal.struts;

import com.liferay.layout.constants.LayoutTypeSettingsConstants;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionService;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupConstants;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ContentTypes;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.WebKeys;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Lourdes Fernández Besada
 */
@Component(
	property = "path=/cms/reset_structure_display_page",
	service = StrutsAction.class
)
public class ResetStructureDisplayPageStrutsAction implements StrutsAction {

	@Override
	public String execute(
		HttpServletRequest httpServletRequest,
		HttpServletResponse httpServletResponse) {

		try {
			_write(
				httpServletResponse, _jsonFactory.createJSONObject(),
				HttpServletResponse.SC_OK);

			ObjectDefinition objectDefinition =
				_objectDefinitionService.getObjectDefinition(
					ParamUtil.getLong(
						httpServletRequest, "objectDefinitionId"));

			if ((objectDefinition == null) || !objectDefinition.isApproved()) {
				return null;
			}

			ThemeDisplay themeDisplay =
				(ThemeDisplay)httpServletRequest.getAttribute(
					WebKeys.THEME_DISPLAY);

			Group group = _groupLocalService.getGroup(
				themeDisplay.getCompanyId(), GroupConstants.CMS);

			LayoutPageTemplateEntry layoutPageTemplateEntry =
				_layoutPageTemplateEntryLocalService.
					fetchDefaultLayoutPageTemplateEntry(
						group.getGroupId(),
						_portal.getClassNameId(objectDefinition.getClassName()),
						0);

			if (layoutPageTemplateEntry == null) {
				return null;
			}

			Layout draftLayout = _layoutLocalService.fetchDraftLayout(
				layoutPageTemplateEntry.getPlid());

			if ((draftLayout == null) ||
				!GetterUtil.getBoolean(
					draftLayout.getTypeSettingsProperty(
						LayoutTypeSettingsConstants.KEY_AUTOGENERATED))) {

				return null;
			}

			_layoutPageTemplateEntryLocalService.deleteLayoutPageTemplateEntry(
				layoutPageTemplateEntry);
		}
		catch (Exception exception) {
			if (_log.isDebugEnabled()) {
				_log.debug(exception);
			}

			ThemeDisplay themeDisplay =
				(ThemeDisplay)httpServletRequest.getAttribute(
					WebKeys.THEME_DISPLAY);

			_write(
				httpServletResponse,
				JSONUtil.put(
					"title",
					_language.get(
						themeDisplay.getLocale(),
						"an-unexpected-error-occurred")),
				HttpServletResponse.SC_BAD_REQUEST);
		}

		return null;
	}

	private void _write(
		HttpServletResponse httpServletResponse, JSONObject jsonObject,
		int status) {

		try {
			httpServletResponse.setContentType(ContentTypes.APPLICATION_JSON);
			httpServletResponse.setStatus(status);

			ServletResponseUtil.write(
				httpServletResponse, JSONUtil.toString(jsonObject));
		}
		catch (Exception exception) {
			if (_log.isDebugEnabled()) {
				_log.debug(exception);
			}
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		ResetStructureDisplayPageStrutsAction.class);

	@Reference
	private GroupLocalService _groupLocalService;

	@Reference
	private JSONFactory _jsonFactory;

	@Reference
	private Language _language;

	@Reference
	private LayoutLocalService _layoutLocalService;

	@Reference
	private LayoutPageTemplateEntryLocalService
		_layoutPageTemplateEntryLocalService;

	@Reference
	private ObjectDefinitionService _objectDefinitionService;

	@Reference
	private Portal _portal;

}