/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

import {addParams} from 'frontend-js-web';

import ApiHelper from '../../common/services/ApiHelper';
import {config} from '../config';
import {Structure} from '../types/Structure';

async function resetDisplayPage({id}: {id: Structure['id']}) {
	const resetStructureDisplayPageURL = addParams(
		{
			objectDefinitionId: id,
		},
		config.resetStructureDisplayPageURL
	);

	return await ApiHelper.post(resetStructureDisplayPageURL);
}

export default {
	resetDisplayPage,
};
