/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

import {sub} from 'frontend-js-web';
import React, {useEffect, useState} from 'react';

import Toolbar from '../../common/components/Toolbar';
import VerticalNavLayout from '../../common/components/VerticalNavLayout';
import SpaceService from '../../common/services/SpaceService';
import {Space} from '../../common/types/Space';
import SpaceGeneralSettings from './SpaceGeneralSettings';

interface SpaceSettingsProps {
	backURL: string;
	depotEntryId: string;
	groupId: string;
}

export default function SpaceSettings({
	backURL,
	depotEntryId,
	groupId,
}: SpaceSettingsProps) {
	const [space, setSpace] = useState<Space | null>(null);

	useEffect(() => {
		SpaceService.getSpace({spaceId: depotEntryId}).then((space) => {
			setSpace(space);
		});
	}, [depotEntryId]);

	if (!space) {
		return null;
	}

	const verticalNavItems = [
		{
			component: <SpaceGeneralSettings groupId={groupId} space={space} />,
			id: 'general',
			label: Liferay.Language.get('general'),
		},
		{
			component: <Languages />,
			id: 'languages',
			label: Liferay.Language.get('languages'),
		},
	];

	return (
		<>
			<Toolbar
				backURL={backURL}
				title={sub(Liferay.Language.get('x-settings'), space.name)}
			/>

			<VerticalNavLayout items={verticalNavItems} />
		</>
	);
}

function Languages() {
	return null;
}
