/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

public final class PathUtil {
    public static String buildPath(String folderPath, String name) {
        PathUtil.validatePath(folderPath);
        PathUtil.validateName(name);
        if (folderPath.equals("/")) {
            return "/" + name;
        }
        return folderPath + "/" + name;
    }

    public static String getExtension(String path) {
        int pos = path.lastIndexOf(".");
        if (pos == -1) {
            return "";
        }
        return path.substring(pos + 1);
    }

    public static String getName(String path) {
        PathUtil.validatePath(path);
        if (path.equals("/")) {
            return "/";
        }
        int pos = path.lastIndexOf("/");
        return path.substring(pos + 1);
    }

    public static String getNameWithoutExtension(String path) {
        String name = PathUtil.getName(path);
        int pos = name.lastIndexOf(".");
        if (pos == -1) {
            return name;
        }
        return name.substring(0, pos);
    }

    public static String getParentFolderPath(String path) {
        PathUtil.validatePath(path);
        int pos = path.lastIndexOf("/");
        if (pos == 0) {
            return "/";
        }
        return path.substring(0, pos);
    }

    public static void validateName(String name) {
        if (name == null || name.contains("/")) {
            throw new IllegalArgumentException("Invalid file or folder name " + name);
        }
    }

    public static void validatePath(String path) {
        if (path == null || !path.equals("/") && (!path.startsWith("/") || path.endsWith("/"))) {
            throw new IllegalArgumentException("Invalid path " + path);
        }
    }
}

