/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.model;

import com.liferay.document.library.repository.external.ExtRepositoryModel;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public abstract class SharepointWSObject
implements ExtRepositoryModel,
ExtRepositoryObject {
    protected SharepointObject sharepointObject;
    private static final Map<ExtRepositoryObject.ExtRepositoryPermission, SharepointObject.Permission> _permissions = new EnumMap<ExtRepositoryObject.ExtRepositoryPermission, SharepointObject.Permission>(ExtRepositoryObject.ExtRepositoryPermission.class){
        {
            this.put(ExtRepositoryObject.ExtRepositoryPermission.ACCESS, SharepointObject.Permission.VIEW_LIST_ITEMS);
            this.put(ExtRepositoryObject.ExtRepositoryPermission.ADD_DOCUMENT, SharepointObject.Permission.ADD_LIST_ITEMS);
            this.put(ExtRepositoryObject.ExtRepositoryPermission.ADD_FOLDER, SharepointObject.Permission.ADD_LIST_ITEMS);
            this.put(ExtRepositoryObject.ExtRepositoryPermission.ADD_SUBFOLDER, SharepointObject.Permission.ADD_LIST_ITEMS);
            this.put(ExtRepositoryObject.ExtRepositoryPermission.DELETE, SharepointObject.Permission.DELETE_LIST_ITEMS);
            this.put(ExtRepositoryObject.ExtRepositoryPermission.UPDATE, SharepointObject.Permission.EDIT_LIST_ITEMS);
            this.put(ExtRepositoryObject.ExtRepositoryPermission.VIEW, SharepointObject.Permission.VIEW_LIST_ITEMS);
        }
    };
    private static final Set<ExtRepositoryObject.ExtRepositoryPermission> _unsupportedExtRepositoryPermissions = EnumSet.of(ExtRepositoryObject.ExtRepositoryPermission.ADD_DISCUSSION, ExtRepositoryObject.ExtRepositoryPermission.ADD_SHORTCUT, ExtRepositoryObject.ExtRepositoryPermission.DELETE_DISCUSSION, ExtRepositoryObject.ExtRepositoryPermission.PERMISSIONS, ExtRepositoryObject.ExtRepositoryPermission.UPDATE_DISCUSSION);

    public SharepointWSObject(SharepointObject sharepointObject) {
        this.sharepointObject = sharepointObject;
    }

    public boolean containsPermission(ExtRepositoryObject.ExtRepositoryPermission extRepositoryPermission) {
        if (_unsupportedExtRepositoryPermissions.contains(extRepositoryPermission)) {
            return false;
        }
        SharepointObject.Permission permission = _permissions.get(extRepositoryPermission);
        if (permission == null) {
            throw new UnsupportedOperationException("Unsupported permission " + String.valueOf(extRepositoryPermission));
        }
        Set<SharepointObject.Permission> permissions = this.sharepointObject.getPermissions();
        return permissions.contains((Object)permission);
    }

    public Date getCreateDate() {
        return this.sharepointObject.getCreatedDate();
    }

    public String getDescription() {
        return "";
    }

    public String getExtension() {
        return this.sharepointObject.getExtension();
    }

    public String getExtRepositoryModelKey() {
        return String.valueOf(this.sharepointObject.getSharepointObjectId());
    }

    public Date getModifiedDate() {
        return this.sharepointObject.getLastModifiedDate();
    }

    public String getOwner() {
        return this.sharepointObject.getAuthor();
    }

    public SharepointObject getSharepointObject() {
        return this.sharepointObject;
    }

    public long getSize() {
        return this.sharepointObject.getSize();
    }
}

