/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.sharepoint.soap.repository.connector.SharepointConnection;
import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import com.liferay.sharepoint.soap.repository.connector.SharepointResultException;
import com.liferay.sharepoint.soap.repository.connector.internal.util.RemoteExceptionSharepointExceptionMapper;
import com.liferay.sharepoint.soap.repository.connector.operation.AddFolderOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.BaseOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectsByFolderOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.PathUtil;
import com.microsoft.schemas.sharepoint.soap.CopyErrorCode;
import com.microsoft.schemas.sharepoint.soap.CopyIntoItemsLocalDocument;
import com.microsoft.schemas.sharepoint.soap.CopyIntoItemsLocalResponseDocument;
import com.microsoft.schemas.sharepoint.soap.CopyResult;
import com.microsoft.schemas.sharepoint.soap.CopyResultCollection;
import com.microsoft.schemas.sharepoint.soap.DestinationUrlCollection;
import java.rmi.RemoteException;
import java.util.List;

public final class CopySharepointObjectOperation
extends BaseOperation {
    private static final Log _log = LogFactoryUtil.getLog(CopySharepointObjectOperation.class);
    private AddFolderOperation _addFolderOperation;
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;
    private GetSharepointObjectsByFolderOperation _getSharepointObjectsByFolderOperation;

    @Override
    public void afterPropertiesSet() {
        this._addFolderOperation = this.getOperation(AddFolderOperation.class);
        this._getSharepointObjectByPathOperation = this.getOperation(GetSharepointObjectByPathOperation.class);
        this._getSharepointObjectsByFolderOperation = this.getOperation(GetSharepointObjectsByFolderOperation.class);
    }

    public void execute(String path, String newPath) throws SharepointException {
        SharepointObject sharepointObject = this._getSharepointObjectByPathOperation.execute(path);
        if (sharepointObject == null) {
            throw new SharepointException("Unable to find Sharepoint object at " + path);
        }
        if (sharepointObject.isFile()) {
            this._copyFile(path, newPath);
        } else {
            this._copyFolder(path, newPath);
        }
    }

    private void _copyFile(String path, String newPath) throws SharepointException {
        try {
            CopyIntoItemsLocalResponseDocument copyIntoItemsLocalResponseDocument = this.copySoap12Stub.copyIntoItemsLocal(this._getCopyIntoItemsLocalDocument(path, newPath));
            this._processCopyIntoItemsLocalResponseDocument(copyIntoItemsLocalResponseDocument);
        }
        catch (RemoteException remoteException) {
            throw RemoteExceptionSharepointExceptionMapper.map(remoteException, this.sharepointConnectionInfo);
        }
    }

    private void _copyFolder(String path, String newPath) throws SharepointException {
        this._createFolder(newPath);
        List<SharepointObject> sharepointObjects = this._getSharepointObjectsByFolderOperation.execute(path, SharepointConnection.ObjectTypeFilter.ALL);
        for (SharepointObject sharepointObject : sharepointObjects) {
            String sharepointObjectPath = PathUtil.buildPath(path, sharepointObject.getName());
            String newSharepointObjectPath = PathUtil.buildPath(newPath, sharepointObject.getName());
            if (sharepointObject.isFile()) {
                this._copyFile(sharepointObjectPath, newSharepointObjectPath);
                continue;
            }
            this._copyFolder(sharepointObjectPath, newSharepointObjectPath);
        }
    }

    private void _createFolder(String folderPath) {
        block2: {
            try {
                String parentFolderPath = PathUtil.getParentFolderPath(folderPath);
                String folderName = PathUtil.getName(folderPath);
                this._addFolderOperation.execute(parentFolderPath, folderName);
            }
            catch (SharepointException sharepointException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to create folder at " + folderPath), (Throwable)sharepointException);
            }
        }
    }

    private CopyIntoItemsLocalDocument _getCopyIntoItemsLocalDocument(String path, String newPath) {
        CopyIntoItemsLocalDocument copyIntoItemsLocalDocument = CopyIntoItemsLocalDocument.Factory.newInstance();
        CopyIntoItemsLocalDocument.CopyIntoItemsLocal copyIntoItemsLocal = copyIntoItemsLocalDocument.addNewCopyIntoItemsLocal();
        DestinationUrlCollection destinationUrlCollection = DestinationUrlCollection.Factory.newInstance();
        destinationUrlCollection.addString(String.valueOf(this.toURL(newPath)));
        copyIntoItemsLocal.setDestinationUrls(destinationUrlCollection);
        copyIntoItemsLocal.setSourceUrl(String.valueOf(this.toURL(path)));
        return copyIntoItemsLocalDocument;
    }

    private void _processCopyIntoItemsLocalResponseDocument(CopyIntoItemsLocalResponseDocument copyIntoItemsLocalResponseDocument) throws SharepointException {
        CopyIntoItemsLocalResponseDocument.CopyIntoItemsLocalResponse copyIntoItemsLocalResponse = copyIntoItemsLocalResponseDocument.getCopyIntoItemsLocalResponse();
        CopyResultCollection results = copyIntoItemsLocalResponse.getResults();
        CopyResult copyResult = results.getCopyResultArray(0);
        if (copyResult.getErrorCode() != CopyErrorCode.SUCCESS) {
            throw new SharepointResultException(String.valueOf(copyResult.getErrorCode()), copyResult.getErrorMessage());
        }
    }
}

