/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.sharepoint.soap.repository.connector.SharepointConnection;
import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointResultException;
import com.liferay.sharepoint.soap.repository.connector.internal.util.RemoteExceptionSharepointExceptionMapper;
import com.liferay.sharepoint.soap.repository.connector.operation.BaseOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.CheckInFileOperation;
import com.microsoft.schemas.sharepoint.soap.CopyErrorCode;
import com.microsoft.schemas.sharepoint.soap.CopyIntoItemsDocument;
import com.microsoft.schemas.sharepoint.soap.CopyIntoItemsResponseDocument;
import com.microsoft.schemas.sharepoint.soap.CopyResult;
import com.microsoft.schemas.sharepoint.soap.CopyResultCollection;
import com.microsoft.schemas.sharepoint.soap.DestinationUrlCollection;
import com.microsoft.schemas.sharepoint.soap.FieldInformation;
import com.microsoft.schemas.sharepoint.soap.FieldInformationCollection;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;

public final class AddOrUpdateFileOperation
extends BaseOperation {
    private static final FieldInformation[] _EMPTY_FIELD_INFORMATIONS = new FieldInformation[0];
    private CheckInFileOperation _checkInFileOperation;

    @Override
    public void afterPropertiesSet() {
        this._checkInFileOperation = this.getOperation(CheckInFileOperation.class);
    }

    public void execute(String filePath, String changeLog, InputStream inputStream) throws SharepointException {
        try {
            CopyIntoItemsResponseDocument copyIntoItemsResponseDocument = this.copySoap12Stub.copyIntoItems(this._getCopyIntoItemsDocument(filePath, inputStream));
            this._processCopyIntoItemsResponseDocument(copyIntoItemsResponseDocument);
            if (changeLog != null) {
                this._checkInFileOperation.execute(filePath, changeLog, SharepointConnection.CheckInType.MAJOR);
            }
        }
        catch (RemoteException remoteException) {
            throw RemoteExceptionSharepointExceptionMapper.map(remoteException, this.sharepointConnectionInfo);
        }
    }

    private byte[] _getBytes(InputStream inputStream) throws SharepointException {
        try {
            return FileUtil.getBytes((InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SharepointException("Unable to read input stream", ioException);
        }
    }

    private CopyIntoItemsDocument _getCopyIntoItemsDocument(String filePath, InputStream inputStream) throws SharepointException {
        CopyIntoItemsDocument copyIntoItemsDocument = CopyIntoItemsDocument.Factory.newInstance();
        CopyIntoItemsDocument.CopyIntoItems copyIntoItems = copyIntoItemsDocument.addNewCopyIntoItems();
        copyIntoItems.setDestinationUrls(this._getDestinationUrlCollection(filePath));
        copyIntoItems.setFields(this._getFieldInformationCollection());
        copyIntoItems.setSourceUrl(" ");
        copyIntoItems.setStream(this._getBytes(inputStream));
        return copyIntoItemsDocument;
    }

    private DestinationUrlCollection _getDestinationUrlCollection(String filePath) {
        DestinationUrlCollection destinationUrlCollection = DestinationUrlCollection.Factory.newInstance();
        destinationUrlCollection.addString(String.valueOf(this.toURL(filePath)));
        return destinationUrlCollection;
    }

    private FieldInformationCollection _getFieldInformationCollection() {
        FieldInformationCollection fieldInformationCollection = FieldInformationCollection.Factory.newInstance();
        fieldInformationCollection.setFieldInformationArray(_EMPTY_FIELD_INFORMATIONS);
        return fieldInformationCollection;
    }

    private void _processCopyIntoItemsResponseDocument(CopyIntoItemsResponseDocument copyIntoItemsResponseDocument) throws SharepointException {
        CopyIntoItemsResponseDocument.CopyIntoItemsResponse copyIntoItemsResponse = copyIntoItemsResponseDocument.getCopyIntoItemsResponse();
        CopyResultCollection copyResultCollection = copyIntoItemsResponse.getResults();
        CopyResult copyResult = copyResultCollection.getCopyResultArray(0);
        if (copyResult.getErrorCode() != CopyErrorCode.SUCCESS) {
            throw new SharepointResultException(String.valueOf(copyResult.getErrorCode()), copyResult.getErrorMessage());
        }
    }
}

