/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class QueryServiceStubResult {
    private String _debugErrorMessage;
    private final DefaultHandler _defaultHandler = new DefaultHandler(){
        private final StringBuilder _sb = new StringBuilder();

        @Override
        public void characters(char[] chars, int start, int length) {
            this._sb.append(chars, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (localName.equals("DebugErrorMessage")) {
                QueryServiceStubResult.this._setDebugErrorMessage(this._sb.toString());
            } else if (localName.equals("LinkUrl")) {
                QueryServiceStubResult.this._linkURLs.add(this._sb.toString());
            } else if (localName.equals("Status")) {
                QueryServiceStubResult.this._setStatus(this._sb.toString());
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this._sb.setLength(0);
        }
    };
    private final List<String> _linkURLs = new ArrayList<String>();
    private String _status;

    public QueryServiceStubResult(String queryServiceSoapResultString) throws SharepointException {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(this._defaultHandler);
            xmlReader.setErrorHandler(this._defaultHandler);
            this._parse(xmlReader, queryServiceSoapResultString);
        }
        catch (IOException | SAXException exception) {
            throw new SharepointException("Unable to parse response from the Sharepoint server", exception);
        }
    }

    public String getDebugErrorMessage() {
        return this._debugErrorMessage;
    }

    public List<String> getLinkURLs() {
        return this._linkURLs;
    }

    public String getStatus() {
        return this._status;
    }

    public boolean isEmpty() {
        return this.isSuccess() && this._status.equals("ERROR_NO_RESULTS_FOUND");
    }

    public boolean isSuccess() {
        return !this._status.equals("SUCCESS") && !this._status.equals("ERROR_NO_RESULTS_FOUND");
    }

    private void _parse(XMLReader xmlReader, String queryServiceSoapResultString) throws IOException, SAXException {
        xmlReader.parse(new InputSource(new ByteArrayInputStream(queryServiceSoapResultString.getBytes("UTF-8"))));
    }

    private void _setDebugErrorMessage(String debugErrorMessage) {
        this._debugErrorMessage = debugErrorMessage;
    }

    private void _setStatus(String status) {
        this._status = status;
    }
}

