/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.sharepoint.soap.repository.connector.SharepointConnection;
import com.liferay.sharepoint.soap.repository.connector.SharepointConnectionInfo;
import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import com.liferay.sharepoint.soap.repository.connector.SharepointRuntimeException;
import com.liferay.sharepoint.soap.repository.connector.SharepointVersion;
import com.liferay.sharepoint.soap.repository.connector.operation.AddFolderOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.AddOrUpdateFileOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.BatchOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.CancelCheckOutFileOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.CheckInFileOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.CheckOutFileOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.CopySharepointObjectOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.DeleteSharepointObjectOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetInputStreamOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectByIdOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectsByFolderOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectsByNameOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectsByQueryOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointVersionsOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.MoveSharepointObjectOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.Operation;
import com.liferay.sharepoint.soap.repository.connector.operation.PathUtil;
import com.liferay.sharepoint.soap.repository.connector.operation.URLUtil;
import com.liferay.sharepoint.soap.repository.connector.schema.query.Query;
import com.liferay.sharepoint.soap.repository.connector.schema.query.QueryOptionsList;
import com.microsoft.schemas.sharepoint.soap.CopySoap12Stub;
import com.microsoft.schemas.sharepoint.soap.ListsSoap12Stub;
import com.microsoft.schemas.sharepoint.soap.VersionsSoap12Stub;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.transport.http.impl.httpclient4.HttpTransportPropertiesImpl;

public class SharepointConnectionImpl
implements SharepointConnection {
    public static final long SHAREPOINT_ROOT_FOLDER_SHAREPOINT_OBJECT_ID = -1L;
    private AddFolderOperation _addFolderOperation;
    private AddOrUpdateFileOperation _addOrUpdateFileOperation;
    private CancelCheckOutFileOperation _cancelCheckOutFileOperation;
    private CheckInFileOperation _checkInFileOperation;
    private CheckOutFileOperation _checkOutFileOperation;
    private CopySharepointObjectOperation _copySharepointObjectOperation;
    private CopySoap12Stub _copySoap12Stub;
    private DeleteSharepointObjectOperation _deleteSharepointObjectOperation;
    private GetInputStreamOperation _getInputStreamOperation;
    private GetSharepointObjectByIdOperation _getSharepointObjectByIdOperation;
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;
    private GetSharepointObjectsByFolderOperation _getSharepointObjectsByFolderOperation;
    private GetSharepointObjectsByNameOperation _getSharepointObjectsByNameOperation;
    private GetSharepointObjectsByQueryOperation _getSharepointObjectsByQueryOperation;
    private GetSharepointVersionsOperation _getSharepointVersionsOperation;
    private ListsSoap12Stub _listsSoap12Stub;
    private MoveSharepointObjectOperation _moveSharepointObjectOperation;
    private final Map<Class<? extends Operation>, Operation> _operations = new HashMap<Class<? extends Operation>, Operation>();
    private final SharepointConnectionInfo _sharepointConnectionInfo;
    private SharepointObject _sharepointRootFolder;
    private VersionsSoap12Stub _versionsSoap12Stub;

    public SharepointConnectionImpl(SharepointConnection.ServerVersion serverVersion, String serverProtocol, String serverAddress, int serverPort, String sitePath, String libraryName, String libraryPath, String userName, String password) throws SharepointRuntimeException {
        this._sharepointConnectionInfo = new SharepointConnectionInfo(serverVersion, serverProtocol, serverAddress, serverPort, sitePath, libraryName, libraryPath, userName, password);
        this._initCopyStub();
        this._initListsStub();
        this.initSharepointRootFolder();
        this._initVersionsStub();
        this._buildOperations();
    }

    @Override
    public void addFile(String folderPath, String fileName, String changeLog, InputStream inputStream) throws SharepointException {
        String filePath = PathUtil.buildPath(folderPath, fileName);
        changeLog = GetterUtil.getString((String)changeLog);
        this._addOrUpdateFileOperation.execute(filePath, changeLog, inputStream);
    }

    @Override
    public void addFolder(String folderPath, String folderName) throws SharepointException {
        PathUtil.validatePath(folderPath);
        PathUtil.validateName(folderName);
        this._addFolderOperation.execute(folderPath, folderName);
    }

    @Override
    public boolean cancelCheckOutFile(String filePath) throws SharepointException {
        PathUtil.validatePath(filePath);
        return this._cancelCheckOutFileOperation.execute(filePath);
    }

    @Override
    public boolean checkInFile(String filePath, String comment, SharepointConnection.CheckInType checkInType) throws SharepointException {
        PathUtil.validatePath(filePath);
        return this._checkInFileOperation.execute(filePath, comment, checkInType);
    }

    @Override
    public boolean checkOutFile(String filePath) throws SharepointException {
        PathUtil.validatePath(filePath);
        return this._checkOutFileOperation.execute(filePath);
    }

    @Override
    public void copySharepointObject(String path, String newPath) throws SharepointException {
        PathUtil.validatePath(path);
        PathUtil.validatePath(newPath);
        this._copySharepointObjectOperation.execute(path, newPath);
    }

    @Override
    public void deleteSharepointObject(String path) throws SharepointException {
        PathUtil.validatePath(path);
        this._deleteSharepointObjectOperation.execute(path);
    }

    @Override
    public InputStream getInputStream(SharepointObject sharepointObject) throws SharepointException {
        return this._getInputStreamOperation.execute(sharepointObject);
    }

    @Override
    public InputStream getInputStream(SharepointVersion sharepointVersion) throws SharepointException {
        return this._getInputStreamOperation.execute(sharepointVersion);
    }

    @Override
    public SharepointConnectionInfo getSharepointConnectionInfo() {
        return this._sharepointConnectionInfo;
    }

    @Override
    public SharepointObject getSharepointObject(long sharepointObjectId) throws SharepointException {
        if (sharepointObjectId == -1L) {
            return this._sharepointRootFolder;
        }
        return this._getSharepointObjectByIdOperation.execute(sharepointObjectId);
    }

    @Override
    public SharepointObject getSharepointObject(String path) throws SharepointException {
        PathUtil.validatePath(path);
        if (path.equals("/")) {
            return this._sharepointRootFolder;
        }
        return this._getSharepointObjectByPathOperation.execute(path);
    }

    @Override
    public List<SharepointObject> getSharepointObjects(Query query, QueryOptionsList queryOptionsList) throws SharepointException {
        return this._getSharepointObjectsByQueryOperation.execute(query, queryOptionsList, new String[0]);
    }

    @Override
    public List<SharepointObject> getSharepointObjects(String name) throws SharepointException {
        return this._getSharepointObjectsByNameOperation.execute(name);
    }

    @Override
    public List<SharepointObject> getSharepointObjects(String folderPath, SharepointConnection.ObjectTypeFilter objectTypeFilter) throws SharepointException {
        PathUtil.validatePath(folderPath);
        return this._getSharepointObjectsByFolderOperation.execute(folderPath, objectTypeFilter);
    }

    @Override
    public int getSharepointObjectsCount(String folderPath, SharepointConnection.ObjectTypeFilter objectTypeFilter) throws SharepointException {
        List<SharepointObject> sharepointObjects = this.getSharepointObjects(folderPath, objectTypeFilter);
        return sharepointObjects.size();
    }

    @Override
    public List<SharepointVersion> getSharepointVersions(String filePath) throws SharepointException {
        PathUtil.validatePath(filePath);
        return this._getSharepointVersionsOperation.execute(filePath);
    }

    public void initSharepointRootFolder() {
        URL serviceURL = this._sharepointConnectionInfo.getServiceURL();
        String libraryPath = this._sharepointConnectionInfo.getLibraryPath();
        URL libraryURL = URLUtil.toURL(String.valueOf(serviceURL) + libraryPath);
        this._sharepointRootFolder = new SharepointObject("", null, new Date(0L), true, new Date(0L), "/", EnumSet.allOf(SharepointObject.Permission.class), -1L, 0L, libraryURL);
    }

    @Override
    public void moveSharepointObject(String path, String newPath) throws SharepointException {
        PathUtil.validatePath(path);
        PathUtil.validatePath(newPath);
        this._moveSharepointObjectOperation.execute(path, newPath);
    }

    @Override
    public void updateFile(String filePath, InputStream inputStream) throws SharepointException {
        PathUtil.validatePath(filePath);
        this._addOrUpdateFileOperation.execute(filePath, null, inputStream);
    }

    private <O extends Operation> O _buildOperation(Class<O> clazz) {
        try {
            Operation operation = (Operation)clazz.newInstance();
            operation.setCopySoap12Stub(this._copySoap12Stub);
            operation.setListsSoap12Stub(this._listsSoap12Stub);
            operation.setOperations(this._operations);
            operation.setSharepointConnectionInfo(this._sharepointConnectionInfo);
            operation.setVersionsSoap12Stub(this._versionsSoap12Stub);
            this._operations.put(clazz, operation);
            return (O)operation;
        }
        catch (Exception exception) {
            throw new SharepointRuntimeException("Unable to initialize operation " + clazz.getName(), exception);
        }
    }

    private void _buildOperations() {
        this._addFolderOperation = this._buildOperation(AddFolderOperation.class);
        this._addOrUpdateFileOperation = this._buildOperation(AddOrUpdateFileOperation.class);
        this._buildOperation(BatchOperation.class);
        this._cancelCheckOutFileOperation = this._buildOperation(CancelCheckOutFileOperation.class);
        this._checkInFileOperation = this._buildOperation(CheckInFileOperation.class);
        this._checkOutFileOperation = this._buildOperation(CheckOutFileOperation.class);
        this._copySharepointObjectOperation = this._buildOperation(CopySharepointObjectOperation.class);
        this._deleteSharepointObjectOperation = this._buildOperation(DeleteSharepointObjectOperation.class);
        this._getInputStreamOperation = this._buildOperation(GetInputStreamOperation.class);
        this._getSharepointObjectByIdOperation = this._buildOperation(GetSharepointObjectByIdOperation.class);
        this._getSharepointObjectByPathOperation = this._buildOperation(GetSharepointObjectByPathOperation.class);
        this._getSharepointObjectsByFolderOperation = this._buildOperation(GetSharepointObjectsByFolderOperation.class);
        this._getSharepointObjectsByNameOperation = this._buildOperation(GetSharepointObjectsByNameOperation.class);
        this._getSharepointObjectsByQueryOperation = this._buildOperation(GetSharepointObjectsByQueryOperation.class);
        this._getSharepointVersionsOperation = this._buildOperation(GetSharepointVersionsOperation.class);
        this._moveSharepointObjectOperation = this._buildOperation(MoveSharepointObjectOperation.class);
        Set<Map.Entry<Class<? extends Operation>, Operation>> set = this._operations.entrySet();
        for (Map.Entry<Class<? extends Operation>, Operation> entry : set) {
            Operation operation = entry.getValue();
            operation.afterPropertiesSet();
        }
    }

    private void _configureStub(Stub stub, URL url) {
        ServiceClient serviceClient = stub._getServiceClient();
        Options options = serviceClient.getOptions();
        HttpTransportPropertiesImpl.Authenticator authenticator = new HttpTransportPropertiesImpl.Authenticator();
        authenticator.setAllowedRetry(true);
        authenticator.setAuthSchemes(Collections.singletonList("NTLM"));
        authenticator.setDomain(url.getHost());
        authenticator.setHost(url.getHost());
        authenticator.setPassword(this._sharepointConnectionInfo.getPassword());
        authenticator.setPort(url.getPort());
        authenticator.setPreemptiveAuthentication(true);
        authenticator.setUsername(this._sharepointConnectionInfo.getUserName());
        options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        options.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
    }

    private URL _getServiceURL(String serviceName) {
        URL url = this._sharepointConnectionInfo.getServiceURL();
        return URLUtil.toURL(StringBundler.concat((Object[])new Object[]{url, "_vti_bin/", serviceName, ".asmx"}));
    }

    private void _initCopyStub() {
        URL serviceURL = this._getServiceURL("copy");
        try {
            this._copySoap12Stub = new CopySoap12Stub(null, serviceURL.toString());
            this._configureStub((Stub)this._copySoap12Stub, serviceURL);
        }
        catch (Exception exception) {
            throw new SharepointRuntimeException("Unable to configure SOAP endpoint " + String.valueOf(serviceURL), exception);
        }
    }

    private void _initListsStub() {
        URL serviceURL = this._getServiceURL("lists");
        try {
            this._listsSoap12Stub = new ListsSoap12Stub(null, serviceURL.toExternalForm());
            this._configureStub((Stub)this._listsSoap12Stub, serviceURL);
        }
        catch (Exception exception) {
            throw new SharepointRuntimeException("Unable to configure SOAP endpoint " + String.valueOf(serviceURL), exception);
        }
    }

    private void _initVersionsStub() {
        URL serviceURL = this._getServiceURL("versions");
        try {
            this._versionsSoap12Stub = new VersionsSoap12Stub(null, serviceURL.toExternalForm());
            this._configureStub((Stub)this._versionsSoap12Stub, serviceURL);
        }
        catch (Exception exception) {
            throw new SharepointRuntimeException("Unable to configure SOAP endpoint " + String.valueOf(serviceURL), exception);
        }
    }
}

