/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import com.liferay.sharepoint.soap.repository.connector.SharepointResultException;
import com.liferay.sharepoint.soap.repository.connector.internal.util.RemoteExceptionSharepointExceptionMapper;
import com.liferay.sharepoint.soap.repository.connector.operation.BaseOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.QueryServiceStubResult;
import com.microsoft.webservices.sharepoint.queryservice.QueryServiceSoap12Stub;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import search.microsoft.QueryDocument;
import search.microsoft.QueryResponseDocument;

public final class GetObjectsByQueryPacketOperation
extends BaseOperation {
    private static final Log _log = LogFactoryUtil.getLog(GetObjectsByQueryPacketOperation.class);
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;
    private QueryServiceSoap12Stub _queryServiceSoap12Stub;
    private String _searchPrefix;
    private int _searchPrefixLength;

    @Override
    public void afterPropertiesSet() {
        this._getSharepointObjectByPathOperation = this.getOperation(GetSharepointObjectByPathOperation.class);
        this._searchPrefix = this.sharepointConnectionInfo.getServiceURL() + this.sharepointConnectionInfo.getLibraryPath();
        this._searchPrefixLength = this._searchPrefix.length();
    }

    public List<SharepointObject> execute(String queryPacket) throws SharepointException {
        try {
            QueryResponseDocument queryResponseDocument = this._queryServiceSoap12Stub.query(this._getQueryDocument(queryPacket));
            return this._getSharepointObjects(queryResponseDocument);
        }
        catch (RemoteException remoteException) {
            throw RemoteExceptionSharepointExceptionMapper.map(remoteException, this.sharepointConnectionInfo);
        }
    }

    public void setQueryServiceSoap12Stub(QueryServiceSoap12Stub queryServiceSoap12Stub) {
        this._queryServiceSoap12Stub = queryServiceSoap12Stub;
    }

    private QueryDocument _getQueryDocument(String queryPacket) {
        QueryDocument queryDocument = QueryDocument.Factory.newInstance();
        QueryDocument.Query query = queryDocument.addNewQuery();
        query.setQueryXml(queryPacket);
        return queryDocument;
    }

    private List<SharepointObject> _getSharepointObjects(QueryResponseDocument queryResponseDocument) throws SharepointException {
        QueryResponseDocument.QueryResponse queryResponse = queryResponseDocument.getQueryResponse();
        QueryServiceStubResult queryServiceStubResult = new QueryServiceStubResult(queryResponse.getQueryResult());
        if (!queryServiceStubResult.isSuccess()) {
            throw new SharepointResultException(queryServiceStubResult.getStatus(), queryServiceStubResult.getDebugErrorMessage());
        }
        if (queryServiceStubResult.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> queryServiceSoapResultLinkURLs = queryServiceStubResult.getLinkURLs();
        return TransformUtil.transform(queryServiceSoapResultLinkURLs, queryServiceSoapResultLinkURL -> {
            if (!queryServiceSoapResultLinkURL.startsWith(this._searchPrefix)) {
                return null;
            }
            String path = queryServiceSoapResultLinkURL.substring(this._searchPrefixLength);
            SharepointObject sharepointObject = this._getSharepointObjectByPathOperation.execute(path);
            if (sharepointObject != null) {
                return sharepointObject;
            }
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Ignored Sharepoint object at path " + path));
            }
            return null;
        });
    }
}

