/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointResultException;
import com.liferay.sharepoint.soap.repository.connector.internal.util.RemoteExceptionSharepointExceptionMapper;
import com.liferay.sharepoint.soap.repository.connector.operation.BaseOperation;
import com.liferay.sharepoint.soap.repository.connector.schema.XMLUtil;
import com.liferay.sharepoint.soap.repository.connector.schema.batch.Batch;
import com.microsoft.schemas.sharepoint.soap.UpdateListItemsDocument;
import com.microsoft.schemas.sharepoint.soap.UpdateListItemsResponseDocument;
import java.rmi.RemoteException;
import java.util.Objects;
import org.w3c.dom.Node;

public final class BatchOperation
extends BaseOperation {
    public void execute(Batch batch) throws SharepointException {
        try {
            UpdateListItemsResponseDocument updateListItemsResponseDocument = this.listsSoap12Stub.updateListItems(this._getUpdateListItemsDocument(batch));
            this._processUpdateListItemsResponseDocument(updateListItemsResponseDocument);
        }
        catch (RemoteException remoteException) {
            throw RemoteExceptionSharepointExceptionMapper.map(remoteException, this.sharepointConnectionInfo);
        }
    }

    private UpdateListItemsDocument _getUpdateListItemsDocument(Batch batch) {
        UpdateListItemsDocument updateListItemsDocument = UpdateListItemsDocument.Factory.newInstance();
        UpdateListItemsDocument.UpdateListItems updateListItems = updateListItemsDocument.addNewUpdateListItems();
        updateListItems.setListName(this.sharepointConnectionInfo.getLibraryName());
        UpdateListItemsDocument.UpdateListItems.Updates updates = updateListItems.addNewUpdates();
        Node node = updates.getDomNode();
        node.appendChild(XMLUtil.toNode(node.getOwnerDocument(), batch));
        return updateListItemsDocument;
    }

    private void _processUpdateListItemsResponseDocument(UpdateListItemsResponseDocument updateListItemsResponseDocument) throws SharepointException {
        UpdateListItemsResponseDocument.UpdateListItemsResponse updateListItemsResponse = updateListItemsResponseDocument.getUpdateListItemsResponse();
        UpdateListItemsResponseDocument.UpdateListItemsResponse.UpdateListItemsResult updateListItemsResult = updateListItemsResponse.getUpdateListItemsResult();
        Node node = updateListItemsResult.getDomNode();
        Node resultsNode = node.getFirstChild();
        Node resultNode = resultsNode.getFirstChild();
        Node errorCodeNode = XMLUtil.getNode("ErrorCode", resultNode);
        String errorCode = XMLUtil.toString(errorCodeNode.getFirstChild());
        if (!Objects.equals(errorCode, "0x00000000")) {
            Node errorTextNode = XMLUtil.getNode("ErrorText", resultNode);
            String errorText = XMLUtil.toString(errorTextNode.getFirstChild());
            errorText = errorText.replaceAll("\n", "|");
            throw new SharepointResultException(errorCode, errorText);
        }
    }
}

