/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.sharepoint.soap.repository.SharepointWSRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"repository.target.class.name=com.liferay.sharepoint.soap.repository.SharepointWSRepository"}, service={RepositoryFactory.class})
public class SharepointWSRepositoryFactory
implements RepositoryFactory {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private RepositoryEntryLocalService _repositoryEntryLocalService;
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
        SharepointWSRepository sharepointWSRepository = (SharepointWSRepository)this.createRepository(repositoryId);
        return sharepointWSRepository.getLocalRepository();
    }

    public com.liferay.portal.kernel.repository.Repository createRepository(long repositoryId) throws PortalException {
        SharepointWSRepository sharepointWSRepository = new SharepointWSRepository();
        this._setupRepository(this._repositoryLocalService.getRepository(repositoryId), (BaseRepository)sharepointWSRepository);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            try {
                sharepointWSRepository.initRepository();
            }
            catch (Exception exception) {
                throw new RepositoryException((Throwable)exception);
            }
        }
        return sharepointWSRepository;
    }

    private void _setupRepository(Repository repository, BaseRepository baseRepository) {
        baseRepository.setAssetEntryLocalService(this._assetEntryLocalService);
        baseRepository.setCompanyId(repository.getCompanyId());
        baseRepository.setCompanyLocalService(this._companyLocalService);
        baseRepository.setDLAppHelperLocalService(this._dlAppHelperLocalService);
        baseRepository.setDLFolderLocalService(this._dlFolderLocalService);
        baseRepository.setGroupId(repository.getGroupId());
        baseRepository.setRepositoryEntryLocalService(this._repositoryEntryLocalService);
        baseRepository.setRepositoryId(repository.getRepositoryId());
        baseRepository.setTypeSettingsProperties(repository.getTypeSettingsProperties());
        baseRepository.setUserLocalService(this._userLocalService);
    }
}

