/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.search;

import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.util.StringBundler;

public class LiferayQueryExplainer {
    public String explain(Query query) {
        StringBundler sb = new StringBundler();
        this._explain(sb, query);
        return sb.toString();
    }

    private void _explain(StringBundler sb, BooleanQuery booleanQuery) {
        for (BooleanClause booleanClause : booleanQuery.clauses()) {
            BooleanClauseOccur booleanClauseOccur = booleanClause.getBooleanClauseOccur();
            Query query = (Query)booleanClause.getClause();
            this._print(sb, "<" + booleanClauseOccur.getName() + ">");
            this._explain(sb, query);
            this._print(sb, "</" + booleanClauseOccur.getName() + ">");
        }
    }

    private void _explain(StringBundler sb, Query query) {
        if (query instanceof BooleanQuery) {
            this._explain(sb, (BooleanQuery)query);
        } else if (query instanceof TermQuery) {
            this._explain(sb, (TermQuery)query);
        } else if (query instanceof TermRangeQuery) {
            this._explain(sb, (TermRangeQuery)query);
        } else if (query instanceof WildcardQuery) {
            this._explain(sb, (WildcardQuery)query);
        }
    }

    private void _explain(StringBundler sb, QueryTerm queryTerm) {
        this._print(sb, StringBundler.concat((String[])new String[]{queryTerm.getField(), " == \"", queryTerm.getValue(), "\""}));
    }

    private void _explain(StringBundler sb, TermQuery termQuery) {
        this._explain(sb, termQuery.getQueryTerm());
    }

    private void _explain(StringBundler sb, TermRangeQuery termRangeQuery) {
        String lowerTerm = termRangeQuery.getLowerTerm();
        String upperTerm = termRangeQuery.getUpperTerm();
        String openInterval = termRangeQuery.includesLower() ? "[" : "(";
        String closeInterval = termRangeQuery.includesUpper() ? "]" : ")";
        this._print(sb, StringBundler.concat((String[])new String[]{termRangeQuery.getField(), " \u2208 ", openInterval, "\"", lowerTerm, "\", \"", upperTerm, "\"", closeInterval}));
    }

    private void _explain(StringBundler sb, WildcardQuery wildcardQuery) {
        this._explain(sb, wildcardQuery.getQueryTerm());
    }

    private void _print(StringBundler sb, String s) {
        sb.append(s);
    }
}

