/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.connector.operation;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import com.liferay.sharepoint.soap.repository.connector.internal.util.RemoteExceptionSharepointExceptionMapper;
import com.liferay.sharepoint.soap.repository.connector.operation.BaseOperation;
import com.liferay.sharepoint.soap.repository.connector.operation.SharepointConstants;
import com.liferay.sharepoint.soap.repository.connector.schema.XMLUtil;
import com.liferay.sharepoint.soap.repository.connector.schema.query.Query;
import com.liferay.sharepoint.soap.repository.connector.schema.query.QueryField;
import com.liferay.sharepoint.soap.repository.connector.schema.query.QueryOptionsList;
import com.liferay.sharepoint.soap.repository.connector.schema.query.option.ExpandUserFieldQueryOption;
import com.microsoft.schemas.sharepoint.soap.GetListItemsDocument;
import com.microsoft.schemas.sharepoint.soap.GetListItemsResponseDocument;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GetSharepointObjectsByQueryOperation
extends BaseOperation {
    private static final Log _log = LogFactoryUtil.getLog(GetSharepointObjectsByQueryOperation.class);
    private int _pathPrefixToRemoveLength;

    @Override
    public void afterPropertiesSet() {
        String libraryPath = this.sharepointConnectionInfo.getLibraryPath();
        String sitePath = this.sharepointConnectionInfo.getSitePath();
        this._pathPrefixToRemoveLength = libraryPath.length() + sitePath.length();
    }

    public List<SharepointObject> execute(Query query, QueryOptionsList queryOptionsList, String ... queryFieldNames) throws SharepointException {
        try {
            GetListItemsResponseDocument getListItemsResponseDocument = this.listsSoap12Stub.getListItems(this.getGetListItemsDocument(query, this._getQueryOptionsList(queryOptionsList), queryFieldNames));
            this.log(query, queryOptionsList, getListItemsResponseDocument);
            return this.getSharepointObjects(getListItemsResponseDocument);
        }
        catch (RemoteException remoteException) {
            throw RemoteExceptionSharepointExceptionMapper.map(remoteException);
        }
    }

    protected GetListItemsDocument getGetListItemsDocument(Query query, QueryOptionsList queryOptionsList, String ... queryFieldNames) {
        GetListItemsDocument getListItemsDocument = GetListItemsDocument.Factory.newInstance();
        GetListItemsDocument.GetListItems getListItems = getListItemsDocument.addNewGetListItems();
        getListItems.setListName(this.sharepointConnectionInfo.getLibraryName());
        getListItems.setQuery(this.getQuery(query));
        getListItems.setQueryOptions(this.getQueryOptions(queryOptionsList));
        getListItems.setViewFields(this.getViewFields(queryFieldNames));
        getListItems.setViewName("");
        getListItems.setRowLimit("");
        return getListItemsDocument;
    }

    protected String getNodeValue(Node node, int index) {
        if (node == null) {
            return null;
        }
        String nodeValue = node.getNodeValue();
        String[] parts = nodeValue.split(SharepointConstants.PATTERN_MULTI_VALUE_SEPARATOR);
        if (index < parts.length) {
            return parts[index];
        }
        return null;
    }

    protected Set<SharepointObject.Permission> getPermissions(String permissionsHexMask) {
        EnumSet<SharepointObject.Permission> permissions = EnumSet.noneOf(SharepointObject.Permission.class);
        long permisssionsMask = Long.valueOf(permissionsHexMask.substring(2), 16);
        for (SharepointObject.Permission permission : SharepointObject.Permission.values()) {
            long permissionBit = permisssionsMask & permission.getMask();
            if (permissionBit == 0L) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    protected GetListItemsDocument.GetListItems.Query getQuery(Query query) {
        GetListItemsDocument.GetListItems.Query getListItemsQuery = GetListItemsDocument.GetListItems.Query.Factory.newInstance();
        Node node = getListItemsQuery.getDomNode();
        for (Node childrenNode : XMLUtil.toNodes(node.getOwnerDocument(), query)) {
            node.appendChild(childrenNode);
        }
        return getListItemsQuery;
    }

    protected GetListItemsDocument.GetListItems.QueryOptions getQueryOptions(QueryOptionsList queryOptionsList) {
        GetListItemsDocument.GetListItems.QueryOptions queryOptions = GetListItemsDocument.GetListItems.QueryOptions.Factory.newInstance();
        Node node = queryOptions.getDomNode();
        for (Node childrenNode : XMLUtil.toNodes(node.getOwnerDocument(), queryOptionsList)) {
            node.appendChild(childrenNode);
        }
        return queryOptions;
    }

    protected List<SharepointObject> getSharepointObjects(GetListItemsResponseDocument getListItemsResponseDocument) {
        GetListItemsResponseDocument.GetListItemsResponse getListItemsResponse = getListItemsResponseDocument.getGetListItemsResponse();
        GetListItemsResponseDocument.GetListItemsResponse.GetListItemsResult getListItemsResult = getListItemsResponse.getGetListItemsResult();
        Node getListItemsResultNode = getListItemsResult.getDomNode();
        Node dataElement = XMLUtil.getNode("Data", getListItemsResultNode.getFirstChild());
        if (dataElement == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = dataElement.getChildNodes();
        if (nodeList == null) {
            return Collections.emptyList();
        }
        ArrayList<SharepointObject> sharepointObjects = new ArrayList<SharepointObject>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String localName = node.getLocalName();
            if (localName == null || !StringUtil.equalsIgnoreCase((String)localName, (String)"row")) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node owsFileRefNode = namedNodeMap.getNamedItem("ows_FileRef");
            String path = this.getNodeValue(owsFileRefNode, 1);
            path = path.substring(this._pathPrefixToRemoveLength);
            Node owsAuthorNode = namedNodeMap.getNamedItem("ows_Author");
            Node owsCheckedOutUserIdNode = namedNodeMap.getNamedItem("ows_CheckoutUser");
            if (owsCheckedOutUserIdNode == null) {
                owsCheckedOutUserIdNode = namedNodeMap.getNamedItem("ows_CheckedOutTitle");
            }
            Node owsCreatedX0020DateNode = namedNodeMap.getNamedItem("ows_Created_x0020_Date");
            Node owsFSObjTypeNode = namedNodeMap.getNamedItem("ows_FSObjType");
            Node owsLastX0020ModifiedNode = namedNodeMap.getNamedItem("ows_Last_x0020_Modified");
            Node owsPermMaskNode = namedNodeMap.getNamedItem("ows_PermMask");
            Node owsFileX0020SizeNode = namedNodeMap.getNamedItem("ows_File_x0020_Size");
            SharepointObject sharepointObject = new SharepointObject(this.getNodeValue(owsAuthorNode, 1), this.getNodeValue(owsCheckedOutUserIdNode, 1), this.parseDate(this.getNodeValue(owsCreatedX0020DateNode, 1)), Objects.equals(this.getNodeValue(owsFSObjTypeNode, 1), "1"), this.parseDate(this.getNodeValue(owsLastX0020ModifiedNode, 1)), path, this.getPermissions(owsPermMaskNode.getNodeValue()), GetterUtil.getLong((String)this.getNodeValue(owsFileRefNode, 0)), GetterUtil.getLong((String)this.getNodeValue(owsFileX0020SizeNode, 1)), this.toURL(path));
            sharepointObjects.add(sharepointObject);
        }
        return sharepointObjects;
    }

    protected GetListItemsDocument.GetListItems.ViewFields getViewFields(String ... queryFieldNames) {
        GetListItemsDocument.GetListItems.ViewFields viewFields = GetListItemsDocument.GetListItems.ViewFields.Factory.newInstance();
        Node node = viewFields.getDomNode();
        for (Node childNode : XMLUtil.toNodes(node.getOwnerDocument(), this.toQueryFields(queryFieldNames))) {
            node.appendChild(childNode);
        }
        return viewFields;
    }

    protected void log(Query query, QueryOptionsList queryOptionsList, GetListItemsResponseDocument getListItemsResponseDocument) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Query: ", query, "\nQuery options: ", queryOptionsList, "\nResult: ", getListItemsResponseDocument.xmlText()}));
    }

    protected Date parseDate(String dateString) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(SharepointConstants.SHAREPOINT_OBJECT_TIME_ZONE);
            return dateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to parse " + dateString + " to a Sharepoint object date"), (Throwable)parseException);
            }
            return new Date(0L);
        }
    }

    protected QueryField[] toQueryFields(String[] queryFieldNames) {
        QueryField[] queryFields = new QueryField[queryFieldNames.length];
        for (int i = 0; i < queryFieldNames.length; ++i) {
            queryFields[i] = new QueryField(queryFieldNames[i]);
        }
        return queryFields;
    }

    private QueryOptionsList _getQueryOptionsList(QueryOptionsList queryOptionsList) {
        if (!queryOptionsList.contains(ExpandUserFieldQueryOption.class)) {
            return queryOptionsList.append(new ExpandUserFieldQueryOption(true));
        }
        return queryOptionsList;
    }
}

