/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository;

import com.liferay.document.library.kernel.exception.DuplicateFileException;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.exception.SourceFileNameException;
import com.liferay.document.library.repository.external.CredentialsProvider;
import com.liferay.document.library.repository.external.ExtRepository;
import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.ExtRepositoryFileEntry;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersion;
import com.liferay.document.library.repository.external.ExtRepositoryFileVersionDescriptor;
import com.liferay.document.library.repository.external.ExtRepositoryFolder;
import com.liferay.document.library.repository.external.ExtRepositoryObject;
import com.liferay.document.library.repository.external.ExtRepositoryObjectType;
import com.liferay.document.library.repository.external.ExtRepositorySearchResult;
import com.liferay.document.library.repository.external.cache.ConnectionBuilder;
import com.liferay.document.library.repository.external.cache.ConnectionCache;
import com.liferay.document.library.repository.external.search.ExtRepositoryQueryMapper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sharepoint.soap.repository.connector.SharepointConnection;
import com.liferay.sharepoint.soap.repository.connector.SharepointConnectionFactory;
import com.liferay.sharepoint.soap.repository.connector.SharepointException;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import com.liferay.sharepoint.soap.repository.connector.SharepointRuntimeException;
import com.liferay.sharepoint.soap.repository.connector.SharepointVersion;
import com.liferay.sharepoint.soap.repository.connector.operation.PathUtil;
import com.liferay.sharepoint.soap.repository.connector.operation.URLUtil;
import com.liferay.sharepoint.soap.repository.model.SharepointWSFileEntry;
import com.liferay.sharepoint.soap.repository.model.SharepointWSFileVersion;
import com.liferay.sharepoint.soap.repository.model.SharepointWSFolder;
import com.liferay.sharepoint.soap.repository.model.SharepointWSObject;
import com.liferay.sharepoint.soap.repository.search.SharepointQueryBuilder;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharepointWSRepository
extends ExtRepositoryAdapter
implements ConnectionBuilder<SharepointConnection>,
ExtRepository {
    private static final String _CONFIGURATION_WS = "SHAREPOINT_WS";
    private static final String _LIBRARY_NAME = "LIBRARY_NAME";
    private static final String _LIBRARY_PATH = "LIBRARY_PATH";
    private static final String _SERVER_VERSION = "SERVER_VERSION";
    private static final String _SHAREPOINT_2013_VALUE = SharepointConnection.ServerVersion.SHAREPOINT_2013.getValue();
    private static final String _SITE_URL = "SITE_URL";
    private static final String[] _SUPPORTED_CONFIGURATIONS = new String[]{"SHAREPOINT_WS"};
    private static final String[][] _SUPPORTED_PARAMETERS = new String[][]{{"LIBRARY_NAME", "LIBRARY_PATH", "SERVER_VERSION", "SITE_URL"}};
    private static final Map<ExtRepositoryObjectType<?>, SharepointConnection.ObjectTypeFilter> _objectTypeFilters = new HashMap<ExtRepositoryObjectType<?>, SharepointConnection.ObjectTypeFilter>(){
        {
            this.put(ExtRepositoryObjectType.FILE, SharepointConnection.ObjectTypeFilter.FILES);
            this.put(ExtRepositoryObjectType.FOLDER, SharepointConnection.ObjectTypeFilter.FOLDERS);
            this.put(ExtRepositoryObjectType.OBJECT, SharepointConnection.ObjectTypeFilter.ALL);
        }
    };
    private ConnectionCache<SharepointConnection> _connectionCache;
    private CredentialsProvider _credentialsProvider;
    private String _host;
    private String _libraryName;
    private String _libraryPath;
    private int _port;
    private String _protocol;
    private String _rootFolderKey;
    private SharepointConnection.ServerVersion _serverVersion;
    private String _sitePath;

    public SharepointWSRepository() {
        super(null);
    }

    public ExtRepositoryFileEntry addExtRepositoryFileEntry(String extRepositoryParentFolderKey, String mimeType, String title, String description, String changeLog, InputStream inputStream) throws PortalException {
        String filePath = null;
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject parentFolderSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryParentFolderKey));
            String parentFolderPath = parentFolderSharepointObject.getPath();
            filePath = PathUtil.buildPath(parentFolderPath, title);
            sharepointConnection.addFile(parentFolderPath, title, changeLog, inputStream);
            SharepointObject fileSharepointObject = sharepointConnection.getSharepointObject(filePath);
            return new SharepointWSFileEntry(fileSharepointObject);
        }
        catch (SharepointException sharepointException) {
            this._processSharepointObjectException(false, filePath, title);
            throw new SystemException((Throwable)sharepointException);
        }
        catch (SharepointRuntimeException sharepointRuntimeException) {
            throw new SystemException((Throwable)sharepointRuntimeException);
        }
    }

    public ExtRepositoryFolder addExtRepositoryFolder(String extRepositoryParentFolderKey, String name, String description) throws PortalException {
        String folderPath = null;
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject parentFolderSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryParentFolderKey));
            String parentFolderPath = parentFolderSharepointObject.getPath();
            folderPath = PathUtil.buildPath(parentFolderPath, name);
            sharepointConnection.addFolder(parentFolderPath, name);
            SharepointObject folderSharepointObject = sharepointConnection.getSharepointObject(folderPath);
            return new SharepointWSFolder(folderSharepointObject);
        }
        catch (SharepointException sharepointException) {
            this._processSharepointObjectException(true, folderPath, name);
            throw new SystemException((Throwable)sharepointException);
        }
        catch (SharepointRuntimeException sharepointRuntimeException) {
            throw new SystemException((Throwable)sharepointRuntimeException);
        }
    }

    public SharepointConnection buildConnection() throws RepositoryException {
        try {
            return SharepointConnectionFactory.getInstance(this._serverVersion, this._protocol, this._host, this._port, this._sitePath, this._libraryName, this._libraryPath, this._credentialsProvider.getLogin(), this._credentialsProvider.getPassword());
        }
        catch (SharepointRuntimeException sharepointRuntimeException) {
            throw new RepositoryException("Unable to communicate with the Sharepoint server", (Throwable)sharepointRuntimeException);
        }
    }

    public ExtRepositoryFileVersion cancelCheckOut(String extRepositoryFileEntryKey) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject fileSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFileEntryKey));
            String filePath = fileSharepointObject.getPath();
            sharepointConnection.cancelCheckOutFile(filePath);
            return null;
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public void checkInExtRepositoryFileEntry(String extRepositoryFileEntryKey, boolean createMajorVersion, String changeLog) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject fileSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFileEntryKey));
            String filePath = fileSharepointObject.getPath();
            SharepointConnection.CheckInType checkInType = null;
            checkInType = createMajorVersion ? SharepointConnection.CheckInType.MAJOR : SharepointConnection.CheckInType.MINOR;
            sharepointConnection.checkInFile(filePath, changeLog, checkInType);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public ExtRepositoryFileEntry checkOutExtRepositoryFileEntry(String extRepositoryFileEntryKey) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject fileSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFileEntryKey));
            String filePath = fileSharepointObject.getPath();
            sharepointConnection.checkOutFile(filePath);
            return new SharepointWSFileEntry(fileSharepointObject);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public <T extends ExtRepositoryObject> T copyExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFileEntryKey, String newExtRepositoryFolderKey, String newTitle) throws PortalException {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject fileSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFileEntryKey));
            String filePath = fileSharepointObject.getPath();
            SharepointObject folderSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(newExtRepositoryFolderKey));
            String folderPath = folderSharepointObject.getPath();
            String newFilePath = PathUtil.buildPath(folderPath, newTitle);
            sharepointConnection.copySharepointObject(filePath, newFilePath);
            SharepointObject newSharepointObject = sharepointConnection.getSharepointObject(newFilePath);
            return this._toExtRepositoryObject(extRepositoryObjectType, newSharepointObject);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public void deleteExtRepositoryObject(ExtRepositoryObjectType<? extends ExtRepositoryObject> extRepositoryObjectType, String extRepositoryObjectKey) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject sharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryObjectKey));
            sharepointConnection.deleteSharepointObject(sharepointObject.getPath());
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public String getAuthType() {
        return "screenName";
    }

    public InputStream getContentStream(ExtRepositoryFileEntry extRepositoryFileEntry) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointWSFileEntry sharepointWSFileEntry = (SharepointWSFileEntry)extRepositoryFileEntry;
            SharepointObject fileSharepointObject = sharepointWSFileEntry.getSharepointObject();
            return sharepointConnection.getInputStream(fileSharepointObject);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public InputStream getContentStream(ExtRepositoryFileVersion extRepositoryFileVersion) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointWSFileVersion sharepointWSFileVersion = (SharepointWSFileVersion)extRepositoryFileVersion;
            return sharepointConnection.getInputStream(sharepointWSFileVersion.getSharepointVersion());
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public ExtRepositoryFileVersion getExtRepositoryFileVersion(ExtRepositoryFileEntry extRepositoryFileEntry, String version) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointWSFileEntry sharepointWSFileEntry = (SharepointWSFileEntry)extRepositoryFileEntry;
            SharepointObject fileSharepointObject = sharepointWSFileEntry.getSharepointObject();
            String filePath = fileSharepointObject.getPath();
            List<SharepointVersion> sharepointVersions = sharepointConnection.getSharepointVersions(filePath);
            for (SharepointVersion sharepointVersion : sharepointVersions) {
                if (!version.equals(sharepointVersion.getVersion())) continue;
                return new SharepointWSFileVersion(sharepointVersion);
            }
            return null;
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public ExtRepositoryFileVersionDescriptor getExtRepositoryFileVersionDescriptor(String extRepositoryFileVersionKey) {
        String[] extRepositoryFileVersionKeyParts = StringUtil.split((String)extRepositoryFileVersionKey, (String)"@");
        String extRepositoryFileEntryKey = extRepositoryFileVersionKeyParts[0];
        String version = extRepositoryFileVersionKeyParts[1];
        return new ExtRepositoryFileVersionDescriptor(extRepositoryFileEntryKey, version);
    }

    public List<ExtRepositoryFileVersion> getExtRepositoryFileVersions(ExtRepositoryFileEntry extRepositoryFileEntry) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointWSFileEntry sharepointWSFileEntry = (SharepointWSFileEntry)extRepositoryFileEntry;
            SharepointObject fileSharepointObject = sharepointWSFileEntry.getSharepointObject();
            String filePath = fileSharepointObject.getPath();
            List<SharepointVersion> sharepointVersions = sharepointConnection.getSharepointVersions(filePath);
            ArrayList<ExtRepositoryFileVersion> sharepointWSVersions = new ArrayList<ExtRepositoryFileVersion>();
            for (SharepointVersion sharepointVersion : sharepointVersions) {
                SharepointWSFileVersion sharepointWSFileVersion = new SharepointWSFileVersion(sharepointVersion);
                sharepointWSVersions.add(sharepointWSFileVersion);
            }
            return sharepointWSVersions;
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public <T extends ExtRepositoryObject> T getExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey) throws PortalException {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject sharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryObjectKey));
            if (sharepointObject == null) {
                if (extRepositoryObjectType == ExtRepositoryObjectType.FOLDER) {
                    throw new NoSuchFolderException(extRepositoryObjectKey);
                }
                throw new NoSuchFileEntryException(extRepositoryObjectKey);
            }
            return this._toExtRepositoryObject(extRepositoryObjectType, sharepointObject);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public <T extends ExtRepositoryObject> T getExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFolderKey, String title) throws PortalException {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject folderSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFolderKey));
            String folderPath = folderSharepointObject.getPath();
            SharepointConnection.ObjectTypeFilter objectTypeFilter = this._toObjectTypeFilter(extRepositoryObjectType);
            List<SharepointObject> sharepointObjects = sharepointConnection.getSharepointObjects(folderPath, objectTypeFilter);
            for (SharepointObject sharepointObject : sharepointObjects) {
                if (!title.equals(sharepointObject.getName())) continue;
                return this._toExtRepositoryObject(extRepositoryObjectType, sharepointObject);
            }
            if (extRepositoryObjectType == ExtRepositoryObjectType.FOLDER) {
                throw new NoSuchFolderException(title);
            }
            throw new NoSuchFileEntryException(title);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public <T extends ExtRepositoryObject> List<T> getExtRepositoryObjects(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryFolderKey) throws PortalException {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject folderSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFolderKey));
            String folderPath = folderSharepointObject.getPath();
            SharepointConnection.ObjectTypeFilter objectTypeFilter = this._toObjectTypeFilter(extRepositoryObjectType);
            List<SharepointObject> sharepointObjects = sharepointConnection.getSharepointObjects(folderPath, objectTypeFilter);
            ArrayList<T> extRepositoryObjects = new ArrayList<T>();
            for (SharepointObject sharepointObject : sharepointObjects) {
                T extRepositoryObject = this._toExtRepositoryObject(extRepositoryObjectType, sharepointObject);
                extRepositoryObjects.add(extRepositoryObject);
            }
            return extRepositoryObjects;
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public int getExtRepositoryObjectsCount(ExtRepositoryObjectType<? extends ExtRepositoryObject> extRepositoryObjectType, String extRepositoryFolderKey) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject folderSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFolderKey));
            String folderPath = folderSharepointObject.getPath();
            SharepointConnection.ObjectTypeFilter objectTypeFilter = this._toObjectTypeFilter(extRepositoryObjectType);
            return sharepointConnection.getSharepointObjectsCount(folderPath, objectTypeFilter);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public ExtRepositoryFolder getExtRepositoryParentFolder(ExtRepositoryObject extRepositoryObject) {
        try {
            SharepointWSObject sharepointWSObject = (SharepointWSObject)extRepositoryObject;
            SharepointObject sharepointObject = sharepointWSObject.getSharepointObject();
            String parentFolderPath = sharepointObject.getFolderPath();
            if (parentFolderPath == null) {
                return null;
            }
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject parentFolderSharepointObject = sharepointConnection.getSharepointObject(parentFolderPath);
            return new SharepointWSFolder(parentFolderSharepointObject);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public String getLiferayLogin(String extRepositoryLogin) {
        int index = extRepositoryLogin.lastIndexOf("\\");
        String login = extRepositoryLogin.substring(index + 1);
        if ((index = login.indexOf(",#")) == -1) {
            return login;
        }
        return login.substring(0, index);
    }

    public String getRootFolderKey() {
        return this._rootFolderKey;
    }

    public SharepointConnection getSharepointConnection() throws RepositoryException {
        return (SharepointConnection)this._connectionCache.getConnection();
    }

    public String getSharepointLogin(String liferayLogin) {
        return this._host + "\\" + liferayLogin;
    }

    public List<String> getSubfolderKeys(String extRepositoryFolderKey, boolean recurse) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject folderSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFolderKey));
            String folderPath = folderSharepointObject.getPath();
            ArrayList<String> extRepositoryFolderKeys = new ArrayList<String>();
            this._getSubfolderKeys(folderPath, extRepositoryFolderKeys);
            return extRepositoryFolderKeys;
        }
        catch (SharepointException sharepointException) {
            throw new SystemException((Throwable)sharepointException);
        }
    }

    public String[] getSupportedConfigurations() {
        return _SUPPORTED_CONFIGURATIONS;
    }

    public String[][] getSupportedParameters() {
        return _SUPPORTED_PARAMETERS;
    }

    public void initRepository(UnicodeProperties typeSettingsProperties, CredentialsProvider credentialsProvider) {
        try {
            String serverVersion;
            this._credentialsProvider = credentialsProvider;
            this._libraryName = typeSettingsProperties.getProperty(_LIBRARY_NAME);
            this._libraryPath = typeSettingsProperties.getProperty(_LIBRARY_PATH);
            if (Validator.isNull((String)this._libraryPath)) {
                this._libraryPath = this._libraryName;
            }
            this._serverVersion = (serverVersion = typeSettingsProperties.getProperty(_SERVER_VERSION, "")).equals(_SHAREPOINT_2013_VALUE) ? SharepointConnection.ServerVersion.SHAREPOINT_2013 : SharepointConnection.ServerVersion.SHAREPOINT_2010;
            String siteURL = typeSettingsProperties.getProperty(_SITE_URL);
            URL url = URLUtil.toURL(siteURL);
            this._host = url.getHost();
            this._protocol = url.getProtocol();
            this._port = this._getPort(url);
            this._sitePath = url.getPath();
            this._connectionCache = new ConnectionCache(SharepointConnection.class, this.getRepositoryId(), (ConnectionBuilder)this);
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            this._pingSharepointConnection(sharepointConnection);
            SharepointObject rootFolderSharepointObject = sharepointConnection.getSharepointObject("/");
            this._rootFolderKey = String.valueOf(rootFolderSharepointObject.getSharepointObjectId());
        }
        catch (SharepointException sharepointException) {
            throw new SystemException((Throwable)sharepointException);
        }
    }

    public <T extends ExtRepositoryObject> T moveExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, String extRepositoryObjectKey, String newExtRepositoryFolderKey, String newTitle) throws PortalException {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject sharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryObjectKey));
            String path = sharepointObject.getPath();
            SharepointObject folderSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(newExtRepositoryFolderKey));
            String folderPath = folderSharepointObject.getPath();
            String newPath = PathUtil.buildPath(folderPath, newTitle);
            this._validateExtension(path, newPath);
            if (path.equals(newPath)) {
                return this._toExtRepositoryObject(extRepositoryObjectType, sharepointObject);
            }
            sharepointConnection.moveSharepointObject(path, newPath);
            sharepointObject = sharepointConnection.getSharepointObject(newPath);
            return this._toExtRepositoryObject(extRepositoryObjectType, sharepointObject);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public List<ExtRepositorySearchResult<?>> search(SearchContext searchContext, Query query, ExtRepositoryQueryMapper extRepositoryQueryMapper) throws PortalException {
        ArrayList extRepositorySearchResults = new ArrayList();
        List<SharepointObject> sharepointObjects = this._search(searchContext, query, extRepositoryQueryMapper);
        sharepointObjects = this._filter(searchContext, sharepointObjects);
        for (SharepointObject sharepointObject : sharepointObjects) {
            Object extRepositoryObject = this._toExtRepositoryObject(ExtRepositoryObjectType.OBJECT, sharepointObject);
            ExtRepositorySearchResult extRepositorySearchResult = new ExtRepositorySearchResult(extRepositoryObject, 1.0f, "");
            extRepositorySearchResults.add(extRepositorySearchResult);
        }
        return extRepositorySearchResults;
    }

    public ExtRepositoryFileEntry updateExtRepositoryFileEntry(String extRepositoryFileEntryKey, String mimeType, InputStream inputStream) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            SharepointObject fileSharepointObject = sharepointConnection.getSharepointObject(this._toSharepointObjectId(extRepositoryFileEntryKey));
            String filePath = fileSharepointObject.getPath();
            sharepointConnection.updateFile(filePath, inputStream);
            return new SharepointWSFileEntry(fileSharepointObject);
        }
        catch (SharepointException | SharepointRuntimeException exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private List<SharepointObject> _filter(SearchContext searchContext, List<SharepointObject> sharepointObjects) {
        return ListUtil.subList(sharepointObjects, (int)searchContext.getStart(), (int)searchContext.getEnd());
    }

    private int _getPort(URL url) {
        int port = url.getPort();
        if (port != -1) {
            return port;
        }
        String protocol = url.getProtocol();
        if (protocol.equals("https")) {
            return 443;
        }
        return 80;
    }

    private void _getSubfolderKeys(String path, List<String> extRepositoryFolderKeys) {
        try {
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            List<SharepointObject> folderSharepointObjects = sharepointConnection.getSharepointObjects(path, SharepointConnection.ObjectTypeFilter.FOLDERS);
            for (SharepointObject folderSharepointObject : folderSharepointObjects) {
                String extRepositoryFolderKey = String.valueOf(folderSharepointObject.getSharepointObjectId());
                extRepositoryFolderKeys.add(extRepositoryFolderKey);
                this._getSubfolderKeys(folderSharepointObject.getPath(), extRepositoryFolderKeys);
            }
        }
        catch (SharepointException sharepointException) {
            throw new SystemException((Throwable)sharepointException);
        }
    }

    private void _pingSharepointConnection(SharepointConnection sharepointConnection) throws SharepointException {
        sharepointConnection.getSharepointObjectsCount("/", SharepointConnection.ObjectTypeFilter.FILES);
    }

    private void _processSharepointObjectException(boolean folder, String path, String name) throws PortalException {
        if (path == null) {
            return;
        }
        SharepointConnection sharepointConnection = this.getSharepointConnection();
        try {
            SharepointObject sharepointObject = sharepointConnection.getSharepointObject(path);
            if (sharepointObject == null) {
                return;
            }
            if (folder) {
                throw new DuplicateFolderNameException(name);
            }
            throw new DuplicateFileException(name);
        }
        catch (SharepointException sharepointException) {
            return;
        }
    }

    private List<SharepointObject> _search(SearchContext searchContext, Query query, ExtRepositoryQueryMapper extRepositoryQueryMapper) throws PortalException {
        try {
            SharepointQueryBuilder sharepointQueryBuilder = new SharepointQueryBuilder(this, searchContext, query, extRepositoryQueryMapper);
            SharepointConnection sharepointConnection = this.getSharepointConnection();
            return sharepointConnection.getSharepointObjects(sharepointQueryBuilder.getQuery(), sharepointQueryBuilder.getQueryOptionsList());
        }
        catch (SharepointException sharepointException) {
            throw new SystemException((Throwable)sharepointException);
        }
    }

    private <T extends ExtRepositoryObject> T _toExtRepositoryObject(ExtRepositoryObjectType<T> extRepositoryObjectType, SharepointObject sharepointObject) throws PortalException {
        if (sharepointObject.isFile()) {
            if (extRepositoryObjectType == ExtRepositoryObjectType.FOLDER) {
                throw new NoSuchFolderException(StringBundler.concat((Object[])new Object[]{"Invalid external repository object type ", extRepositoryObjectType, " for Sharepoint object ", sharepointObject}));
            }
            return (T)new SharepointWSFileEntry(sharepointObject);
        }
        if (extRepositoryObjectType == ExtRepositoryObjectType.FILE) {
            throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"Invalid external repository object type ", extRepositoryObjectType, " for Sharepoint object ", sharepointObject}));
        }
        return (T)new SharepointWSFolder(sharepointObject);
    }

    private SharepointConnection.ObjectTypeFilter _toObjectTypeFilter(ExtRepositoryObjectType<? extends ExtRepositoryObject> extRepositoryObjectType) {
        SharepointConnection.ObjectTypeFilter objectTypeFilter = _objectTypeFilters.get(extRepositoryObjectType);
        if (objectTypeFilter == null) {
            throw new IllegalArgumentException("Invalid external repository object type " + extRepositoryObjectType);
        }
        return objectTypeFilter;
    }

    private long _toSharepointObjectId(String key) {
        return GetterUtil.getLong((String)key);
    }

    private void _validateExtension(String oldPath, String newPath) throws PortalException {
        String oldExtension = PathUtil.getExtension(oldPath);
        String newExtension = PathUtil.getExtension(newPath);
        if (!newExtension.equals(oldExtension)) {
            throw new SourceFileNameException("Sharepoint connector does not support changing the file extension");
        }
    }
}

