/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.sharepoint.soap.repository;

import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.repository.RepositoryConfigurationBuilder;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.sharepoint.soap.repository.constants.SharepointWSConstants;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Cristina González
 */
@Component(service = RepositoryDefiner.class)
public class SharepointWSRepositoryDefiner extends BaseRepositoryDefiner {

	@Override
	public String getClassName() {
		return SharepointWSRepository.class.getName();
	}

	@Override
	public RepositoryConfiguration getRepositoryConfiguration() {
		return _repositoryConfiguration;
	}

	@Override
	public boolean isExternalRepository() {
		return true;
	}

	@Override
	public void registerCapabilities(
		CapabilityRegistry<DocumentRepository> capabilityRegistry) {

		capabilityRegistry.addSupportedCapability(
			ProcessorCapability.class,
			_portalCapabilityLocator.getProcessorCapability(
				capabilityRegistry.getTarget(),
				ProcessorCapability.ResourceGenerationStrategy.
					ALWAYS_GENERATE));
	}

	@Override
	public void registerRepositoryFactory(
		RepositoryFactoryRegistry repositoryFactoryRegistry) {

		repositoryFactoryRegistry.setRepositoryFactory(_repositoryFactory);
	}

	@Activate
	protected void activate() {
		RepositoryConfigurationBuilder repositoryConfigurationBuilder =
			new RepositoryConfigurationBuilder(
				_resourceBundleLoader,
				SharepointWSConstants.SHAREPOINT_LIBRARY_NAME,
				SharepointWSConstants.SHAREPOINT_LIBRARY_PATH,
				SharepointWSConstants.SHAREPOINT_SERVER_VERSION,
				SharepointWSConstants.SHAREPOINT_SITE_URL);

		_repositoryConfiguration = repositoryConfigurationBuilder.build();
	}

	@Deactivate
	protected void deactivate() {
		_repositoryConfiguration = null;
	}

	@Reference
	private PortalCapabilityLocator _portalCapabilityLocator;

	private RepositoryConfiguration _repositoryConfiguration;

	@Reference(
		target = "(repository.target.class.name=com.liferay.sharepoint.soap.repository.SharepointWSRepository)"
	)
	private RepositoryFactory _repositoryFactory;

	@Reference(
		target = "(bundle.symbolic.name=com.liferay.sharepoint.soap.repository)"
	)
	private ResourceBundleLoader _resourceBundleLoader;

}