/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.manager.internal.executor;

import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.server.manager.internal.executor.BaseExecutor;
import com.liferay.server.manager.internal.executor.Executor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"server.manager.executor.path=/plugins/plugin"}, service={Executor.class})
public class PluginExecutor
extends BaseExecutor {
    private static final Log _log = LogFactoryUtil.getLog(PluginExecutor.class);

    @Override
    public void executeCreate(HttpServletRequest httpServletRequest, JSONObject responseJSONObject, Queue<String> arguments) throws Exception {
        AutoDeploymentContext autoDeploymentContext = new AutoDeploymentContext();
        autoDeploymentContext.setContext(arguments.poll());
        File tempFile = this.getTempFile(httpServletRequest, responseJSONObject);
        if (tempFile == null) {
            return;
        }
        autoDeploymentContext.setFile(tempFile);
        DeployManagerUtil.deploy((AutoDeploymentContext)autoDeploymentContext);
        boolean success = FileUtils.deleteQuietly((File)tempFile.getParentFile());
        if (success) {
            return;
        }
        String message = "Unable to remove temp directory " + tempFile.getParentFile();
        _log.error((Object)message);
        responseJSONObject.put("error", message);
        success = FileUtils.deleteQuietly((File)tempFile);
        if (success) {
            return;
        }
        message = "Unable to remove temp file " + tempFile;
        _log.error((Object)message);
        responseJSONObject.put("error", message);
    }

    @Override
    public void executeDelete(HttpServletRequest httpServletRequest, JSONObject responseJSONObject, Queue<String> arguments) throws Exception {
        String context = arguments.poll();
        DeployManagerUtil.undeploy((String)context);
    }

    @Override
    public void executeRead(HttpServletRequest httpServletRequest, JSONObject responseJSONObject, Queue<String> arguments) {
        String context = arguments.poll();
        PluginPackage pluginPackage = DeployManagerUtil.getInstalledPluginPackage((String)context);
        boolean installed = true;
        if (pluginPackage == null) {
            installed = false;
        }
        JSONObject pluginPackageJSONObject = JSONUtil.put((String)"installed", (Object)installed);
        boolean started = true;
        if (pluginPackage == null) {
            started = false;
        }
        pluginPackageJSONObject.put("started", started);
        List types = new ArrayList();
        if (pluginPackage != null) {
            types = pluginPackage.getTypes();
        }
        JSONArray typesJSONArray = JSONFactoryUtil.createJSONArray();
        for (String type : types) {
            typesJSONArray.put(type);
        }
        pluginPackageJSONObject.put("types", typesJSONArray);
        responseJSONObject.put("output", pluginPackageJSONObject);
    }

    @Override
    public void executeUpdate(HttpServletRequest httpServletRequest, JSONObject responseJSONObject, Queue<String> arguments) throws Exception {
        String context = arguments.poll();
        List<File> installedDirs = this.getInstalledDirectories(context);
        for (File file : installedDirs) {
            if (file.exists()) continue;
            responseJSONObject.put("error", "Context directory " + file.getAbsolutePath() + " does not exist").put("status", 1);
            return;
        }
        File tempFile = this.getTempFile(httpServletRequest, responseJSONObject);
        if (tempFile == null) {
            return;
        }
        for (File deployDirectory : installedDirs) {
            FileUtil.unzip((File)tempFile, (File)deployDirectory);
        }
        File file = new File(installedDirs.get(0), "META-INF/liferay-partialapp-delete.props");
        if (!file.exists()) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            for (File deployDirectory : installedDirs) {
                boolean success;
                File staleFile = new File(deployDirectory, line.trim());
                if (!staleFile.exists() || (success = FileUtils.deleteQuietly((File)staleFile))) continue;
                String message = "Unable to delete file " + staleFile.getAbsolutePath();
                _log.error((Object)message);
                responseJSONObject.put("error", message);
            }
        }
        FileUtils.deleteQuietly((File)file);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Successfully updated " + context));
        }
    }

    protected FileItem getFileItem(HttpServletRequest httpServletRequest) throws FileUploadException {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        List fileItems = servletFileUpload.parseRequest(httpServletRequest);
        for (FileItem fileItem : fileItems) {
            if (fileItem.isFormField()) continue;
            return fileItem;
        }
        return null;
    }

    protected File getFileItemTempFile(HttpServletRequest httpServletRequest) throws Exception {
        FileItem fileItem = this.getFileItem(httpServletRequest);
        if (fileItem == null) {
            return null;
        }
        File tempDir = new File(SystemProperties.get((String)"java.io.tmpdir"), PortalUUIDUtil.generate());
        if (!tempDir.mkdirs()) {
            return null;
        }
        File tempFile = new File(tempDir, fileItem.getName());
        fileItem.write(tempFile);
        return tempFile;
    }

    protected List<File> getInstalledDirectories(final String context) throws Exception {
        File tempDir;
        Object[] tempContextDirs;
        ArrayList<File> installedDirs = new ArrayList<File>();
        String installedDirName = DeployManagerUtil.getInstalledDir();
        File installedDir = new File(installedDirName, context);
        if (installedDir.exists()) {
            installedDirs.add(installedDir);
        } else {
            File deployWarDir = new File(installedDirName, context + ".war");
            installedDirs.add(deployWarDir);
        }
        if (ServerDetector.isTomcat() && ArrayUtil.isNotEmpty((Object[])(tempContextDirs = (tempDir = new File(SystemProperties.get((String)"java.io.tmpdir"))).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("-" + context);
            }
        })))) {
            Arrays.sort(tempContextDirs, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    String fileName1 = file1.getName();
                    String fileName2 = file2.getName();
                    return fileName1.compareTo(fileName2);
                }
            });
            Object tempContextDir = tempContextDirs[tempContextDirs.length - 1];
            installedDirs.add((File)tempContextDir);
        }
        return installedDirs;
    }

    protected File getTempFile(HttpServletRequest httpServletRequest, JSONObject responseJSONObject) {
        File tempFile = null;
        String message = "Unable to create temp file for uploaded plugin";
        try {
            tempFile = this.getFileItemTempFile(httpServletRequest);
        }
        catch (Exception exception) {
            _log.error((Object)message, (Throwable)exception);
        }
        if (tempFile != null) {
            return tempFile;
        }
        responseJSONObject.put("error", message).put("status", 1);
        return null;
    }
}

