/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.criteria.contributor;

import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.Groups_OrgsTable;
import com.liferay.portal.kernel.model.Groups_RolesTable;
import com.liferay.portal.kernel.model.Groups_UserGroupsTable;
import com.liferay.portal.kernel.model.Users_GroupsTable;
import com.liferay.portal.kernel.model.Users_OrgsTable;
import com.liferay.portal.kernel.model.Users_UserGroupsTable;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.criteria.mapper.SegmentsCriteriaJSONObjectMapper;
import com.liferay.segments.field.Field;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import jakarta.portlet.PortletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"segments.criteria.contributor.key=user", "segments.criteria.contributor.model.class.name=com.liferay.portal.kernel.model.User", "segments.criteria.contributor.priority:Integer=10"}, service={SegmentsCriteriaContributor.class})
public class UserSegmentsCriteriaContributor
implements SegmentsCriteriaContributor {
    public static final String KEY = "user";
    private static final Pattern _dateModifiedPattern = Pattern.compile("dateModified eq (?<date>\\d{4}-\\d{2}-\\d{2})T.*Z");
    private static final Pattern _roleIdsPattern = Pattern.compile("roleIds eq '\\d+'");
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=User)")
    private volatile EntityModel _entityModel;
    @Reference
    private EntityModelFieldMapper _entityModelFieldMapper;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference(target="(segments.criteria.mapper.key=odata)")
    private SegmentsCriteriaJSONObjectMapper _segmentsCriteriaJSONObjectMapper;

    public void contribute(Criteria criteria, String filterString, Criteria.Conjunction conjunction) {
        criteria.addCriterion(this.getKey(), this.getType(), filterString, conjunction);
        String newFilterString = filterString;
        Matcher matcher = _roleIdsPattern.matcher(filterString);
        while (matcher.find()) {
            long roleId = this._getRoleId(matcher.group());
            newFilterString = StringUtil.replace((String)newFilterString, (String)matcher.group(), (String)String.join((CharSequence)"", "(", matcher.group(), this._getGroupIdsFilterString(roleId), this._getOrganizationIdsFilterString(roleId), this._getUserGroupIdsFilterString(roleId), ")"));
        }
        matcher = _dateModifiedPattern.matcher(filterString);
        while (matcher.find()) {
            String date = matcher.group("date");
            newFilterString = StringUtil.replace((String)newFilterString, (String)matcher.group(), (String)StringBundler.concat((String[])new String[]{"dateModified ge ", date, "T00:00:00.000Z and ", "dateModified le ", date, "T23:59:59.999Z"}));
        }
        criteria.addFilter(this.getType(), newFilterString, conjunction);
    }

    public JSONObject getCriteriaJSONObject(Criteria criteria) throws Exception {
        return this._segmentsCriteriaJSONObjectMapper.toJSONObject(criteria, (SegmentsCriteriaContributor)this);
    }

    public EntityModel getEntityModel() {
        return this._entityModel;
    }

    public String getEntityName() {
        return "User";
    }

    public List<Field> getFields(PortletRequest portletRequest) {
        return this._entityModelFieldMapper.getFields(this._entityModel, portletRequest);
    }

    public String getKey() {
        return KEY;
    }

    public Criteria.Type getType() {
        return Criteria.Type.MODEL;
    }

    private String _getGroupIdsFilterString(long roleId) {
        List groupIds = (List)this._roleLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{Users_GroupsTable.INSTANCE.groupId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)Users_GroupsTable.INSTANCE, Users_GroupsTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)roleId)));
        if (groupIds.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"", " ", Criteria.Conjunction.OR.getValue(), " ", this._toFilterString("groupIds", groupIds));
    }

    private String _getOrganizationIdsFilterString(long roleId) {
        List organizationIds = (List)this._roleLocalService.dslQuery(DSLQueryFactoryUtil.select((Expression[])new Expression[]{Users_OrgsTable.INSTANCE.organizationId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).innerJoinON((Table)Users_OrgsTable.INSTANCE, Users_OrgsTable.INSTANCE.organizationId.eq((Expression)GroupTable.INSTANCE.classPK)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)roleId)).union((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{Users_OrgsTable.INSTANCE.organizationId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)Groups_OrgsTable.INSTANCE, Groups_OrgsTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).innerJoinON((Table)Users_OrgsTable.INSTANCE, Users_OrgsTable.INSTANCE.organizationId.eq((Expression)Groups_OrgsTable.INSTANCE.organizationId)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)roleId))));
        if (organizationIds.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"", " ", Criteria.Conjunction.OR.getValue(), " ", this._toFilterString("organizationIds", organizationIds));
    }

    private long _getRoleId(String criterionString) {
        int indexOf = criterionString.indexOf("'");
        int lastIndexOf = criterionString.lastIndexOf("'");
        if (indexOf == -1 || lastIndexOf == -1) {
            return -1L;
        }
        return GetterUtil.getLong((String)criterionString.substring(indexOf + 1, lastIndexOf));
    }

    private String _getUserGroupIdsFilterString(long roleId) {
        List userGroupIds = (List)this._roleLocalService.dslQuery(DSLQueryFactoryUtil.select((Expression[])new Expression[]{Users_UserGroupsTable.INSTANCE.userGroupId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)GroupTable.INSTANCE, GroupTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)GroupTable.INSTANCE.classPK)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)roleId)).union((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{Users_UserGroupsTable.INSTANCE.userGroupId}).from((Table)Groups_RolesTable.INSTANCE).innerJoinON((Table)Groups_UserGroupsTable.INSTANCE, Groups_UserGroupsTable.INSTANCE.groupId.eq((Expression)Groups_RolesTable.INSTANCE.groupId)).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, Users_UserGroupsTable.INSTANCE.userGroupId.eq((Expression)Groups_UserGroupsTable.INSTANCE.userGroupId)).where(Groups_RolesTable.INSTANCE.roleId.eq((Object)roleId))));
        if (userGroupIds.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"", " ", Criteria.Conjunction.OR.getValue(), " ", this._toFilterString("userGroupIds", userGroupIds));
    }

    private String _toFilterString(String fieldName, List<Long> ids) {
        ArrayList<String> conditions = new ArrayList<String>();
        for (long id : ids) {
            conditions.add(StringBundler.concat((Object[])new Object[]{fieldName, " eq '", id, "'"}));
        }
        return String.join((CharSequence)" or ", conditions);
    }
}

