/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.criteria.mapper;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.criteria.mapper.SegmentsCriteriaJSONObjectMapper;
import com.liferay.segments.exception.SegmentsEntryCriteriaException;
import com.liferay.segments.internal.odata.ExpressionVisitorImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"segments.criteria.mapper.key=odata"}, service={SegmentsCriteriaJSONObjectMapper.class})
public class SegmentsCriteriaJSONObjectMapperImpl
implements SegmentsCriteriaJSONObjectMapper {
    public static final String KEY = "odata";
    @Reference
    private FilterParserProvider _filterParserProvider;

    public JSONObject toJSONObject(Criteria criteria, SegmentsCriteriaContributor segmentsCriteriaContributor) throws Exception {
        Criteria.Criterion criterion = criteria.getCriterion(segmentsCriteriaContributor.getKey());
        return JSONUtil.put((String)"conjunctionName", (Object)this._getCriterionConjunction(criterion)).put("query", this._getQueryJSONObject(criterion, segmentsCriteriaContributor));
    }

    private String _getCriterionConjunction(Criteria.Criterion criterion) {
        if (criterion == null) {
            return "";
        }
        return criterion.getConjunction();
    }

    private JSONObject _getQueryJSONObject(Criteria.Criterion criterion, SegmentsCriteriaContributor segmentsCriteriaContributor) throws Exception {
        if (criterion == null) {
            return null;
        }
        String filterString = criterion.getFilterString();
        if (Validator.isNull((String)filterString)) {
            return null;
        }
        Expression expression = this._toExpression(segmentsCriteriaContributor.getEntityModel(), filterString);
        JSONObject jsonObject = (JSONObject)expression.accept((ExpressionVisitor)new ExpressionVisitorImpl(1, segmentsCriteriaContributor.getEntityModel()));
        if (Validator.isNull((String)jsonObject.getString("groupId"))) {
            jsonObject = JSONUtil.put((String)"conjunctionName", (Object)StringUtil.toLowerCase((String)String.valueOf(BinaryExpression.Operation.AND))).put("groupId", "group_0").put("items", JSONUtil.putAll((Object[])new Object[]{jsonObject}));
        }
        return jsonObject;
    }

    private Expression _toExpression(EntityModel entityModel, String filterString) throws Exception {
        try {
            FilterParser filterParser = this._filterParserProvider.provide(entityModel);
            return filterParser.parse(filterString);
        }
        catch (ExpressionVisitException expressionVisitException) {
            throw new SegmentsEntryCriteriaException((Throwable)expressionVisitException);
        }
    }
}

