/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.segments.model.impl;

import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalServiceUtil;

/**
 * The extended model base implementation for the SegmentsExperience service. Represents a row in the &quot;SegmentsExperience&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SegmentsExperienceImpl}.
 * </p>
 *
 * @author Eduardo Garcia
 * @see SegmentsExperienceImpl
 * @see SegmentsExperience
 * @generated
 */
public abstract class SegmentsExperienceBaseImpl
	extends SegmentsExperienceModelImpl implements SegmentsExperience {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a segments experience model instance should use the <code>SegmentsExperience</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SegmentsExperienceLocalServiceUtil.addSegmentsExperience(this);
		}
		else {
			SegmentsExperienceLocalServiceUtil.updateSegmentsExperience(this);
		}
	}

}