/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.content.targeting.upgrade.internal.v1_0_0.util;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.normalizer.Normalizer;
import com.liferay.segments.content.targeting.upgrade.internal.v1_0_0.util.RuleConverter;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"rule.converter.key=CustomFieldRule"}, service={RuleConverter.class})
public class CustomFieldRuleConverter
implements RuleConverter {
    private static final Log _log = LogFactoryUtil.getLog(CustomFieldRuleConverter.class);
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference(target="(segments.criteria.contributor.key=user)")
    private SegmentsCriteriaContributor _userSegmentsCriteriaContributor;

    @Override
    public void convert(long companyId, Criteria criteria, String typeSettings) {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)typeSettings);
            String attributeName = jsonObject.getString("attributeName");
            String value = jsonObject.getString("value");
            if (Validator.isNull((String)attributeName) || Validator.isNull((String)value)) {
                return;
            }
            ExpandoTable expandoTable = this._expandoTableLocalService.getDefaultTable(companyId, User.class.getName());
            ExpandoColumn expandoColumn = this._expandoColumnLocalService.getColumn(expandoTable.getTableId(), attributeName);
            if (expandoColumn == null) {
                return;
            }
            String fieldName = this._encodeName(expandoColumn);
            this._userSegmentsCriteriaContributor.contribute(criteria, StringBundler.concat((String[])new String[]{"(customField/", fieldName, " eq '", value, "')"}), Criteria.Conjunction.AND);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to convert custom field rule with type settings " + typeSettings), (Throwable)exception);
        }
    }

    private String _encodeName(ExpandoColumn expandoColumn) {
        return StringBundler.concat((Object[])new Object[]{"_", expandoColumn.getColumnId(), "_", Normalizer.normalizeIdentifier((String)expandoColumn.getName())});
    }
}

