/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.content.targeting.upgrade.internal.v1_0_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.segments.content.targeting.upgrade.internal.v1_0_0.util.RuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.v1_0_0.util.RuleConverterRegistry;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.CriteriaSerializer;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.Map;

public class UpgradeContentTargeting
extends UpgradeProcess {
    private static final String _CT_PACKAGE_NAME = "com.liferay.content.targeting";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeContentTargeting.class);
    private final RuleConverterRegistry _ruleConverterRegistry;
    private final SegmentsEntryLocalService _segmentsEntryLocalService;

    public UpgradeContentTargeting(RuleConverterRegistry ruleConverterRegistry, SegmentsEntryLocalService segmentsEntryLocalService) {
        this._ruleConverterRegistry = ruleConverterRegistry;
        this._segmentsEntryLocalService = segmentsEntryLocalService;
    }

    public void doUpgrade() throws Exception {
        if (!this.hasTable("CT_UserSegment")) {
            return;
        }
        this.upgradeContentTargetingUserSegments();
        this.deleteContentTargetingData();
    }

    protected void deleteContentTargetingData() throws Exception {
        this.runSQL("delete from ClassName_ where value like 'com.liferay.content.targeting%'");
        this.runSQL("delete from Release_ where servletContextName like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ResourceAction where name like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ResourcePermission where name like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ServiceComponent where buildNamespace like 'CT%'");
        this._dropTable("CT_AU_AnonymousUser");
        this._dropTable("CT_Analytics_AnalyticsEvent");
        this._dropTable("CT_Analytics_AnalyticsReferrer");
        this._dropTable("CT_AnonymousUserUserSegment");
        this._dropTable("CT_CCR_CampaignContent");
        this._dropTable("CT_CTA_CTAction");
        this._dropTable("CT_CTA_CTActionTotal");
        this._dropTable("CT_Campaign");
        this._dropTable("CT_Campaigns_UserSegments");
        this._dropTable("CT_ChannelInstance");
        this._dropTable("CT_ReportInstance");
        this._dropTable("CT_RuleInstance");
        this._dropTable("CT_ScorePoints_ScorePoint");
        this._dropTable("CT_Tactic");
        this._dropTable("CT_Tactics_UserSegments");
        this._dropTable("CT_TrackingActionInstance");
        this._dropTable("CT_USCR_UserSegmentContent");
        this._dropTable("CT_UserSegment");
        this._dropTable("CT_Visited_ContentVisited");
        this._dropTable("CT_Visited_PageVisited");
    }

    protected String getCriteria(long userSegmentId) throws Exception {
        Criteria criteria = new Criteria();
        try (PreparedStatement ps = this.connection.prepareStatement("select companyId, ruleKey, typeSettings from CT_RuleInstance where userSegmentId = ?");){
            ps.setLong(1, userSegmentId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String ruleKey = rs.getString("ruleKey");
                    RuleConverter ruleConverter = this._ruleConverterRegistry.getRuleConverter(ruleKey);
                    if (ruleConverter == null) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Unable to perform automated update of rule " + ruleKey));
                        continue;
                    }
                    long companyId = rs.getLong("companyId");
                    String typeSettings = rs.getString("typeSettings");
                    ruleConverter.convert(companyId, criteria, typeSettings);
                }
            }
        }
        return CriteriaSerializer.serialize((Criteria)criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgradeContentTargetingUserSegments() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select * from CT_UserSegment");
             ResultSet rs = ps1.executeQuery();){
            ServiceContext serviceContext = new ServiceContext();
            while (rs.next()) {
                long userSegmentId = rs.getLong("userSegmentId");
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Upgrading Content Targeting User Segment " + userSegmentId));
                }
                String name = rs.getString("name");
                Map nameMap = LocalizationUtil.getLocalizationMap((String)name);
                Map descriptionMap = LocalizationUtil.getLocalizationMap((String)rs.getString("description"));
                serviceContext.setScopeGroupId(rs.getLong("groupId"));
                serviceContext.setUserId(PortalUtil.getValidUserId((long)rs.getLong("companyId"), (long)rs.getLong("userId")));
                Locale defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)name));
                Locale currentDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
                try {
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)defaultLocale);
                    this._segmentsEntryLocalService.addSegmentsEntry("ct_" + userSegmentId, nameMap, descriptionMap, true, this.getCriteria(userSegmentId), "DEFAULT", User.class.getName(), serviceContext);
                }
                finally {
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)currentDefaultLocale);
                }
            }
        }
    }

    private void _dropTable(String tableName) throws Exception {
        if (this.hasTable(tableName)) {
            this.runSQL("drop table " + tableName);
        }
    }
}

