/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.util;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.asah.connector.internal.client.model.DXPVariantMetric;
import com.liferay.segments.asah.connector.internal.client.model.Experiment;
import com.liferay.segments.asah.connector.internal.client.model.Metric;
import com.liferay.segments.asah.connector.internal.util.comparator.MetricProcessedDateComparator;
import com.liferay.segments.constants.SegmentsExperimentConstants;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.model.SegmentsExperimentRel;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;

public class SegmentsExperimentUtil {
    public static final String ANALYTICS_CLOUD_TRIAL_URL = "https://www.liferay.com/products/analytics-cloud/get-started";

    public static JSONObject toGoalJSONObject(Locale locale, UnicodeProperties typeSettingsUnicodeProperties) {
        String goal = typeSettingsUnicodeProperties.getProperty("goal");
        return JSONUtil.put((String)"label", (Object)LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, SegmentsExperimentUtil.class), (String)goal)).put("target", typeSettingsUnicodeProperties.getProperty("goalTarget")).put("value", goal);
    }

    public static JSONObject toSegmentsExperimentJSONObject(AnalyticsConfiguration analyticsConfiguration, Group group, Locale locale, SegmentsExperiment segmentsExperiment) throws PortalException {
        if (segmentsExperiment == null) {
            return null;
        }
        return JSONUtil.put((String)"confidenceLevel", (Object)segmentsExperiment.getConfidenceLevel()).put("description", segmentsExperiment.getDescription()).put("detailsURL", SegmentsExperimentUtil._getViewSegmentsExperimentDetailsURL(analyticsConfiguration, group, segmentsExperiment)).put("editable", SegmentsExperimentUtil._isEditable(segmentsExperiment)).put("goal", SegmentsExperimentUtil.toGoalJSONObject(locale, segmentsExperiment.getTypeSettingsProperties())).put("name", segmentsExperiment.getName()).put("segmentsEntryName", segmentsExperiment.getSegmentsEntryName(locale)).put("segmentsExperienceId", String.valueOf(segmentsExperiment.getSegmentsExperienceId())).put("segmentsExperimentId", String.valueOf(segmentsExperiment.getSegmentsExperimentId())).put("status", SegmentsExperimentUtil.toStatusJSONObject(locale, segmentsExperiment.getStatus())).put("type", SegmentsExperimentUtil.toTypeJSONObject(locale, segmentsExperiment.getType()));
    }

    public static JSONObject toSegmentsExperimentRelJSONObject(Experiment experiment, Locale locale, SegmentsExperimentRel segmentsExperimentRel) throws PortalException {
        if (segmentsExperimentRel == null) {
            return null;
        }
        String segmentsExperimentVariantImprovement = "-";
        if (experiment != null && !segmentsExperimentRel.isControl() && ListUtil.isNotEmpty(experiment.getMetrics())) {
            Metric metric = Collections.max(experiment.getMetrics(), MetricProcessedDateComparator.getInstance(true));
            for (DXPVariantMetric dxpVariantMetric : metric.getDXPVariantMetrics()) {
                if (dxpVariantMetric.isControl().booleanValue()) continue;
                segmentsExperimentVariantImprovement = String.valueOf(dxpVariantMetric.getImprovement());
            }
        }
        return JSONUtil.put((String)"control", (Object)segmentsExperimentRel.isControl()).put("name", segmentsExperimentRel.getName(locale)).put("segmentsExperienceId", String.valueOf(segmentsExperimentRel.getSegmentsExperienceId())).put("segmentsExperimentId", String.valueOf(segmentsExperimentRel.getSegmentsExperimentId())).put("segmentsExperimentRelId", String.valueOf(segmentsExperimentRel.getSegmentsExperimentRelId())).put("segmentsExperimentVariantImprovement", segmentsExperimentVariantImprovement).put("split", segmentsExperimentRel.getSplit());
    }

    public static JSONObject toSegmentsExperimentRelJSONObject(Locale locale, SegmentsExperimentRel segmentsExperimentRel) throws PortalException {
        if (segmentsExperimentRel == null) {
            return null;
        }
        return JSONUtil.put((String)"control", (Object)segmentsExperimentRel.isControl()).put("name", segmentsExperimentRel.getName(locale)).put("segmentsExperienceId", String.valueOf(segmentsExperimentRel.getSegmentsExperienceId())).put("segmentsExperimentId", String.valueOf(segmentsExperimentRel.getSegmentsExperimentId())).put("segmentsExperimentRelId", String.valueOf(segmentsExperimentRel.getSegmentsExperimentRelId())).put("split", segmentsExperimentRel.getSplit());
    }

    public static JSONObject toStatusJSONObject(Locale locale, int status) {
        SegmentsExperimentConstants.Status segmentsExperimentConstantsStatus = SegmentsExperimentConstants.Status.parse((int)status);
        if (segmentsExperimentConstantsStatus == null) {
            return null;
        }
        return JSONUtil.put((String)"label", (Object)LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, SegmentsExperimentUtil.class), (String)segmentsExperimentConstantsStatus.getLabel())).put("value", segmentsExperimentConstantsStatus.getValue());
    }

    public static JSONObject toTypeJSONObject(Locale locale, String type) {
        SegmentsExperimentConstants.Type segmentsExperimentConstantsType = SegmentsExperimentConstants.Type.parse((String)type);
        if (segmentsExperimentConstantsType == null) {
            return null;
        }
        return JSONUtil.put((String)"label", (Object)LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, SegmentsExperimentUtil.class), (String)segmentsExperimentConstantsType.getLabel())).put("value", segmentsExperimentConstantsType.name());
    }

    private static String _getViewSegmentsExperimentDetailsURL(AnalyticsConfiguration analyticsConfiguration, Group group, SegmentsExperiment segmentsExperiment) {
        if (segmentsExperiment == null) {
            return "";
        }
        String liferayAnalyticsURL = analyticsConfiguration.liferayAnalyticsURL();
        if (Validator.isNull((String)liferayAnalyticsURL)) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append(liferayAnalyticsURL);
        String analyticsChannelId = GetterUtil.getString((String)group.getTypeSettingsProperty("analyticsChannelId"));
        if (Validator.isNotNull((String)analyticsChannelId)) {
            sb.append("/");
            sb.append(analyticsChannelId);
        }
        sb.append("/tests/overview/");
        sb.append(segmentsExperiment.getSegmentsExperimentKey());
        return sb.toString();
    }

    private static boolean _isEditable(SegmentsExperiment segmentsExperiment) {
        SegmentsExperimentConstants.Status status = SegmentsExperimentConstants.Status.valueOf((int)segmentsExperiment.getStatus());
        return status.isEditable();
    }

    private SegmentsExperimentUtil() {
    }
}

