/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.scheduler;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.segments.asah.connector.internal.cache.AsahSegmentsEntryCache;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClient;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClientImpl;
import com.liferay.segments.asah.connector.internal.client.model.Individual;
import com.liferay.segments.asah.connector.internal.client.model.IndividualSegment;
import com.liferay.segments.asah.connector.internal.client.model.Results;
import com.liferay.segments.asah.connector.internal.client.util.OrderByField;
import com.liferay.segments.asah.connector.internal.configuration.SegmentsAsahConfiguration;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.asah.connector.internal.configuration.SegmentsAsahConfiguration"}, service={SchedulerJobConfiguration.class})
public class CheckIndividualSegmentsSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final int _DELTA = 100;
    private static final Log _log = LogFactoryUtil.getLog(CheckIndividualSegmentsSchedulerJobConfiguration.class);
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    private volatile AsahFaroBackendClient _asahFaroBackendClient;
    @Reference
    private AsahSegmentsEntryCache _asahSegmentsEntryCache;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Http _http;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;
    private volatile TriggerConfiguration _triggerConfiguration;
    @Reference
    private UserLocalService _userLocalService;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return this::_checkIndividualSegments;
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._asahFaroBackendClient = new AsahFaroBackendClientImpl(this._analyticsSettingsManager, this._http);
        this.modified(properties);
    }

    @Deactivate
    protected void deactivate() {
        this._asahFaroBackendClient = null;
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        SegmentsAsahConfiguration segmentsAsahConfiguration = (SegmentsAsahConfiguration)ConfigurableUtil.createConfigurable(SegmentsAsahConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((int)segmentsAsahConfiguration.checkInterval(), (TimeUnit)TimeUnit.MINUTE);
    }

    private void _addSegmentsEntry(long companyId, IndividualSegment individualSegment) {
        try {
            ServiceContext serviceContext = this._getServiceContext(companyId);
            SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(serviceContext.getScopeGroupId(), individualSegment.getId());
            Map<Locale, String> nameMap = Collections.singletonMap(this._portal.getSiteDefaultLocale(serviceContext.getScopeGroupId()), individualSegment.getName());
            if (segmentsEntry == null) {
                this._segmentsEntryLocalService.addSegmentsEntry(individualSegment.getId(), nameMap, Collections.emptyMap(), true, null, "ASAH_FARO_BACKEND", serviceContext);
                return;
            }
            this._segmentsEntryLocalService.updateSegmentsEntry(segmentsEntry.getSegmentsEntryId(), individualSegment.getId(), nameMap, null, true, null, serviceContext);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to process individual segment " + individualSegment.getId()), (Throwable)portalException);
        }
    }

    private void _addSegmentsEntryRels(SegmentsEntry segmentsEntry, Set<Long> userIds) {
        try {
            this._segmentsEntryLocalService.addSegmentsEntryClassPKs(segmentsEntry.getSegmentsEntryId(), ArrayUtil.toLongArray(userIds), this._getServiceContext(segmentsEntry.getCompanyId()));
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to process individuals " + String.valueOf(userIds)), (Throwable)portalException);
        }
    }

    private void _checkIndividualSegmentMemberships(SegmentsEntry segmentsEntry) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(segmentsEntry.getCompanyId());
        this._segmentsEntryRelLocalService.deleteSegmentsEntryRels(segmentsEntry.getSegmentsEntryId());
        try {
            Results<Individual> individualResults = this._asahFaroBackendClient.getIndividualResults(segmentsEntry.getCompanyId(), segmentsEntry.getSegmentsEntryKey(), 1, 100, Collections.singletonList(OrderByField.desc("dateModified")));
            int totalElements = individualResults.getTotal();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(totalElements + " individuals found for individual segment " + segmentsEntry.getSegmentsEntryKey()));
            }
            if (totalElements == 0) {
                return;
            }
            HashSet<Long> userIds = new HashSet<Long>();
            int totalPages = (int)Math.ceil((double)totalElements / 100.0);
            int curPage = 1;
            while (true) {
                List<Individual> individuals = individualResults.getItems();
                individuals.forEach(individual -> {
                    Long userId = this._getUserId(segmentsEntry.getCompanyId(), analyticsConfiguration.liferayAnalyticsDataSourceId(), (Individual)individual);
                    if (userId != null) {
                        userIds.add(userId);
                    } else {
                        String individualPK;
                        List<String> individualSegmentIds = individual.getIndividualSegmentIds();
                        if (ListUtil.isNotEmpty(individualSegmentIds) && (individualPK = this._getIndividualPK(analyticsConfiguration.liferayAnalyticsDataSourceId(), (Individual)individual)) != null) {
                            try {
                                this._putSegmentsEntryIdsCache(segmentsEntry.getCompanyId(), individualPK, individualSegmentIds);
                            }
                            catch (PortalException portalException) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("Unable to cache ");
                                sb.append("segments entry IDs ");
                                sb.append("for user ID ");
                                sb.append(userId);
                                _log.error((Object)sb.toString(), (Throwable)portalException);
                            }
                        }
                    }
                });
                if (++curPage > totalPages) break;
                individualResults = this._asahFaroBackendClient.getIndividualResults(segmentsEntry.getCompanyId(), segmentsEntry.getSegmentsEntryKey(), curPage, 100, Collections.singletonList(OrderByField.desc("dateModified")));
            }
            if (!userIds.isEmpty()) {
                this._addSegmentsEntryRels(segmentsEntry, userIds);
            }
        }
        catch (RuntimeException runtimeException) {
            _log.error((Object)("Unable to retrieve individuals for individual segment " + segmentsEntry.getSegmentsEntryKey()), (Throwable)runtimeException);
        }
    }

    private void _checkIndividualSegments() throws Exception {
        this._initialCheckIndividualSegments();
        this._checkIndividualSegmentsMemberships();
    }

    private void _checkIndividualSegments(long companyId) {
        Results<IndividualSegment> individualSegmentResults = new Results();
        try {
            individualSegmentResults = this._asahFaroBackendClient.getIndividualSegmentResults(companyId, 1, 100, Collections.singletonList(OrderByField.desc("dateModified")));
            this._deleteSegmentsEntries(individualSegmentResults);
        }
        catch (RuntimeException runtimeException) {
            _log.error((Object)"Unable to retrieve individual segments", (Throwable)runtimeException);
            return;
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to delete segments", (Throwable)portalException);
            return;
        }
        int totalElements = individualSegmentResults.getTotal();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(totalElements + " active individual segments found"));
        }
        if (totalElements == 0) {
            return;
        }
        List<IndividualSegment> individualSegments = individualSegmentResults.getItems();
        individualSegments.forEach(individualSegment -> this._addSegmentsEntry(companyId, (IndividualSegment)individualSegment));
    }

    private void _checkIndividualSegmentsMemberships() throws Exception {
        List segmentsEntries = this._segmentsEntryLocalService.getSegmentsEntriesBySource("ASAH_FARO_BACKEND", -1, -1, null);
        for (SegmentsEntry segmentsEntry : segmentsEntries) {
            this._checkIndividualSegmentMemberships(segmentsEntry);
        }
    }

    private void _deleteSegmentsEntries(Results<IndividualSegment> individualSegmentResults) throws PortalException {
        List segmentsEntries = this._segmentsEntryLocalService.getSegmentsEntriesBySource("ASAH_FARO_BACKEND", 0, 100, null);
        if (individualSegmentResults.getTotal() > 0) {
            segmentsEntries = ListUtil.filter((List)segmentsEntries, segmentsEntry -> !ListUtil.exists(individualSegmentResults.getItems(), individualSegment -> StringUtil.equals((String)individualSegment.getId(), (String)segmentsEntry.getSegmentsEntryKey())));
        }
        for (SegmentsEntry segmentsEntry2 : segmentsEntries) {
            this._segmentsEntryLocalService.deleteSegmentsEntry(segmentsEntry2);
        }
    }

    private String _getIndividualPK(String dataSourceId, Individual individual) {
        for (Individual.DataSourceIndividualPK dataSourceIndividualPK : individual.getDataSourceIndividualPKs()) {
            Iterator<String> iterator;
            if (!Objects.equals(dataSourceId, dataSourceIndividualPK.getDataSourceId()) || !(iterator = dataSourceIndividualPK.getIndividualPKs().iterator()).hasNext()) continue;
            String individualPK = iterator.next();
            return individualPK;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find a user corresponding to individual " + individual.getId()));
        }
        return null;
    }

    private ServiceContext _getServiceContext(long companyId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        Company company = this._companyLocalService.getCompany(companyId);
        serviceContext.setScopeGroupId(company.getGroupId());
        User user = company.getGuestUser();
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    private Long _getUserId(long companyId, String dataSourceId, Individual individual) {
        for (Individual.DataSourceIndividualPK dataSourceIndividualPK : individual.getDataSourceIndividualPKs()) {
            if (!Objects.equals(dataSourceId, dataSourceIndividualPK.getDataSourceId())) continue;
            for (String individualUuid : dataSourceIndividualPK.getIndividualPKs()) {
                User user = this._userLocalService.fetchUserByUuidAndCompanyId(individualUuid, companyId);
                if (user == null) continue;
                return user.getUserId();
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to find a user corresponding to individual " + individual.getId()));
        }
        return null;
    }

    private void _initialCheckIndividualSegments() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> {
            if (this._analyticsSettingsManager.isAnalyticsEnabled(companyId.longValue())) {
                this._checkIndividualSegments((long)companyId);
            }
        });
    }

    private void _putSegmentsEntryIdsCache(long companyId, String userId, List<String> individualSegmentIds) throws PortalException {
        ServiceContext serviceContext = this._getServiceContext(companyId);
        List segmentsEntryIds = TransformUtil.transform(individualSegmentIds, individualSegmentId -> {
            SegmentsEntry curSegmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(serviceContext.getScopeGroupId(), individualSegmentId);
            if (curSegmentsEntry != null) {
                return curSegmentsEntry.getSegmentsEntryId();
            }
            return null;
        });
        this._asahSegmentsEntryCache.putSegmentsEntryIds(userId, ArrayUtil.toLongArray((Collection)segmentsEntryIds));
    }
}

