/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.model.listener;

import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClientImpl;
import com.liferay.segments.asah.connector.internal.processor.AsahSegmentsExperimentProcessor;
import com.liferay.segments.asah.connector.internal.util.AsahUtil;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.model.SegmentsExperimentRel;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.service.SegmentsExperimentLocalService;
import com.liferay.segments.service.SegmentsExperimentRelLocalService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class SegmentsExperimentRelModelListener
extends BaseModelListener<SegmentsExperimentRel> {
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    private AsahSegmentsExperimentProcessor _asahSegmentsExperimentProcessor;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperimentLocalService _segmentsExperimentLocalService;
    @Reference
    private SegmentsExperimentRelLocalService _segmentsExperimentRelLocalService;

    public void onAfterCreate(SegmentsExperimentRel segmentsExperimentRel) throws ModelListenerException {
        try {
            if (segmentsExperimentRel.isControl()) {
                return;
            }
            this._processUpdateSegmentsExperimentRel(segmentsExperimentRel);
        }
        catch (Exception exception) {
            throw new ModelListenerException("Unable to create segments experiment rel " + segmentsExperimentRel.getSegmentsExperimentRelId(), (Throwable)exception);
        }
    }

    public void onAfterRemove(SegmentsExperimentRel segmentsExperimentRel) throws ModelListenerException {
        if (segmentsExperimentRel == null) {
            return;
        }
        try {
            SegmentsExperiment segmentsExperiment = this._segmentsExperimentLocalService.fetchSegmentsExperiment(segmentsExperimentRel.getSegmentsExperimentId());
            if (segmentsExperiment == null) {
                return;
            }
            this._processUpdateSegmentsExperimentRel(segmentsExperimentRel);
        }
        catch (Exception exception) {
            throw new ModelListenerException("Unable to remove segments experiment rel " + segmentsExperimentRel.getSegmentsExperimentRelId(), (Throwable)exception);
        }
    }

    @Activate
    protected void activate() {
        this._asahSegmentsExperimentProcessor = new AsahSegmentsExperimentProcessor(this._analyticsSettingsManager, new AsahFaroBackendClientImpl(this._analyticsSettingsManager, this._http), this._companyLocalService, this._groupLocalService, this._layoutLocalService, this._portal, this._segmentsEntryLocalService, this._segmentsExperienceLocalService);
    }

    @Deactivate
    protected void deactivate() {
        this._asahSegmentsExperimentProcessor = null;
    }

    private void _processUpdateSegmentsExperimentRel(SegmentsExperimentRel segmentsExperimentRel) throws Exception {
        if (AsahUtil.isSkipAsahEvent(this._analyticsSettingsManager, segmentsExperimentRel.getCompanyId(), segmentsExperimentRel.getGroupId())) {
            return;
        }
        this._asahSegmentsExperimentProcessor.processUpdateSegmentsExperimentRel(segmentsExperimentRel.getCompanyId(), segmentsExperimentRel.getSegmentsExperimentKey(), this._segmentsExperimentRelLocalService.getSegmentsExperimentRels(segmentsExperimentRel.getSegmentsExperimentId()));
    }
}

