/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.messaging;

import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.asah.connector.internal.cache.AsahInterestTermCache;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClient;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClientImpl;
import com.liferay.segments.asah.connector.internal.client.model.Results;
import com.liferay.segments.asah.connector.internal.client.model.Topic;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/interest_terms"}, service={MessageListener.class})
public class InterestTermsMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(InterestTermsMessageListener.class);
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    private final DCLSingleton<AsahFaroBackendClient> _asahFaroBackendClientDCLSingleton = new DCLSingleton();
    @Reference
    private AsahInterestTermCache _asahInterestTermCache;
    @Reference
    private Http _http;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;

    protected void doReceive(Message message) throws Exception {
        String userId = message.getString("userId");
        if (Validator.isNull((String)userId)) {
            return;
        }
        this._checkInterestTerms(message.getLong("companyId"), userId);
    }

    private void _checkInterestTerms(long companyId, String userId) throws Exception {
        if (this._asahInterestTermCache.getInterestTerms(userId) != null || !this._analyticsSettingsManager.isAnalyticsEnabled(companyId)) {
            return;
        }
        AsahFaroBackendClient asahFaroBackendClient = (AsahFaroBackendClient)this._asahFaroBackendClientDCLSingleton.getSingleton(() -> new AsahFaroBackendClientImpl(this._analyticsSettingsManager, this._http));
        Results<Topic> interestTermsResults = asahFaroBackendClient.getInterestTermsResults(companyId, userId);
        if (interestTermsResults == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get interest terms for user ID " + userId));
            }
            this._asahInterestTermCache.putInterestTerms(userId, new String[0]);
            return;
        }
        List<Topic> topics = interestTermsResults.getItems();
        if (ListUtil.isEmpty(topics)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No interest terms received for user ID " + userId));
            }
            this._asahInterestTermCache.putInterestTerms(userId, new String[0]);
            return;
        }
        ArrayList<String> termsList = new ArrayList<String>();
        for (Topic topic : topics) {
            for (Topic.TopicTerm topicTerm : topic.getTerms()) {
                termsList.add(topicTerm.getKeyword());
            }
        }
        Object[] terms = termsList.toArray(new String[0]);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Interest terms \"", StringUtil.merge((Object[])terms), "\" received for user ID ", userId}));
        }
        this._asahInterestTermCache.putInterestTerms(userId, (String[])terms);
    }
}

