/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.context.contributor;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.segments.context.Context;
import com.liferay.segments.context.contributor.RequestContextContributor;
import java.io.Serializable;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(property={"request.context.contributor.key=segmentsAnonymousUserId", "request.context.contributor.type=id"}, service={RequestContextContributor.class})
public class SegmentsAsahRequestContextContributor
implements RequestContextContributor {
    public static final String KEY_SEGMENTS_ANONYMOUS_USER_ID = "segmentsAnonymousUserId";
    private static final String _AC_CLIENT_USER_ID_COOKIE_NAME = "ac_client_user_id";

    public void contribute(Context context, HttpServletRequest httpServletRequest) {
        String segmentsAnonymousUserId = this._getSegmentsAnonymousUserId(httpServletRequest);
        httpServletRequest.setAttribute("SEGMENTS_ANONYMOUS_USER_ID", (Object)segmentsAnonymousUserId);
        context.put(KEY_SEGMENTS_ANONYMOUS_USER_ID, (Serializable)((Object)segmentsAnonymousUserId));
    }

    private String _getSegmentsAnonymousUserId(HttpServletRequest httpServletRequest) {
        Object[] cookies = httpServletRequest.getCookies();
        if (ArrayUtil.isEmpty((Object[])cookies)) {
            return "";
        }
        for (Object cookie : cookies) {
            if (!Objects.equals(cookie.getName(), _AC_CLIENT_USER_ID_COOKIE_NAME)) continue;
            return cookie.getValue();
        }
        return "";
    }
}

