/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.cache;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.segments.asah.connector.internal.configuration.provider.SegmentsAsahConfigurationProvider;
import java.io.Serializable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AsahSegmentsEntryCache.class})
public class AsahSegmentsEntryCache {
    private static final String _CACHE_PREFIX = "segments-";
    private static final Log _log = LogFactoryUtil.getLog(AsahSegmentsEntryCache.class);
    @Reference
    private MultiVMPool _multiVMPool;
    private PortalCache<String, long[]> _portalCache;
    @Reference
    private SegmentsAsahConfigurationProvider _segmentsAsahConfigurationProvider;

    public long[] getSegmentsEntryIds(String userId) {
        return (long[])this._portalCache.get((Serializable)((Object)this._generateCacheKey(userId)));
    }

    public void putSegmentsEntryIds(String userId, long[] segmentsEntryIds) {
        int anonymousTimeToLiveInSeconds = 0;
        try {
            anonymousTimeToLiveInSeconds = this._segmentsAsahConfigurationProvider.getAnonymousUserSegmentsCacheExpirationTime(CompanyThreadLocal.getCompanyId());
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
        }
        this._portalCache.put((Serializable)((Object)this._generateCacheKey(userId)), (Object)segmentsEntryIds, anonymousTimeToLiveInSeconds);
    }

    @Activate
    protected void activate() {
        this._portalCache = this._multiVMPool.getPortalCache(AsahSegmentsEntryCache.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        this._multiVMPool.removePortalCache(AsahSegmentsEntryCache.class.getName());
    }

    private String _generateCacheKey(String userId) {
        return _CACHE_PREFIX + userId;
    }
}

