/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.archetype.source.ArchetypeDataSink;
import org.apache.maven.archetype.source.ArchetypeDataSinkException;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogArchetypeDataSink
extends AbstractLogEnabled
implements ArchetypeDataSink {
    private ArchetypeCatalogXpp3Writer catalogWriter = new ArchetypeCatalogXpp3Writer();

    @Override
    public void putArchetypes(List<Archetype> archetypes, Writer writer) throws ArchetypeDataSinkException {
        ArchetypeCatalog catalog = new ArchetypeCatalog();
        for (Archetype archetype : archetypes) {
            catalog.addArchetype(archetype);
        }
        try {
            this.catalogWriter.write(writer, catalog);
        }
        catch (IOException e) {
            throw new ArchetypeDataSinkException("Error writing archetype catalog.", e);
        }
        finally {
            IOUtil.close(writer);
        }
    }

    @Override
    public void putArchetypes(ArchetypeDataSource source, Properties properties, Writer writer) throws ArchetypeDataSourceException, ArchetypeDataSinkException {
        List archetypes = source.getArchetypeCatalog(properties).getArchetypes();
        this.putArchetypes(archetypes, writer);
    }
}

