/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.old;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.old.ArchetypeDescriptorException;
import org.apache.maven.archetype.old.ArchetypeNotFoundException;
import org.apache.maven.archetype.old.ArchetypeTemplateProcessingException;
import org.apache.maven.archetype.old.OldArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptorBuilder;
import org.apache.maven.archetype.old.descriptor.TemplateDescriptor;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

@Component(role=OldArchetype.class)
public class DefaultOldArchetype
extends AbstractLogEnabled
implements OldArchetype {
    private static final String DEFAULT_TEST_RESOURCE_DIR = "/src/test/resources";
    private static final String DEFAULT_TEST_SOURCE_DIR = "/src/test/java";
    private static final String DEFAULT_RESOURCE_DIR = "/src/main/resources";
    private static final String DEFAULT_SOURCE_DIR = "/src/main/java";
    @Requirement
    private VelocityComponent velocity;
    @Requirement
    private ArchetypeArtifactManager archetypeArtifactManager;

    public void createArchetype(ArchetypeGenerationRequest request, ArtifactRepository archetypeRepository) throws UnknownArchetype, ArchetypeNotFoundException, ArchetypeDescriptorException, ArchetypeTemplateProcessingException {
        File archetypeFile = this.archetypeArtifactManager.getArchetypeFile(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), archetypeRepository, request.getLocalRepository(), request.getRemoteArtifactRepositories());
        this.createArchetype(request, archetypeFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws ArchetypeDescriptorException, ArchetypeTemplateProcessingException {
        XmlStreamReader fileReader;
        File pomFile;
        boolean creating;
        File outputDirectoryFile;
        ArchetypeDescriptor descriptor;
        URLClassLoader archetypeJarLoader;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("basedir", request.getOutputDirectory());
        parameters.put("package", request.getPackage());
        parameters.put("packageName", request.getPackage());
        parameters.put("groupId", request.getGroupId());
        parameters.put("artifactId", request.getArtifactId());
        parameters.put("version", request.getVersion());
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("----------------------------------------------------------------------------");
            this.getLogger().info("Using following parameters for creating project from Old (1.x) Archetype: " + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion());
            this.getLogger().info("----------------------------------------------------------------------------");
            for (Map.Entry entry : parameters.entrySet()) {
                String parameterName = (String)entry.getKey();
                String parameterValue = (String)entry.getValue();
                this.getLogger().info("Parameter: " + parameterName + ", Value: " + parameterValue);
            }
        }
        ArchetypeDescriptorBuilder builder = new ArchetypeDescriptorBuilder();
        InputStream is = null;
        try {
            URL[] urls = new URL[]{archetypeFile.toURL()};
            archetypeJarLoader = new URLClassLoader(urls);
            is = this.getStream("META-INF/maven/archetype.xml", archetypeJarLoader);
            if (is == null) {
                is = this.getStream("META-INF/archetype.xml", archetypeJarLoader);
            }
            if (is == null) {
                throw new ArchetypeDescriptorException("The META-INF/maven/archetype.xml descriptor cannot be found.");
            }
            descriptor = builder.build((Reader)new org.apache.commons.io.input.XmlStreamReader(is));
        }
        catch (IOException e) {
            try {
                throw new ArchetypeDescriptorException("Error reading the META-INF/maven/archetype.xml descriptor.", e);
                catch (XmlPullParserException e2) {
                    throw new ArchetypeDescriptorException("Error reading the META-INF/maven/archetype.xml descriptor.", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
        String artifactId = request.getArtifactId();
        File parentPomFile = new File(request.getOutputDirectory(), "pom.xml");
        if (parentPomFile.exists() && descriptor.isAllowPartial() && artifactId == null) {
            outputDirectoryFile = new File(request.getOutputDirectory());
            creating = false;
            pomFile = parentPomFile;
        } else {
            if (artifactId == null) {
                throw new ArchetypeTemplateProcessingException("Artifact ID must be specified when creating a new project from an archetype.");
            }
            outputDirectoryFile = new File(request.getOutputDirectory(), artifactId);
            creating = true;
            if (outputDirectoryFile.exists()) {
                if (!descriptor.isAllowPartial()) {
                    throw new ArchetypeTemplateProcessingException("Directory " + outputDirectoryFile.getName() + " already exists - please run from a clean directory");
                }
                creating = false;
            }
            pomFile = new File(outputDirectoryFile, "pom.xml");
        }
        if (creating) {
            if (request.getGroupId() == null) {
                throw new ArchetypeTemplateProcessingException("Group ID must be specified when creating a new project from an archetype.");
            }
            if (request.getVersion() == null) {
                throw new ArchetypeTemplateProcessingException("Version must be specified when creating a new project from an archetype.");
            }
        }
        String outputDirectory = outputDirectoryFile.getAbsolutePath();
        String packageName = request.getPackage();
        VelocityContext context = new VelocityContext();
        context.put("package", packageName);
        for (Map.Entry entry : parameters.entrySet()) {
            context.put((String)entry.getKey(), entry.getValue());
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(archetypeJarLoader);
        Model parentModel = null;
        if (creating && parentPomFile.exists()) {
            fileReader = null;
            try {
                fileReader = ReaderFactory.newXmlReader(parentPomFile);
                MavenXpp3Reader reader = new MavenXpp3Reader();
                parentModel = reader.read(fileReader);
                if (!"pom".equals(parentModel.getPackaging())) {
                    throw new ArchetypeTemplateProcessingException("Unable to add module to the current project as it is not of packaging type 'pom'");
                }
            }
            catch (IOException e) {
                throw new ArchetypeTemplateProcessingException("Unable to read parent POM", e);
            }
            catch (XmlPullParserException e) {
                throw new ArchetypeTemplateProcessingException("Unable to read parent POM", e);
            }
            finally {
                IOUtil.close(fileReader);
            }
            parentModel.getModules().add(artifactId);
        }
        try {
            this.processTemplates(pomFile, outputDirectory, context, descriptor, packageName, parentModel);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        if (parentModel != null) {
            boolean added;
            fileReader = null;
            StringWriter w = new StringWriter();
            try {
                fileReader = ReaderFactory.newXmlReader(parentPomFile);
                added = DefaultOldArchetype.addModuleToParentPom(artifactId, fileReader, w);
            }
            catch (IOException e) {
                throw new ArchetypeTemplateProcessingException("Unable to rewrite parent POM", e);
            }
            catch (DocumentException e) {
                throw new ArchetypeTemplateProcessingException("Unable to rewrite parent POM", e);
            }
            finally {
                IOUtil.close(fileReader);
            }
            if (added) {
                XmlStreamWriter out = null;
                try {
                    out = WriterFactory.newXmlWriter(parentPomFile);
                    IOUtil.copy(w.toString(), (Writer)out);
                }
                catch (IOException e) {
                    throw new ArchetypeTemplateProcessingException("Unable to rewrite parent POM", e);
                }
                finally {
                    IOUtil.close(out);
                }
            }
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("project created from Old (1.x) Archetype in dir: " + outputDirectory);
        }
    }

    static boolean addModuleToParentPom(String artifactId, Reader fileReader, Writer fileWriter) throws DocumentException, IOException, ArchetypeTemplateProcessingException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(fileReader);
        Element project = document.getRootElement();
        String packaging = null;
        Element packagingElement = project.element("packaging");
        if (packagingElement != null) {
            packaging = packagingElement.getStringValue();
        }
        if (!"pom".equals(packaging)) {
            throw new ArchetypeTemplateProcessingException("Unable to add module to the current project as it is not of packaging type 'pom'");
        }
        Element modules = project.element("modules");
        if (modules == null) {
            modules = project.addText("  ").addElement("modules");
            modules.setText("\n  ");
            project.addText("\n");
        }
        boolean found = false;
        Iterator i = modules.elementIterator("module");
        while (i.hasNext() && !found) {
            Element module = (Element)i.next();
            if (!module.getText().equals(artifactId)) continue;
            found = true;
        }
        if (!found) {
            Node lastTextNode = null;
            Iterator i2 = modules.nodeIterator();
            while (i2.hasNext()) {
                Node node = (Node)i2.next();
                if (node.getNodeType() == 1) {
                    lastTextNode = null;
                    continue;
                }
                if (node.getNodeType() != 3) continue;
                lastTextNode = node;
            }
            if (lastTextNode != null) {
                modules.remove(lastTextNode);
            }
            modules.addText("\n    ");
            modules.addElement("module").setText(artifactId);
            modules.addText("\n  ");
            XMLWriter writer = new XMLWriter(fileWriter);
            writer.write(document);
        }
        return !found;
    }

    private void processTemplates(File pomFile, String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, Model parentModel) throws ArchetypeTemplateProcessingException {
        boolean foundBuildElement;
        Model generatedModel;
        if (!pomFile.exists()) {
            this.processTemplate(outputDirectory, context, "pom.xml", new TemplateDescriptor(), false, null);
        }
        XmlStreamReader pomReader = null;
        try {
            pomReader = ReaderFactory.newXmlReader(pomFile);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            generatedModel = reader.read(pomReader);
        }
        catch (IOException e) {
            throw new ArchetypeTemplateProcessingException("Error reading POM", e);
        }
        catch (XmlPullParserException e) {
            throw new ArchetypeTemplateProcessingException("Error reading POM", e);
        }
        finally {
            IOUtil.close(pomReader);
        }
        if (parentModel != null) {
            Parent parent = new Parent();
            parent.setGroupId(parentModel.getGroupId());
            if (parent.getGroupId() == null) {
                parent.setGroupId(parentModel.getParent().getGroupId());
            }
            parent.setArtifactId(parentModel.getArtifactId());
            parent.setVersion(parentModel.getVersion());
            if (parent.getVersion() == null) {
                parent.setVersion(parentModel.getParent().getVersion());
            }
            generatedModel.setParent(parent);
            XmlStreamWriter pomWriter = null;
            try {
                pomWriter = WriterFactory.newXmlWriter(pomFile);
                MavenXpp3Writer writer = new MavenXpp3Writer();
                writer.write(pomWriter, generatedModel);
            }
            catch (IOException e) {
                throw new ArchetypeTemplateProcessingException("Error rewriting POM", e);
            }
            finally {
                IOUtil.close(pomWriter);
            }
        }
        Build build = generatedModel.getBuild();
        boolean overrideSrcDir = false;
        boolean overrideResourceDir = false;
        boolean overrideTestSrcDir = false;
        boolean overrideTestResourceDir = false;
        boolean bl = foundBuildElement = build != null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("********************* Debug info for resources created from generated Model ***********************");
            this.getLogger().debug("Was build element found in generated POM?: " + foundBuildElement);
        }
        if (foundBuildElement && null != build.getSourceDirectory()) {
            this.getLogger().debug("Overriding default source directory ");
            overrideSrcDir = true;
            String srcDirectory = build.getSourceDirectory();
            srcDirectory = StringUtils.replace(srcDirectory, "\\", "/");
            FileUtils.mkdir(this.getOutputDirectory(outputDirectory, srcDirectory));
        }
        if (foundBuildElement && null != build.getScriptSourceDirectory()) {
            this.getLogger().debug("Overriding default script source directory ");
            String scriptSourceDirectory = build.getScriptSourceDirectory();
            scriptSourceDirectory = StringUtils.replace(scriptSourceDirectory, "\\", "/");
            FileUtils.mkdir(this.getOutputDirectory(outputDirectory, scriptSourceDirectory));
        }
        if (foundBuildElement && build.getResources().size() > 0) {
            this.getLogger().debug("Overriding default resource directory ");
            overrideResourceDir = true;
            for (Resource resource : build.getResources()) {
                String resourceDirectory = resource.getDirectory();
                resourceDirectory = StringUtils.replace(resourceDirectory, "\\", "/");
                FileUtils.mkdir(this.getOutputDirectory(outputDirectory, resourceDirectory));
            }
        }
        if (foundBuildElement && null != build.getTestSourceDirectory()) {
            this.getLogger().debug("Overriding default test directory ");
            overrideTestSrcDir = true;
            String testDirectory = build.getTestSourceDirectory();
            testDirectory = StringUtils.replace(testDirectory, "\\", "/");
            FileUtils.mkdir(this.getOutputDirectory(outputDirectory, testDirectory));
        }
        if (foundBuildElement && build.getTestResources().size() > 0) {
            this.getLogger().debug("Overriding default test resource directory ");
            overrideTestResourceDir = true;
            for (Resource resource : build.getTestResources()) {
                String testResourceDirectory = resource.getDirectory();
                testResourceDirectory = StringUtils.replace(testResourceDirectory, "\\", "/");
                FileUtils.mkdir(this.getOutputDirectory(outputDirectory, testResourceDirectory));
            }
        }
        this.getLogger().debug("********************* End of debug info from resources from generated POM ***********************");
        if (descriptor.getSources().size() > 0) {
            if (!overrideSrcDir) {
                FileUtils.mkdir(outputDirectory + DEFAULT_SOURCE_DIR);
                this.processSources(outputDirectory, context, descriptor, packageName, DEFAULT_SOURCE_DIR);
            } else {
                this.processSources(outputDirectory, context, descriptor, packageName, build.getSourceDirectory());
            }
        }
        if (descriptor.getResources().size() > 0) {
            if (!overrideResourceDir) {
                FileUtils.mkdir(outputDirectory + DEFAULT_RESOURCE_DIR);
            }
            this.processResources(outputDirectory, context, descriptor, packageName);
        }
        if (descriptor.getTestSources().size() > 0) {
            if (!overrideTestSrcDir) {
                FileUtils.mkdir(outputDirectory + DEFAULT_TEST_SOURCE_DIR);
                this.processTestSources(outputDirectory, context, descriptor, packageName, DEFAULT_TEST_SOURCE_DIR);
            } else {
                this.processTestSources(outputDirectory, context, descriptor, packageName, build.getTestSourceDirectory());
            }
        }
        if (descriptor.getTestResources().size() > 0) {
            if (!overrideTestResourceDir) {
                FileUtils.mkdir(outputDirectory + DEFAULT_TEST_RESOURCE_DIR);
            }
            this.processTestResources(outputDirectory, context, descriptor, packageName);
        }
        if (descriptor.getSiteResources().size() > 0) {
            this.processSiteResources(outputDirectory, context, descriptor, packageName);
        }
    }

    private void processTemplate(String outputDirectory, Context context, String template, TemplateDescriptor descriptor, boolean packageInFileName, String packageName) throws ArchetypeTemplateProcessingException {
        this.processTemplate(outputDirectory, context, template, descriptor, packageInFileName, packageName, null);
    }

    private String getOutputDirectory(String outputDirectory, String testResourceDirectory) {
        return outputDirectory + (testResourceDirectory.startsWith("/") ? testResourceDirectory : "/" + testResourceDirectory);
    }

    protected void processSources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, String sourceDirectory) throws ArchetypeTemplateProcessingException {
        for (String template : descriptor.getSources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getSourceDescriptor(template), true, packageName, sourceDirectory);
        }
    }

    protected void processTestSources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, String testSourceDirectory) throws ArchetypeTemplateProcessingException {
        for (String template : descriptor.getTestSources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getTestSourceDescriptor(template), true, packageName, testSourceDirectory);
        }
    }

    protected void processResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws ArchetypeTemplateProcessingException {
        for (String template : descriptor.getResources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getResourceDescriptor(template), false, packageName);
        }
    }

    protected void processTestResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws ArchetypeTemplateProcessingException {
        for (String template : descriptor.getTestResources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getTestResourceDescriptor(template), false, packageName);
        }
    }

    protected void processSiteResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws ArchetypeTemplateProcessingException {
        for (String template : descriptor.getSiteResources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getSiteResourceDescriptor(template), false, packageName);
        }
    }

    protected void processTemplate(String outputDirectory, Context context, String template, TemplateDescriptor descriptor, boolean packageInFileName, String packageName, String sourceDirectory) throws ArchetypeTemplateProcessingException {
        block16: {
            File f;
            block15: {
                template = StringUtils.replace(template, "\\", "/");
                if (packageInFileName && packageName != null) {
                    String templateFileName = StringUtils.replace(template, "/", File.separator);
                    String path = packageName.replace('.', '/');
                    String filename = FileUtils.filename(templateFileName);
                    String dirname = FileUtils.dirname(templateFileName).replace('\\', '/');
                    if ((sourceDirectory = sourceDirectory.replace('\\', '/')).startsWith("/")) {
                        sourceDirectory = sourceDirectory.substring(1);
                    }
                    if (!dirname.startsWith(sourceDirectory)) {
                        throw new ArchetypeTemplateProcessingException("Template '" + template + "' not in directory '" + sourceDirectory + "'");
                    }
                    String extraPackages = dirname.substring(sourceDirectory.length());
                    if (extraPackages.startsWith("/")) {
                        extraPackages = extraPackages.substring(1);
                    }
                    if (extraPackages.length() > 0) {
                        path = path + "/" + extraPackages;
                    }
                    f = new File(new File(new File(outputDirectory, sourceDirectory), path), filename);
                } else {
                    f = new File(outputDirectory, template);
                }
                if (!f.getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                if (!descriptor.isFiltered()) break block15;
                OutputStreamWriter writer = null;
                try {
                    StringWriter stringWriter = new StringWriter();
                    template = "archetype-resources/" + template;
                    this.velocity.getEngine().mergeTemplate(template, descriptor.getEncoding(), context, stringWriter);
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), descriptor.getEncoding());
                    writer.write(StringUtils.unifyLineSeparators(stringWriter.toString()));
                    ((Writer)writer).flush();
                }
                catch (Exception e) {
                    try {
                        throw new ArchetypeTemplateProcessingException("Error merging velocity templates", e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(writer);
                        throw throwable;
                    }
                }
                IOUtil.close(writer);
                break block16;
            }
            InputStream is = this.getStream("archetype-resources/" + template, null);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                IOUtil.copy(is, (OutputStream)fos);
            }
            catch (Exception e) {
                try {
                    throw new ArchetypeTemplateProcessingException("Error copying file", e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fos);
                    IOUtil.close(is);
                    throw throwable;
                }
            }
            IOUtil.close(fos);
            IOUtil.close(is);
        }
    }

    protected void createProjectDirectoryStructure(String outputDirectory) {
    }

    private InputStream getStream(String name, ClassLoader loader) {
        if (loader == null) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        }
        return loader.getResourceAsStream(name);
    }
}

