/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.exception.ArchetypeGenerationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.exception.OutputFileExists;
import org.apache.maven.archetype.exception.PomFileExists;
import org.apache.maven.archetype.exception.ProjectDirectoryExists;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.generator.FilesetArchetypeGenerator;
import org.apache.maven.archetype.metadata.AbstractArchetypeDescriptor;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.FileSet;
import org.apache.maven.archetype.metadata.ModuleDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=FilesetArchetypeGenerator.class)
public class DefaultFilesetArchetypeGenerator
extends AbstractLogEnabled
implements FilesetArchetypeGenerator {
    @Requirement
    private ArchetypeArtifactManager archetypeArtifactManager;
    @Requirement
    private ArchetypeFilesResolver archetypeFilesResolver;
    @Requirement
    private PomManager pomManager;
    @Requirement
    private VelocityComponent velocity;
    private static final String DELIMITER = "__";
    private static final Pattern TOKEN_PATTERN = Pattern.compile(".*__.*__.*");

    @Override
    public void generateArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws UnknownArchetype, ArchetypeNotConfigured, ProjectDirectoryExists, PomFileExists, OutputFileExists, ArchetypeGenerationFailure {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ArchetypeDescriptor archetypeDescriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(archetypeFile);
            if (!this.isArchetypeConfigured(archetypeDescriptor, request)) {
                if (request.isInteractiveMode()) {
                    throw new ArchetypeNotConfigured("No archetype was chosen.", null);
                }
                StringBuffer exceptionMessage = new StringBuffer("Archetype " + request.getArchetypeGroupId() + ":" + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion() + " is not configured");
                ArrayList<String> missingProperties = new ArrayList<String>(0);
                for (RequiredProperty requiredProperty : archetypeDescriptor.getRequiredProperties()) {
                    if (!StringUtils.isEmpty(request.getProperties().getProperty(requiredProperty.getKey()))) continue;
                    exceptionMessage.append("\n\tProperty " + requiredProperty.getKey() + " is missing.");
                    missingProperties.add(requiredProperty.getKey());
                }
                throw new ArchetypeNotConfigured(exceptionMessage.toString(), missingProperties);
            }
            Context context = this.prepareVelocityContext(request);
            String packageName = request.getPackage();
            String artifactId = request.getArtifactId();
            File outputDirectoryFile = new File(request.getOutputDirectory(), artifactId);
            File basedirPom = new File(request.getOutputDirectory(), "pom.xml");
            File pom = new File(outputDirectoryFile, "pom.xml");
            List<String> archetypeResources = this.archetypeArtifactManager.getFilesetArchetypeResources(archetypeFile);
            ZipFile archetypeZipFile = this.archetypeArtifactManager.getArchetypeZipFile(archetypeFile);
            ClassLoader archetypeJarLoader = this.archetypeArtifactManager.getArchetypeJarLoader(archetypeFile);
            Thread.currentThread().setContextClassLoader(archetypeJarLoader);
            if (archetypeDescriptor.isPartial()) {
                this.getLogger().debug("Processing partial archetype " + archetypeDescriptor.getName());
                if (outputDirectoryFile.exists()) {
                    if (!pom.exists()) {
                        throw new PomFileExists("This is a partial archetype and the pom.xml file doesn't exist.");
                    }
                    this.processPomWithMerge(context, pom, "");
                    this.processArchetypeTemplatesWithWarning(archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, outputDirectoryFile);
                } else if (basedirPom.exists()) {
                    this.processPomWithMerge(context, basedirPom, "");
                    this.processArchetypeTemplatesWithWarning(archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, new File(request.getOutputDirectory()));
                } else {
                    this.processPom(context, pom, "");
                    this.processArchetypeTemplates(archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, outputDirectoryFile);
                }
                if (archetypeDescriptor.getModules().size() > 0) {
                    this.getLogger().info("Modules ignored in partial mode");
                }
            } else {
                this.getLogger().debug("Processing complete archetype " + archetypeDescriptor.getName());
                if (outputDirectoryFile.exists() && pom.exists()) {
                    throw new ProjectDirectoryExists("A Maven 2 project already exists in the directory " + outputDirectoryFile.getPath());
                }
                if (outputDirectoryFile.exists()) {
                    this.getLogger().warn("The directory " + outputDirectoryFile.getPath() + " already exists.");
                }
                context.put("rootArtifactId", artifactId);
                this.processFilesetModule(artifactId, artifactId, archetypeResources, pom, archetypeZipFile, "", basedirPom, outputDirectoryFile, packageName, archetypeDescriptor, context);
            }
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("project created from Archetype in dir: " + outputDirectoryFile.getAbsolutePath());
            }
        }
        catch (FileNotFoundException ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (IOException ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (XmlPullParserException ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (DocumentException ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (ArchetypeGenerationFailure ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (InvalidPackaging ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public String getPackageAsDirectory(String packageName) {
        return StringUtils.replace(packageName, ".", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyFile(File outFile, String template, boolean failIfExists, ZipFile archetypeZipFile) throws FileNotFoundException, OutputFileExists, IOException {
        this.getLogger().debug("Copying file " + template);
        if (failIfExists && outFile.exists()) {
            throw new OutputFileExists("Don't rewrite file " + outFile.getName());
        }
        if (outFile.exists()) {
            this.getLogger().warn("CP Don't override file " + outFile);
            return false;
        }
        ZipEntry input = archetypeZipFile.getEntry("archetype-resources/" + template);
        if (input.isDirectory()) {
            outFile.mkdirs();
            return true;
        }
        InputStream inputStream = null;
        FileOutputStream out = null;
        try {
            inputStream = archetypeZipFile.getInputStream(input);
            outFile.getParentFile().mkdirs();
            out = new FileOutputStream(outFile);
            IOUtil.copy(inputStream, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(inputStream);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close(inputStream);
        IOUtil.close(out);
        return true;
    }

    private int copyFiles(String directory, List<String> fileSetResources, boolean packaged, String packageName, File outputDirectoryFile, ZipFile archetypeZipFile, String moduleOffset, boolean failIfExists, Context context) throws OutputFileExists, FileNotFoundException, IOException {
        int count = 0;
        for (String template : fileSetResources) {
            File outputFile = this.getOutputFile(template, directory, outputDirectoryFile, packaged, packageName, moduleOffset, context);
            if (!this.copyFile(outputFile, template, failIfExists, archetypeZipFile)) continue;
            ++count;
        }
        return count;
    }

    private String getEncoding(String archetypeEncoding) {
        return StringUtils.isEmpty(archetypeEncoding) ? "UTF-8" : archetypeEncoding;
    }

    private String getOffsetSeparator(String moduleOffset) {
        return StringUtils.isEmpty(moduleOffset) ? "/" : "/" + moduleOffset + "/";
    }

    private File getOutputFile(String template, String directory, File outputDirectoryFile, boolean packaged, String packageName, String moduleOffset, Context context) {
        String templateName = StringUtils.replaceOnce(template, directory, "");
        String outputFileName = directory + "/" + (packaged ? this.getPackageAsDirectory(packageName) : "") + "/" + templateName.substring(moduleOffset.length());
        if (TOKEN_PATTERN.matcher(outputFileName).matches()) {
            outputFileName = this.replaceFilenameTokens(outputFileName, context);
        }
        return new File(outputDirectoryFile, outputFileName);
    }

    private String replaceFilenameTokens(String filePath, Context context) {
        int end;
        String interpolatedResult = filePath;
        int start = 0;
        while ((start = interpolatedResult.indexOf(DELIMITER, start)) != -1 && (end = interpolatedResult.indexOf(DELIMITER, start + DELIMITER.length())) != -1) {
            String propertyToken = interpolatedResult.substring(start + DELIMITER.length(), end);
            String contextPropertyValue = (String)context.get(propertyToken);
            if (contextPropertyValue != null && contextPropertyValue.trim().length() > 0) {
                String search = DELIMITER + propertyToken + DELIMITER;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Replacing '" + search + "' in file path '" + interpolatedResult + "' with value '" + contextPropertyValue + "'.");
                }
                interpolatedResult = StringUtils.replace(interpolatedResult, search, contextPropertyValue);
                end = end + contextPropertyValue.length() - search.length();
            } else {
                this.getLogger().warn("Property '" + propertyToken + "' was not specified, so the token in '" + interpolatedResult + "' is not being replaced.");
            }
            start = end + DELIMITER.length() + 1;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Final interpolated file path: '" + interpolatedResult + "'");
        }
        return interpolatedResult;
    }

    private String getPackageInPathFormat(String aPackage) {
        return StringUtils.replace(aPackage, ".", "/");
    }

    private boolean isArchetypeConfigured(ArchetypeDescriptor archetypeDescriptor, ArchetypeGenerationRequest request) {
        for (RequiredProperty requiredProperty : archetypeDescriptor.getRequiredProperties()) {
            if (!StringUtils.isEmpty(request.getProperties().getProperty(requiredProperty.getKey()))) continue;
            return false;
        }
        return true;
    }

    private void setParentArtifactId(Context context, String artifactId) {
        context.put("parentArtifactId", artifactId);
    }

    private Context prepareVelocityContext(ArchetypeGenerationRequest request) {
        VelocityContext context = new VelocityContext();
        context.put("groupId", request.getGroupId());
        context.put("artifactId", request.getArtifactId());
        context.put("version", request.getVersion());
        context.put("package", request.getPackage());
        String packageInPathFormat = this.getPackageInPathFormat(request.getPackage());
        context.put("packageInPathFormat", packageInPathFormat);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("----------------------------------------------------------------------------");
            this.getLogger().info("Using following parameters for creating project from Archetype: " + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion());
            this.getLogger().info("----------------------------------------------------------------------------");
            this.getLogger().info("Parameter: groupId, Value: " + request.getGroupId());
            this.getLogger().info("Parameter: artifactId, Value: " + request.getArtifactId());
            this.getLogger().info("Parameter: version, Value: " + request.getVersion());
            this.getLogger().info("Parameter: package, Value: " + request.getPackage());
            this.getLogger().info("Parameter: packageInPathFormat, Value: " + packageInPathFormat);
        }
        for (String string : request.getProperties().keySet()) {
            String value = request.getProperties().getProperty(string);
            if (this.maybeVelocityExpression(value)) {
                value = this.evaluateExpression(context, string, value);
            }
            context.put(string, value);
            if (!this.getLogger().isInfoEnabled()) continue;
            this.getLogger().info("Parameter: " + string + ", Value: " + value);
        }
        return context;
    }

    private boolean maybeVelocityExpression(String value) {
        return value != null && value.contains("${");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String evaluateExpression(Context context, String key, String value) {
        StringWriter stringWriter = new StringWriter();
        try {
            Velocity.evaluate(context, (Writer)stringWriter, key, value);
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception ex) {
            String string = value;
            return string;
        }
        finally {
            IOUtil.close(stringWriter);
        }
    }

    private void processArchetypeTemplates(AbstractArchetypeDescriptor archetypeDescriptor, List<String> archetypeResources, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile) throws OutputFileExists, ArchetypeGenerationFailure, FileNotFoundException, IOException {
        this.processTemplates(packageName, outputDirectoryFile, context, archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, false);
    }

    private void processArchetypeTemplatesWithWarning(ArchetypeDescriptor archetypeDescriptor, List<String> archetypeResources, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile) throws OutputFileExists, ArchetypeGenerationFailure, FileNotFoundException, IOException {
        this.processTemplates(packageName, outputDirectoryFile, context, archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, true);
    }

    private int processFileSet(String directory, List<String> fileSetResources, boolean packaged, String packageName, Context context, File outputDirectoryFile, String moduleOffset, String archetypeEncoding, boolean failIfExists) throws OutputFileExists, ArchetypeGenerationFailure {
        int count = 0;
        for (String template : fileSetResources) {
            File outputFile = this.getOutputFile(template, directory, outputDirectoryFile, packaged, packageName, moduleOffset, context);
            if (!this.processTemplate(outputFile, context, "archetype-resources/" + template, archetypeEncoding, failIfExists)) continue;
            ++count;
        }
        return count;
    }

    private void processFilesetModule(String rootArtifactId, String artifactId, List<String> archetypeResources, File pom, ZipFile archetypeZipFile, String moduleOffset, File basedirPom, File outputDirectoryFile, String packageName, AbstractArchetypeDescriptor archetypeDescriptor, Context context) throws DocumentException, XmlPullParserException, ArchetypeGenerationFailure, InvalidPackaging, IOException, OutputFileExists {
        outputDirectoryFile.mkdirs();
        this.getLogger().debug("Processing module " + artifactId);
        this.getLogger().debug("Processing module rootArtifactId " + rootArtifactId);
        this.getLogger().debug("Processing module pom " + pom);
        this.getLogger().debug("Processing module moduleOffset " + moduleOffset);
        this.getLogger().debug("Processing module outputDirectoryFile " + outputDirectoryFile);
        this.processFilesetProject(archetypeDescriptor, StringUtils.replace(artifactId, "${rootArtifactId}", rootArtifactId), archetypeResources, pom, archetypeZipFile, moduleOffset, context, packageName, outputDirectoryFile, basedirPom);
        String parentArtifactId = (String)context.get("parentArtifactId");
        Iterator<ModuleDescriptor> subprojects = archetypeDescriptor.getModules().iterator();
        if (subprojects.hasNext()) {
            this.getLogger().debug(artifactId + " has modules (" + archetypeDescriptor.getModules() + ")");
            this.setParentArtifactId(context, StringUtils.replace(artifactId, "${rootArtifactId}", rootArtifactId));
        }
        while (subprojects.hasNext()) {
            ModuleDescriptor project = subprojects.next();
            File moduleOutputDirectoryFile = new File(outputDirectoryFile, StringUtils.replace(project.getDir(), "__rootArtifactId__", rootArtifactId));
            context.put("artifactId", StringUtils.replace(project.getId(), "${rootArtifactId}", rootArtifactId));
            this.processFilesetModule(rootArtifactId, StringUtils.replace(project.getDir(), "__rootArtifactId__", rootArtifactId), archetypeResources, new File(moduleOutputDirectoryFile, "pom.xml"), archetypeZipFile, (StringUtils.isEmpty(moduleOffset) ? "" : moduleOffset + "/") + StringUtils.replace(project.getDir(), "${rootArtifactId}", rootArtifactId), pom, moduleOutputDirectoryFile, packageName, project, context);
        }
        this.restoreParentArtifactId(context, parentArtifactId);
        this.getLogger().debug("Processed " + artifactId);
    }

    private void processFilesetProject(AbstractArchetypeDescriptor archetypeDescriptor, String moduleId, List<String> archetypeResources, File pom, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile, File basedirPom) throws DocumentException, XmlPullParserException, ArchetypeGenerationFailure, InvalidPackaging, IOException, FileNotFoundException, OutputFileExists {
        this.getLogger().debug("Processing fileset project moduleId " + moduleId);
        this.getLogger().debug("Processing fileset project pom " + pom);
        this.getLogger().debug("Processing fileset project moduleOffset " + moduleOffset);
        this.getLogger().debug("Processing fileset project outputDirectoryFile " + outputDirectoryFile);
        this.getLogger().debug("Processing fileset project basedirPom " + basedirPom);
        if (basedirPom.exists()) {
            this.processPomWithParent(context, pom, moduleOffset, basedirPom, moduleId);
        } else {
            this.processPom(context, pom, moduleOffset);
        }
        this.processArchetypeTemplates(archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, context, packageName, outputDirectoryFile);
    }

    private void processPom(Context context, File pom, String moduleOffset) throws OutputFileExists, ArchetypeGenerationFailure {
        this.getLogger().debug("Processing pom " + pom);
        this.processTemplate(pom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
    }

    private void processPomWithMerge(Context context, File pom, String moduleOffset) throws OutputFileExists, IOException, XmlPullParserException, ArchetypeGenerationFailure {
        this.getLogger().debug("Processing pom " + pom + " with merge");
        File temporaryPom = this.getTemporaryFile(pom);
        this.processTemplate(temporaryPom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
        this.pomManager.mergePoms(pom, temporaryPom);
        try {
            FileUtils.forceDelete(temporaryPom);
        }
        catch (IOException e) {
            temporaryPom.deleteOnExit();
        }
    }

    private void processPomWithParent(Context context, File pom, String moduleOffset, File basedirPom, String moduleId) throws OutputFileExists, XmlPullParserException, DocumentException, IOException, InvalidPackaging, ArchetypeGenerationFailure {
        this.getLogger().debug("Processing pom " + pom + " with parent " + basedirPom);
        this.processTemplate(pom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
        this.getLogger().debug("Adding module " + moduleId);
        this.pomManager.addModule(basedirPom, moduleId);
        this.pomManager.addParent(pom, basedirPom);
    }

    private boolean processTemplate(File outFile, Context context, String templateFileName, String encoding, boolean failIfExists) throws OutputFileExists, ArchetypeGenerationFailure {
        String localTemplateFileName;
        if (!(templateFileName = templateFileName.replace(File.separatorChar, '/')).equals(localTemplateFileName = templateFileName.replace('/', File.separatorChar)) && !this.velocity.getEngine().templateExists(templateFileName) && this.velocity.getEngine().templateExists(localTemplateFileName)) {
            templateFileName = localTemplateFileName;
        }
        this.getLogger().debug("Processing template " + templateFileName);
        if (outFile.exists()) {
            if (failIfExists) {
                throw new OutputFileExists("Don't override file " + outFile.getAbsolutePath());
            }
            this.getLogger().warn("Don't override file " + outFile);
            return false;
        }
        if (templateFileName.endsWith("/")) {
            this.getLogger().debug("Creating directory " + outFile);
            outFile.mkdirs();
            return true;
        }
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        this.getLogger().debug("Merging into " + outFile);
        OutputStreamWriter writer = null;
        try {
            StringWriter stringWriter = new StringWriter();
            this.velocity.getEngine().mergeTemplate(templateFileName, encoding, context, stringWriter);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), encoding);
            writer.write(StringUtils.unifyLineSeparators(stringWriter.toString()));
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            try {
                throw new ArchetypeGenerationFailure("Error merging velocity templates: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
        return true;
    }

    private void processTemplates(String packageName, File outputDirectoryFile, Context context, AbstractArchetypeDescriptor archetypeDescriptor, List<String> archetypeResources, ZipFile archetypeZipFile, String moduleOffset, boolean failIfExists) throws OutputFileExists, ArchetypeGenerationFailure, FileNotFoundException, IOException {
        Iterator<FileSet> iterator = archetypeDescriptor.getFileSets().iterator();
        if (iterator.hasNext()) {
            this.getLogger().debug("Processing filesets\n  " + archetypeResources);
        }
        int count = 0;
        while (iterator.hasNext()) {
            FileSet fileSet = iterator.next();
            ++count;
            List<String> fileSetResources = this.archetypeFilesResolver.filterFiles(moduleOffset, fileSet, archetypeResources);
            this.getOutputFile(moduleOffset, fileSet.getDirectory(), outputDirectoryFile, fileSet.isPackaged(), packageName, moduleOffset, context).mkdirs();
            if (fileSet.isFiltered()) {
                this.getLogger().debug("    Processing fileset " + fileSet + " -> " + fileSetResources.size() + ":\n      " + fileSetResources);
                int processed = this.processFileSet(fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, context, outputDirectoryFile, moduleOffset, this.getEncoding(fileSet.getEncoding()), failIfExists);
                this.getLogger().debug("    Processed " + processed + " files.");
                continue;
            }
            this.getLogger().debug("    Copying fileset " + fileSet + " -> " + fileSetResources.size() + ":\n      " + fileSetResources);
            int copied = this.copyFiles(fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, outputDirectoryFile, archetypeZipFile, moduleOffset, failIfExists, context);
            this.getLogger().debug("    Copied " + copied + " files.");
        }
        this.getLogger().debug("Processed " + count + " filesets");
    }

    private void restoreParentArtifactId(Context context, String parentArtifactId) {
        if (StringUtils.isEmpty(parentArtifactId)) {
            context.remove("parentArtifactId");
        } else {
            context.put("parentArtifactId", parentArtifactId);
        }
    }

    private File getTemporaryFile(File file) {
        File tmp = FileUtils.createTempFile(file.getName(), ".tmp", file.getParentFile());
        tmp.deleteOnExit();
        return tmp;
    }
}

