/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.CommonASTWithHiddenTokens;
import antlr.CommonHiddenStreamToken;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.TokenStreamSelector;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.grammar.CommentListener;
import com.puppycrawl.tools.checkstyle.grammar.GeneratedJavaLexer;
import com.puppycrawl.tools.checkstyle.grammar.GeneratedTextBlockLexer;
import com.puppycrawl.tools.checkstyle.utils.ParserUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public final class JavaParser {
    private JavaParser() {
    }

    public static DetailAST parse(FileContents contents) throws CheckstyleException {
        TokenStreamSelector selector;
        String fullText = contents.getText().getFullText().toString();
        StringReader reader = new StringReader(fullText);
        GeneratedJavaLexer lexer = new GeneratedJavaLexer((Reader)reader);
        lexer.setCommentListener((CommentListener)contents);
        GeneratedTextBlockLexer textBlockLexer = new GeneratedTextBlockLexer(lexer.getInputState());
        String tokenObjectClass = "antlr.CommonHiddenStreamToken";
        lexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        textBlockLexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
        filter.hide(144);
        filter.hide(145);
        lexer.selector = selector = new TokenStreamSelector();
        textBlockLexer.selector = selector;
        selector.addInputStream((TokenStream)textBlockLexer, "textBlockLexer");
        selector.select((TokenStream)filter);
        1 parser = new /* Unavailable Anonymous Inner Class!! */;
        parser.setFilename(contents.getFileName());
        parser.setASTNodeClass(DetailAstImpl.class.getName());
        try {
            parser.compilationUnit();
        }
        catch (RecognitionException | TokenStreamException | IllegalStateException ex) {
            String exceptionMsg = String.format(Locale.ROOT, "%s occurred while parsing file %s.", ex.getClass().getSimpleName(), contents.getFileName());
            throw new CheckstyleException(exceptionMsg, ex);
        }
        return (DetailAST)parser.getAST();
    }

    public static DetailAST parseFileText(FileText text, Options options) throws CheckstyleException {
        FileContents contents = new FileContents(text);
        DetailAST ast = JavaParser.parse(contents);
        if (options == Options.WITH_COMMENTS) {
            ast = JavaParser.appendHiddenCommentNodes(ast);
        }
        return ast;
    }

    public static DetailAST parseFile(File file, Options options) throws IOException, CheckstyleException {
        FileText text = new FileText(file.getAbsoluteFile(), StandardCharsets.UTF_8.name());
        return JavaParser.parseFileText(text, options);
    }

    public static DetailAST appendHiddenCommentNodes(DetailAST root) {
        DetailAST newCommentNode;
        DetailAST currentSibling;
        DetailAST result = root;
        DetailAST curNode = root;
        DetailAST lastNode = root;
        while (curNode != null) {
            lastNode = curNode;
            currentSibling = curNode;
            for (CommonHiddenStreamToken tokenBefore = ((CommonASTWithHiddenTokens)curNode).getHiddenBefore(); tokenBefore != null; tokenBefore = tokenBefore.getHiddenBefore()) {
                newCommentNode = JavaParser.createCommentAstFromToken((Token)tokenBefore);
                ((DetailAstImpl)currentSibling).addPreviousSibling(newCommentNode);
                if (currentSibling == result) {
                    result = newCommentNode;
                }
                currentSibling = newCommentNode;
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        if (lastNode != null) {
            currentSibling = lastNode;
            for (CommonHiddenStreamToken tokenAfter = ((CommonASTWithHiddenTokens)lastNode).getHiddenAfter(); tokenAfter != null; tokenAfter = tokenAfter.getHiddenAfter()) {
                newCommentNode = JavaParser.createCommentAstFromToken((Token)tokenAfter);
                ((DetailAstImpl)currentSibling).addNextSibling(newCommentNode);
                currentSibling = newCommentNode;
            }
        }
        return result;
    }

    private static DetailAST createCommentAstFromToken(Token token) {
        DetailAST commentAst = token.getType() == 144 ? JavaParser.createSlCommentNode(token) : ParserUtil.createBlockCommentNode((Token)token);
        return commentAst;
    }

    private static DetailAST createSlCommentNode(Token token) {
        DetailAstImpl slComment = new DetailAstImpl();
        slComment.setType(144);
        slComment.setText("//");
        slComment.setColumnNo(token.getColumn() - 1);
        slComment.setLineNo(token.getLine());
        DetailAstImpl slCommentContent = new DetailAstImpl();
        slCommentContent.setType(183);
        slCommentContent.setColumnNo(token.getColumn() - 1 + 2);
        slCommentContent.setLineNo(token.getLine());
        slCommentContent.setText(token.getText());
        slComment.addChild((AST)slCommentContent);
        return slComment;
    }
}

