/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.internal.security.auth;

import com.liferay.portal.kernel.audit.AuditException;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthFailure;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=auth.failure"}, service={AuthFailure.class})
public class LoginAuthFailure
implements AuthFailure {
    private static final Log _log = LogFactoryUtil.getLog(LoginAuthFailure.class);
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private UserLocalService _userLocalService;

    public void onFailureByEmailAddress(long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) {
        block4: {
            try {
                User user = this._userLocalService.getUserByEmailAddress(companyId, emailAddress);
                AuditMessage auditMessage = this._buildAuditMessage(user, emailAddress, headerMap, "Failed to authenticate by email address");
                this._auditRouter.route(auditMessage);
            }
            catch (AuditException auditException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to route audit message", (Throwable)auditException);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
    }

    public void onFailureByScreenName(long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) {
        block4: {
            try {
                User user = this._userLocalService.getUserByScreenName(companyId, screenName);
                AuditMessage auditMessage = this._buildAuditMessage(user, screenName, headerMap, "Failed to authenticate by screen name");
                this._auditRouter.route(auditMessage);
            }
            catch (AuditException auditException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to route audit message", (Throwable)auditException);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
    }

    public void onFailureByUserId(long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) {
        block4: {
            try {
                User user = this._userLocalService.getUserById(companyId, userId);
                AuditMessage auditMessage = this._buildAuditMessage(user, String.valueOf(userId), headerMap, "Failed to authenticate by user ID");
                this._auditRouter.route(auditMessage);
            }
            catch (AuditException auditException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to route audit message", (Throwable)auditException);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
    }

    private AuditMessage _buildAuditMessage(User user, String userLogin, Map<String, String[]> headerMap, String reason) {
        JSONObject additionalInfoJSONObject = this._jsonFactory.createJSONObject();
        additionalInfoJSONObject.put("headers", this._jsonFactory.serialize(headerMap)).put("reason", reason);
        AuditMessage auditMessage = new AuditMessage("LOGIN_FAILURE", user.getCompanyId(), user.getUserId(), user.getFullName(), User.class.getName(), String.valueOf(user.getPrimaryKey()), null, additionalInfoJSONObject);
        auditMessage.setUserLogin(userLogin);
        return auditMessage;
    }
}

