/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.internal.security.auth;

import com.liferay.portal.kernel.audit.AuditException;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthDNE;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AuthDNE.class})
public class LoginAuthDNE
implements AuthDNE {
    private static final Log _log = LogFactoryUtil.getLog(LoginAuthDNE.class);
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private JSONFactory _jsonFactory;

    public void onDoesNotExist(long companyId, String authType, String login, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) {
        block5: {
            try {
                AuditMessage auditMessage = new AuditMessage("LOGIN_DNE", companyId, 0L, null, User.class.getName(), "0", null, JSONUtil.put((String)"authType", (Object)authType).put("headers", this._jsonFactory.serialize(headerMap)).put("reason", "User does not exist"));
                auditMessage.setUserLogin(login);
                if (auditMessage == null) {
                    return;
                }
                this._auditRouter.route(auditMessage);
            }
            catch (AuditException auditException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to route audit message", (Throwable)auditException);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
    }
}

