/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.internal.model.listener;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserGroupRoleModelListener
extends BaseModelListener<UserGroupRole> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(UserGroupRole userGroupRole) throws ModelListenerException {
        this.auditOnCreateOrRemove("ASSIGN", userGroupRole);
    }

    public void onBeforeRemove(UserGroupRole userGroupRole) throws ModelListenerException {
        this.auditOnCreateOrRemove("UNASSIGN", userGroupRole);
    }

    protected void auditOnCreateOrRemove(String eventType, UserGroupRole userGroupRole) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)User.class.getName(), (long)userGroupRole.getUserId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("roleId", userGroupRole.getRoleId());
            Role role = userGroupRole.getRole();
            additionalInfoJSONObject.put("roleName", role.getName());
            Group group = userGroupRole.getGroup();
            additionalInfoJSONObject.put("scopeClassName", group.getClassName()).put("scopeClassPK", group.getClassPK());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

