/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.internal.model.listener;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class RoleModelListener
extends BaseModelListener<Role> {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private ClassNameLocalService _classNameService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        this._auditOnAddOrRemoveAssociation("ASSIGN", classPK, associationClassName, associationClassPK);
    }

    public void onBeforeCreate(Role role) throws ModelListenerException {
        this.auditOnCreateOrRemove("ADD", role);
    }

    public void onBeforeRemove(Role role) throws ModelListenerException {
        this.auditOnCreateOrRemove("DELETE", role);
    }

    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        this._auditOnAddOrRemoveAssociation("UNASSIGN", classPK, associationClassName, associationClassPK);
    }

    public void onBeforeUpdate(Role originalRole, Role role) throws ModelListenerException {
        try {
            List<Attribute> attributes = this._getModifiedAttributes(originalRole, role);
            if (!attributes.isEmpty()) {
                AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)Role.class.getName(), (long)role.getRoleId(), attributes);
                this._auditRouter.route(auditMessage);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    protected void auditOnCreateOrRemove(String eventType, Role role) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)Role.class.getName(), (long)role.getRoleId(), null);
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private void _auditOnAddOrRemoveAssociation(String eventType, Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (!(associationClassName.equals(Group.class.getName()) || associationClassName.equals(Organization.class.getName()) || associationClassName.equals(User.class.getName()))) {
            return;
        }
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)associationClassName, (long)((Long)associationClassPK), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            long roleId = (Long)classPK;
            additionalInfoJSONObject.put("roleId", roleId);
            Role role = this._roleLocalService.getRole(roleId);
            additionalInfoJSONObject.put("roleName", role.getName());
            if (associationClassName.equals(Group.class.getName())) {
                long groupId = (Long)associationClassPK;
                Group group = this._groupLocalService.getGroup(groupId);
                if (group.getClassNameId() == this._classNameService.getClassNameId(Organization.class.getName())) {
                    Organization organization = this._organizationLocalService.getOrganization(group.getClassPK());
                    additionalInfoJSONObject.put("organizationId", organization.getOrganizationId()).put("organizationName", organization.getName());
                } else if (group.getClassNameId() == this._classNameService.getClassNameId(UserGroup.class.getName())) {
                    UserGroup userGroup = this._userGroupLocalService.getUserGroup(group.getClassPK());
                    additionalInfoJSONObject.put("userGroupId", userGroup.getUserGroupId()).put("userGroupName", userGroup.getName());
                } else {
                    additionalInfoJSONObject.put("groupId", groupId).put("groupName", group.getNameCurrentValue());
                }
            } else if (associationClassName.equals(User.class.getName())) {
                long userId = (Long)associationClassPK;
                User user = this._userLocalService.getUser(userId);
                additionalInfoJSONObject.put("userEmailAddress", user.getEmailAddress()).put("userId", userId);
            }
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(Role originalRole, Role role) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)role, (Object)originalRole);
        attributesBuilder.add("description");
        attributesBuilder.add("name");
        attributesBuilder.add("subtype");
        attributesBuilder.add("type");
        return attributesBuilder.getAttributes();
    }
}

