/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.internal.events;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Portal;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=logout.events.post"}, service={LifecycleAction.class})
public class LogoutPostAction
extends Action {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            this.doRun(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    protected void doRun(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        User user = this._portal.getUser(httpServletRequest);
        if (user == null) {
            return;
        }
        AuditMessage auditMessage = new AuditMessage("LOGOUT", user.getCompanyId(), user.getUserId(), user.getFullName(), User.class.getName(), String.valueOf(user.getUserId()));
        this._auditRouter.route(auditMessage);
    }
}

