/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.internal.messaging.config;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.proxy.ProxyMessageListener;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={SchedulerProxyMessagingConfigurator.class})
public class SchedulerProxyMessagingConfigurator {
    private BundleContext _bundleContext;
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Object> _destinationReadyServiceRegistration;
    private ServiceRegistration<Destination> _destinationServiceRegistration;
    private ProxyMessageListener _proxyMessageListener;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/scheduler_engine");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        destination.register((MessageListener)this._proxyMessageListener);
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("destination.name", destination.getName());
        this._destinationServiceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)properties);
        properties.put("destination.ready", true);
        this._destinationReadyServiceRegistration = bundleContext.registerService(Object.class, new Object(), (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        this._destinationReadyServiceRegistration.unregister();
        Destination destination = (Destination)this._bundleContext.getService(this._destinationServiceRegistration.getReference());
        this._destinationServiceRegistration.unregister();
        destination.destroy();
    }

    @Reference(unbind="-")
    protected void setDestinationFactory(DestinationFactory destinationFactory) {
        this._destinationFactory = destinationFactory;
    }

    @Reference(unbind="-")
    protected void setMessageBus(MessageBus messageBus) {
    }

    @Reference(service=ProxyMessageListener.class, target="(destination.name=liferay/scheduler_engine)", unbind="-")
    protected void setProxyMessageListener(ProxyMessageListener proxyMessageListener) {
        this._proxyMessageListener = proxyMessageListener;
    }
}

