/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.portlet.tracker.internal.osgi.util.tracker;

import com.liferay.osgi.util.StringPlus;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.application.type.ApplicationType;
import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.concurrent.SystemExecutorServiceUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.ResourceActionsException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.EventDefinition;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.PortletInfo;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.portlet.PortletDependencyFactory;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletInstanceFactory;
import com.liferay.portal.kernel.security.auth.CompanyInheritableThreadLocalCallable;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.servlet.InitialRequestSyncUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DelegateProxyFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.model.impl.EventDefinitionImpl;
import com.liferay.portal.model.impl.PortletURLListenerImpl;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import com.liferay.portal.osgi.web.portlet.tracker.internal.BundlePluginPackage;
import com.liferay.portal.osgi.web.portlet.tracker.internal.BundlePortletAppDelegate;
import com.liferay.portal.osgi.web.portlet.tracker.internal.PortletPropertyValidator;
import com.liferay.portal.osgi.web.servlet.context.helper.ServletContextHelperFactory;
import com.liferay.portal.osgi.web.servlet.context.helper.ServletContextHelperRegistration;
import com.liferay.portal.service.impl.ResourcePermissionLocalServiceImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import javax.portlet.Portlet;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class PortletTracker
implements ServiceTrackerCustomizer<Portlet, Supplier<com.liferay.portal.kernel.model.Portlet>> {
    private static final String _NAMESPACE = "com.liferay.portlet.";
    private static final Log _log = LogFactoryUtil.getLog(PortletTracker.class);
    private static final Map<String, Set<String>> _defaultPortletModes = Collections.singletonMap("text/html", Collections.singleton(String.valueOf(PortletMode.VIEW)));
    private static final Map<String, Set<String>> _defaultWindowStates = Collections.singletonMap("text/html", SetUtil.fromArray((Object[])new String[]{String.valueOf(LiferayWindowState.EXCLUSIVE), String.valueOf(LiferayWindowState.POP_UP), String.valueOf(WindowState.MAXIMIZED), String.valueOf(WindowState.MINIMIZED), String.valueOf(WindowState.NORMAL)}));
    @Reference
    private BeanProperties _beanProperties;
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DelegateProxyFactory _delegateProxyFactory;
    @Reference(target="(module.service.lifecycle=portlets.initialized)", unbind="-")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    private boolean _parallel;
    @Reference
    private Portal _portal;
    private com.liferay.portal.kernel.model.Portlet _portalPortletModel;
    @Reference
    private PortletDependencyFactory _portletDependencyFactory;
    @Reference
    private PortletInstanceFactory _portletInstanceFactory;
    @Reference
    private PortletLocalService _portletLocalService;
    private final PortletPropertyValidator _portletPropertyValidator = new PortletPropertyValidator();
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private SAXReader _saxReader;
    private final ConcurrentMap<Long, ServiceRegistrations> _serviceRegistrations = new ConcurrentHashMap<Long, ServiceRegistrations>();
    private ServiceTracker<Portlet, ?> _serviceTracker;
    @Reference
    private ServletContextHelperFactory _servletContextHelperFactory;
    private ServiceReference<ServletContextHelperRegistration> _servletContextHelperRegistrationServiceReference;

    public Supplier<com.liferay.portal.kernel.model.Portlet> addingService(ServiceReference<Portlet> serviceReference) {
        Portlet portlet = (Portlet)this._bundleContext.getService(serviceReference);
        if (portlet == null) {
            return null;
        }
        String portletName = (String)serviceReference.getProperty("javax.portlet.name");
        if (Validator.isNull((String)portletName)) {
            Class<?> clazz = portlet.getClass();
            portletName = clazz.getName();
        }
        String portletId = StringUtil.replace((String)portletName, (char[])new char[]{'.', '$'}, (char[])new char[]{'_', '_'});
        if ((portletId = this._portal.getJsSafePortletId(portletId)).length() > PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Portlet ID ", portletId, " has more than ", PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH, " characters"}));
            this._bundleContext.ungetService(serviceReference);
            return null;
        }
        com.liferay.portal.kernel.model.Portlet portletModel = this._portletLocalService.getPortletById(portletId);
        if (portletModel != null) {
            _log.error((Object)("Portlet id " + portletId + " is already in use"));
            this._bundleContext.ungetService(serviceReference);
            return null;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Adding " + serviceReference));
        }
        String finalPortletName = portletName;
        String finalPortletId = portletId;
        FutureTask futureTask = new FutureTask(new CompanyInheritableThreadLocalCallable(() -> {
            com.liferay.portal.kernel.model.Portlet addedPortletModel = this._addingPortlet(serviceReference, portlet, finalPortletName, finalPortletId);
            if (addedPortletModel == null) {
                this._bundleContext.ungetService(serviceReference);
            }
            return addedPortletModel;
        }));
        if (this._parallel && GetterUtil.getBoolean((Object)serviceReference.getProperty("com.liferay.portlet.deploy.parallel"), (boolean)true)) {
            ExecutorService executorService = SystemExecutorServiceUtil.getExecutorService();
            executorService.submit(futureTask);
        } else {
            futureTask.run();
        }
        return () -> {
            try {
                return (com.liferay.portal.kernel.model.Portlet)futureTask.get();
            }
            catch (Exception exception) {
                return (com.liferay.portal.kernel.model.Portlet)ReflectionUtil.throwException((Throwable)exception);
            }
        };
    }

    public void modifiedService(ServiceReference<Portlet> serviceReference, Supplier<com.liferay.portal.kernel.model.Portlet> portletModelSupplier) {
        com.liferay.portal.kernel.model.Portlet portletModel = portletModelSupplier.get();
        this.removedService(serviceReference, portletModelSupplier);
        Object newPortletModelSupplier = this.addingService((ServiceReference)serviceReference);
        if (newPortletModelSupplier == null) {
            return;
        }
        com.liferay.portal.kernel.model.Portlet newPortletModel = (com.liferay.portal.kernel.model.Portlet)newPortletModelSupplier.get();
        if (newPortletModel == null) {
            return;
        }
        this._beanProperties.copyProperties((Object)newPortletModel, (Object)portletModel);
    }

    public void removedService(ServiceReference<Portlet> serviceReference, Supplier<com.liferay.portal.kernel.model.Portlet> portletModelSupplier) {
        ServiceRegistrations serviceRegistrations;
        com.liferay.portal.kernel.model.Portlet portletModel;
        block8: {
            portletModel = portletModelSupplier.get();
            if (portletModel == null) {
                return;
            }
            portletModel.unsetReady();
            serviceRegistrations = (ServiceRegistrations)this._serviceRegistrations.get((Long)serviceReference.getProperty("service.bundleid"));
            if (serviceRegistrations == null) {
                return;
            }
            PortletApp portletApp = serviceRegistrations.getPortletApp();
            portletApp.removePortlet(portletModel);
            try {
                this._bundleContext.ungetService(serviceReference);
            }
            catch (IllegalStateException illegalStateException) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Throwable)illegalStateException);
            }
        }
        this._portletInstanceFactory.destroy(portletModel);
        Long companyId = (Long)serviceReference.getProperty("com.liferay.portlet.company");
        if (companyId == null) {
            this._companyLocalService.forEachCompanyId(curCompanyId -> {
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get((Long)curCompanyId, (String)"PORTLET_CATEGORY");
                if (portletCategory == null) {
                    _log.error((Object)("Unable to get portlet category for " + curCompanyId));
                } else {
                    portletCategory.separate(portletModel.getRootPortletId());
                }
            });
        } else {
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get((Long)companyId, (String)"PORTLET_CATEGORY");
            if (portletCategory == null) {
                _log.error((Object)("Unable to get portlet category for " + companyId));
            } else {
                portletCategory.separate(portletModel.getRootPortletId());
            }
        }
        serviceRegistrations.removeServiceReference(serviceReference);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._parallel = StartupHelperUtil.isDBWarmed();
        this._serviceTracker = new ServiceTracker(this._bundleContext, Portlet.class, (ServiceTrackerCustomizer)this);
        DependencyManagerSyncUtil.registerSyncFutureTask(new FutureTask<Object>(() -> {
            this._portalPortletModel = this._portletLocalService.getPortletById(0L, "90");
            ServiceRegistration serviceRegistration = bundleContext.registerService(ResourcePermissionLocalServiceImpl.IndividualPortletResourcePermissionProvider.class, (Object)new StartupIndividualPortletResourcePermissionProvider(this._resourcePermissionLocalService), null);
            InitialRequestSyncUtil.registerSyncCallable(() -> {
                serviceRegistration.unregister();
                return null;
            });
            this._serviceTracker.open();
            return null;
        }), (String)(PortletTracker.class.getName() + "-ServiceTrackerOpener"));
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Activated");
        }
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Deactivated");
        }
    }

    protected Object get(ServiceReference<Portlet> serviceReference, String property) {
        return serviceReference.getProperty(_NAMESPACE + property);
    }

    private com.liferay.portal.kernel.model.Portlet _addingPortlet(ServiceReference<Portlet> serviceReference, Portlet portlet, String portletName, String portletId) {
        com.liferay.portal.kernel.model.Portlet portlet2;
        block13: {
            this._warnPorletProperties(portletName, serviceReference);
            Bundle bundle = serviceReference.getBundle();
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            ClassLoader bundleClassLoader = bundleWiring.getClassLoader();
            ServiceRegistrations serviceRegistrations = this._getServiceRegistrations(bundle);
            SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)bundleWiring.getClassLoader());
            try {
                PortletApp portletApp = this._createBundlePortletApp(bundle, bundleClassLoader, serviceRegistrations);
                portletApp.setDefaultNamespace((String)serviceReference.getProperty("javax.portlet.default-namespace"));
                String jxPortletVersion = (String)serviceReference.getProperty("javax.portlet.version");
                if (jxPortletVersion == null) {
                    portletApp.setSpecMajorVersion(2);
                    portletApp.setSpecMinorVersion(0);
                } else {
                    String[] jxPortletVersionParts = StringUtil.split((String)jxPortletVersion, (char)'.');
                    if (jxPortletVersionParts.length > 0) {
                        portletApp.setSpecMajorVersion(GetterUtil.getInteger((String)jxPortletVersionParts[0], (int)2));
                        if (jxPortletVersionParts.length > 1) {
                            portletApp.setSpecMinorVersion(GetterUtil.getInteger((String)jxPortletVersionParts[1]));
                        }
                    }
                }
                com.liferay.portal.kernel.model.Portlet portletModel = this._buildPortletModel(portletApp, portletId, bundle, (Long)serviceReference.getProperty("com.liferay.portlet.company"));
                portletModel.setPortletName(portletName);
                portletModel.setDisplayName(GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.display-name"), (String)portletName));
                Class<?> portletClazz = portlet.getClass();
                portletModel.setPortletClass(GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.portlet-class"), (String)portletClazz.getName()));
                this._collectJxPortletFeatures(serviceReference, portletModel);
                this._collectLiferayFeatures(serviceReference, portletModel);
                PortletContextBag portletContextBag = new PortletContextBag(portletApp.getServletContextName());
                PortletContextBagPool.put((String)portletApp.getServletContextName(), (PortletContextBag)portletContextBag);
                PortletBagFactory portletBagFactory = new PortletBagFactory();
                portletBagFactory.setClassLoader(bundleClassLoader);
                portletBagFactory.setServletContext(portletApp.getServletContext());
                portletBagFactory.setWARFile(true);
                portletBagFactory.create(portletModel, portlet, true);
                this._resourceActions.populatePortletResource(portletModel, bundleClassLoader, serviceRegistrations.getSources());
                this._deployPortlet(serviceReference, portletModel);
                portletModel.setReady(true);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Added " + serviceReference));
                }
                serviceRegistrations.addServiceReference(serviceReference);
                portlet2 = portletModel;
                if (safeCloseable == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (safeCloseable != null) {
                        try {
                            safeCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    _log.error((Object)StringBundler.concat((Object[])new Object[]{"Portlet ", portletId, " from ", bundle, " failed to initialize"}), (Throwable)exception);
                    return null;
                }
            }
            safeCloseable.close();
        }
        return portlet2;
    }

    private com.liferay.portal.kernel.model.Portlet _buildPortletModel(PortletApp portletApp, String portletId, Bundle bundle, Long companyId) {
        com.liferay.portal.kernel.model.Portlet portletModel = this._portletLocalService.createPortlet(0L);
        portletModel.setPortletId(portletId);
        if (companyId == null) {
            portletModel.setCompanyId(0L);
        } else {
            portletModel.setCompanyId(companyId.longValue());
        }
        portletModel.setPluginPackage((PluginPackage)new BundlePluginPackage(bundle, portletApp));
        portletModel.setPortletApp(portletApp);
        portletModel.setRoleMappers(this._portalPortletModel.getRoleMappers());
        portletModel.setStrutsPath(portletId);
        return portletModel;
    }

    private void _collectApplicationTypes(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<ApplicationType> applicationTypes = new HashSet<ApplicationType>();
        List applicationTypeValues = StringPlus.asList((Object)this.get(serviceReference, "application-type"));
        for (String applicationTypeValue : applicationTypeValues) {
            try {
                ApplicationType applicationType = ApplicationType.parse((String)applicationTypeValue);
                applicationTypes.add(applicationType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _log.error((Object)("Application type " + applicationTypeValue), (Throwable)illegalArgumentException);
            }
        }
        if (applicationTypes.isEmpty()) {
            applicationTypes.add(ApplicationType.WIDGET);
        }
        portletModel.setApplicationTypes(applicationTypes);
    }

    private void _collectAsyncSupported(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        portletModel.setAsyncSupported(GetterUtil.getBoolean((Object)serviceReference.getProperty("javax.portlet.async-supported")));
    }

    private void _collectContainerRuntimeOptions(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        PortletApp portletApp = portletModel.getPortletApp();
        Map containerRuntimeOptionsMap = portletApp.getContainerRuntimeOptions();
        for (String servicePropertyKey : serviceReference.getPropertyKeys()) {
            if (!servicePropertyKey.startsWith("javax.portlet.container-runtime-option.")) continue;
            String name = servicePropertyKey.substring("javax.portlet.container-runtime-option.".length());
            String portletName = portletModel.getPortletName();
            int index = portletName.indexOf("_WAR_");
            if (index != -1) {
                portletName = portletName.substring(0, index);
            }
            String containerRuntimeOptionPrefix = LiferayPortletConfig.class.getName();
            containerRuntimeOptionPrefix = containerRuntimeOptionPrefix.concat(portletName);
            List values = StringPlus.asList((Object)serviceReference.getProperty(servicePropertyKey));
            containerRuntimeOptionsMap.put(containerRuntimeOptionPrefix.concat(name), values.toArray(new String[0]));
        }
    }

    private void _collectEventDefinitions(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        PortletApp portletApp = portletModel.getPortletApp();
        List definitions = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.event-definition"));
        for (String definition : definitions) {
            EventDefinitionImpl eventDefinition = null;
            String[] definitionParts = StringUtil.split((String)definition);
            for (int i = 0; i < definitionParts.length; ++i) {
                String event;
                String name = event = definitionParts[i];
                String uri = null;
                String[] parts = StringUtil.split((String)event, (char)';');
                if (parts.length >= 2) {
                    name = parts[0];
                    uri = parts[1];
                }
                QName qName = this._getQName(name, uri, portletApp.getDefaultNamespace());
                if (i == 0) {
                    String valueType = null;
                    if (parts.length == 3) {
                        valueType = parts[2];
                    }
                    eventDefinition = new EventDefinitionImpl(qName, valueType, portletApp);
                    continue;
                }
                eventDefinition.addAliasQName(qName);
            }
            if (eventDefinition == null) continue;
            portletApp.addEventDefinition(eventDefinition);
        }
    }

    private void _collectExpirationCache(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        int expirationCache = GetterUtil.getInteger((Object)serviceReference.getProperty("javax.portlet.expiration-cache"));
        portletModel.setExpCache(Integer.valueOf(expirationCache));
    }

    private void _collectInitParams(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (String initParamKey : serviceReference.getPropertyKeys()) {
            if (!initParamKey.startsWith("javax.portlet.init-param.")) continue;
            initParams.put(initParamKey.substring("javax.portlet.init-param.".length()), GetterUtil.getString((Object)serviceReference.getProperty(initParamKey)));
        }
        initParams.put("com.liferay.portal.invokerPortletName", "portlet-servlet");
        portletModel.setInitParams(initParams);
    }

    private void _collectJxPortletFeatures(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        this._collectApplicationTypes(serviceReference, portletModel);
        this._collectAsyncSupported(serviceReference, portletModel);
        this._collectContainerRuntimeOptions(serviceReference, portletModel);
        this._collectEventDefinitions(serviceReference, portletModel);
        this._collectExpirationCache(serviceReference, portletModel);
        this._collectInitParams(serviceReference, portletModel);
        this._collectListeners(serviceReference, portletModel);
        this._collectMultipartConfig(serviceReference, portletModel);
        this._collectPortletDependencies(serviceReference, portletModel);
        this._collectPortletInfo(serviceReference, portletModel);
        this._collectPortletModes(serviceReference, portletModel);
        this._collectPortletPreferences(serviceReference, portletModel);
        this._collectResourceBundle(serviceReference, portletModel);
        this._collectSecurityRoleRefs(serviceReference, portletModel);
        this._collectSupportedLocales(serviceReference, portletModel);
        this._collectSupportedProcessingEvents(serviceReference, portletModel);
        this._collectSupportedPublicRenderParameters(serviceReference, portletModel);
        this._collectSupportedPublishingEvents(serviceReference, portletModel);
        this._collectWindowStates(serviceReference, portletModel);
    }

    private void _collectLiferayFeatures(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        portletModel.setActionTimeout(GetterUtil.getInteger((Object)this.get(serviceReference, "action-timeout"), (int)portletModel.getActionTimeout()));
        portletModel.setActionURLRedirect(GetterUtil.getBoolean((Object)this.get(serviceReference, "action-url-redirect"), (boolean)portletModel.getActionURLRedirect()));
        portletModel.setActive(GetterUtil.getBoolean((Object)this.get(serviceReference, "active"), (boolean)portletModel.isActive()));
        portletModel.setAddDefaultResource(GetterUtil.getBoolean((Object)this.get(serviceReference, "add-default-resource"), (boolean)portletModel.isAddDefaultResource()));
        portletModel.setAjaxable(GetterUtil.getBoolean((Object)this.get(serviceReference, "ajaxable"), (boolean)portletModel.isAjaxable()));
        portletModel.setAutopropagatedParameters(SetUtil.fromCollection((Collection)StringPlus.asList((Object)this.get(serviceReference, "autopropagated-parameters"))));
        portletModel.setControlPanelEntryWeight(GetterUtil.getDouble((Object)this.get(serviceReference, "control-panel-entry-weight"), (double)portletModel.getControlPanelEntryWeight()));
        portletModel.setCssClassWrapper(GetterUtil.getString((Object)this.get(serviceReference, "css-class-wrapper"), (String)portletModel.getCssClassWrapper()));
        portletModel.setFooterPortalCss(StringPlus.asList((Object)this.get(serviceReference, "footer-portal-css")));
        portletModel.setFooterPortalJavaScript(StringPlus.asList((Object)this.get(serviceReference, "footer-portal-javascript")));
        portletModel.setFooterPortletCss(StringPlus.asList((Object)this.get(serviceReference, "footer-portlet-css")));
        portletModel.setFooterPortletJavaScript(StringPlus.asList((Object)this.get(serviceReference, "footer-portlet-javascript")));
        portletModel.setFriendlyURLMapperClass(GetterUtil.getString((Object)this.get(serviceReference, "friendly-url-mapper-class"), (String)portletModel.getFriendlyURLMapperClass()));
        portletModel.setFriendlyURLMapping(GetterUtil.getString((Object)this.get(serviceReference, "friendly-url-mapping"), (String)portletModel.getFriendlyURLMapping()));
        portletModel.setFriendlyURLRoutes(GetterUtil.getString((Object)this.get(serviceReference, "friendly-url-routes"), (String)portletModel.getFriendlyURLRoutes()));
        portletModel.setHeaderPortalCss(StringPlus.asList((Object)this.get(serviceReference, "header-portal-css")));
        portletModel.setHeaderPortalJavaScript(StringPlus.asList((Object)this.get(serviceReference, "header-portal-javascript")));
        portletModel.setHeaderPortletCss(StringPlus.asList((Object)this.get(serviceReference, "header-portlet-css")));
        portletModel.setHeaderPortletJavaScript(StringPlus.asList((Object)this.get(serviceReference, "header-portlet-javascript")));
        portletModel.setHeaderRequestAttributePrefixes(StringPlus.asList((Object)this.get(serviceReference, "header-request-attribute-prefix")));
        portletModel.setHeaderTimeout(GetterUtil.getInteger((Object)this.get(serviceReference, "header-timeout"), (int)portletModel.getHeaderTimeout()));
        portletModel.setIcon(GetterUtil.getString((Object)this.get(serviceReference, "icon"), (String)portletModel.getIcon()));
        portletModel.setInclude(GetterUtil.getBoolean((Object)this.get(serviceReference, "include"), (boolean)portletModel.isInclude()));
        portletModel.setInstanceable(GetterUtil.getBoolean((Object)this.get(serviceReference, "instanceable"), (boolean)portletModel.isInstanceable()));
        portletModel.setLayoutCacheable(GetterUtil.getBoolean((Object)this.get(serviceReference, "layout-cacheable"), (boolean)portletModel.isLayoutCacheable()));
        portletModel.setMaximizeEdit(GetterUtil.getBoolean((Object)this.get(serviceReference, "maximize-edit"), (boolean)portletModel.isMaximizeEdit()));
        portletModel.setMaximizeHelp(GetterUtil.getBoolean((Object)this.get(serviceReference, "maximize-help"), (boolean)portletModel.isMaximizeHelp()));
        portletModel.setParentStrutsPath(GetterUtil.getString((Object)this.get(serviceReference, "parent-struts-path"), (String)portletModel.getParentStrutsPath()));
        portletModel.setPartialActionServeResource(GetterUtil.getBoolean((Object)this.get(serviceReference, "partial-action-serve-resource"), (boolean)portletModel.isPartialActionServeResource()));
        portletModel.setPopUpPrint(GetterUtil.getBoolean((Object)this.get(serviceReference, "pop-up-print"), (boolean)portletModel.isPopUpPrint()));
        portletModel.setPortletDependencyCssEnabled(GetterUtil.getBoolean((Object)this.get(serviceReference, "portlet-dependency-css-enabled"), (boolean)portletModel.isPortletDependencyCssEnabled()));
        portletModel.setPortletDependencyJavaScriptEnabled(GetterUtil.getBoolean((Object)this.get(serviceReference, "portlet-dependency-javascript-enabled"), (boolean)portletModel.isPortletDependencyJavaScriptEnabled()));
        portletModel.setPreferencesCompanyWide(GetterUtil.getBoolean((Object)this.get(serviceReference, "preferences-company-wide"), (boolean)portletModel.isPreferencesCompanyWide()));
        portletModel.setPreferencesOwnedByGroup(GetterUtil.getBoolean((Object)this.get(serviceReference, "preferences-owned-by-group"), (boolean)portletModel.isPreferencesOwnedByGroup()));
        portletModel.setPreferencesUniquePerLayout(GetterUtil.getBoolean((Object)this.get(serviceReference, "preferences-unique-per-layout"), (boolean)portletModel.isPreferencesUniquePerLayout()));
        portletModel.setPrivateRequestAttributes(GetterUtil.getBoolean((Object)this.get(serviceReference, "private-request-attributes"), (boolean)portletModel.isPrivateRequestAttributes()));
        portletModel.setPrivateSessionAttributes(GetterUtil.getBoolean((Object)this.get(serviceReference, "private-session-attributes"), (boolean)portletModel.isPrivateSessionAttributes()));
        portletModel.setRenderTimeout(GetterUtil.getInteger((Object)this.get(serviceReference, "render-timeout"), (int)portletModel.getRenderTimeout()));
        portletModel.setRenderWeight(GetterUtil.getInteger((Object)this.get(serviceReference, "render-weight"), (int)portletModel.getRenderWeight()));
        if (!portletModel.isAjaxable() && portletModel.getRenderWeight() < 1) {
            portletModel.setRenderWeight(1);
        }
        boolean defaultRequiresNamespacedParameters = GetterUtil.getBoolean((Object)this.get(serviceReference, "requires-namespaced-parameters"), (boolean)portletModel.isRequiresNamespacedParameters());
        portletModel.setRequiresNamespacedParameters(GetterUtil.getBoolean((Object)serviceReference.getProperty("requires-namespaced-parameters"), (boolean)defaultRequiresNamespacedParameters));
        portletModel.setRestoreCurrentView(GetterUtil.getBoolean((Object)this.get(serviceReference, "restore-current-view"), (boolean)portletModel.isRestoreCurrentView()));
        portletModel.setScopeable(GetterUtil.getBoolean((Object)this.get(serviceReference, "scopeable"), (boolean)portletModel.isScopeable()));
        portletModel.setShowPortletAccessDenied(GetterUtil.getBoolean((Object)this.get(serviceReference, "show-portlet-access-denied"), (boolean)portletModel.isShowPortletAccessDenied()));
        portletModel.setShowPortletInactive(GetterUtil.getBoolean((Object)this.get(serviceReference, "show-portlet-inactive"), (boolean)portletModel.isShowPortletInactive()));
        portletModel.setSinglePageApplication(GetterUtil.getBoolean((Object)this.get(serviceReference, "single-page-application"), (boolean)portletModel.isSinglePageApplication()));
        portletModel.setStrutsPath(GetterUtil.getString((Object)this.get(serviceReference, "struts-path"), (String)portletModel.getStrutsPath()));
        portletModel.setSystem(GetterUtil.getBoolean((Object)this.get(serviceReference, "system"), (boolean)portletModel.isSystem()));
        portletModel.setUseDefaultTemplate(GetterUtil.getBoolean((Object)this.get(serviceReference, "use-default-template"), (boolean)portletModel.isUseDefaultTemplate()));
        portletModel.setUserPrincipalStrategy(GetterUtil.getString((Object)this.get(serviceReference, "user-principal-strategy"), (String)portletModel.getUserPrincipalStrategy()));
        portletModel.setVirtualPath(GetterUtil.getString((Object)this.get(serviceReference, "virtual-path"), (String)portletModel.getVirtualPath()));
    }

    /*
     * WARNING - void declaration
     */
    private void _collectListeners(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        PortletApp portletApp = portletModel.getPortletApp();
        List listenerClassNames = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.listener"));
        ArrayList<PortletURLListenerImpl> portletURLListeners = new ArrayList<PortletURLListenerImpl>();
        for (String string : listenerClassNames) {
            void var7_7;
            int ordinal = 0;
            String[] parts = StringUtil.split((String)string, (char)';');
            if (parts.length == 2) {
                String string2 = parts[0];
                ordinal = GetterUtil.getInteger((String)parts[1]);
            }
            portletURLListeners.add(new PortletURLListenerImpl((String)var7_7, ordinal, portletApp));
        }
        Collections.sort(portletURLListeners, Comparator.comparingInt(PortletURLListener::getOrdinal));
        for (PortletURLListener portletURLListener : portletURLListeners) {
            portletApp.addPortletURLListener(portletURLListener);
        }
    }

    private void _collectMultipartConfig(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        portletModel.setMultipartFileSizeThreshold(GetterUtil.getInteger((Object)serviceReference.getProperty("javax.portlet.multipart.file-size-threshold")));
        portletModel.setMultipartLocation(GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.multipart.location"), (String)portletModel.getMultipartLocation()));
        portletModel.setMultipartMaxFileSize(GetterUtil.getLong((Object)serviceReference.getProperty("javax.portlet.multipart.max-file-size"), (long)-1L));
        portletModel.setMultipartMaxRequestSize(GetterUtil.getLong((Object)serviceReference.getProperty("javax.portlet.multipart.max-request-size"), (long)-1L));
    }

    private void _collectPortletDependencies(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        List dependencies = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.dependency"));
        for (String dependency : dependencies) {
            String[] parts = StringUtil.split((String)dependency, (char)';');
            portletModel.addPortletDependency(this._portletDependencyFactory.createPortletDependency(parts[0], parts[1], parts[2]));
        }
    }

    private void _collectPortletInfo(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        String portletInfoTitle = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.info.title"));
        String portletDisplayName = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.display-name"), (String)portletInfoTitle);
        String portletInfoShortTitle = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.info.short-title"));
        String portletInfoKeyWords = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.info.keywords"));
        String portletDescription = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.description"));
        PortletInfo portletInfo = new PortletInfo(portletDisplayName, portletInfoShortTitle, portletInfoKeyWords, portletDescription);
        portletModel.setPortletInfo(portletInfo);
    }

    private void _collectPortletModes(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        Map<String, Set<String>> portletModes = null;
        List portletModesStrings = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.portlet-mode"));
        for (String portletModesString : portletModesStrings) {
            String[] portletModesStringParts = StringUtil.split((String)portletModesString, (char)';');
            if (portletModesStringParts.length != 2) continue;
            String mimeType = portletModesStringParts[0];
            HashSet<String> mimeTypePortletModes = new HashSet<String>();
            mimeTypePortletModes.add(this._toLowerCase(PortletMode.VIEW));
            mimeTypePortletModes.addAll(this._toLowerCaseSet(portletModesStringParts[1]));
            if (portletModes == null) {
                portletModes = new HashMap<String, Set<String>>(_defaultPortletModes);
            }
            portletModes.put(mimeType, mimeTypePortletModes);
        }
        if (portletModes == null) {
            portletModes = _defaultPortletModes;
        }
        portletModel.setPortletModes(portletModes);
    }

    private void _collectPortletPreferences(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        Bundle bundle;
        URL url;
        String defaultPreferences = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.preferences"));
        if (defaultPreferences != null && defaultPreferences.startsWith("classpath:") && (url = (bundle = serviceReference.getBundle()).getResource(defaultPreferences.substring("classpath:".length()))) != null) {
            try {
                defaultPreferences = URLUtil.toString((URL)url);
            }
            catch (IOException ioException) {
                _log.error((Throwable)ioException);
            }
        }
        portletModel.setDefaultPreferences(defaultPreferences);
        String preferencesValidator = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.preferences-validator"));
        if (Validator.isNotNull((String)preferencesValidator)) {
            portletModel.setPreferencesValidator(preferencesValidator);
        }
    }

    private void _collectResourceBundle(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        String resourceBundle = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.resource-bundle"), (String)portletModel.getResourceBundle());
        portletModel.setResourceBundle(resourceBundle);
    }

    private void _collectSecurityRoleRefs(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<String> unlinkedRoles = new HashSet<String>();
        List roleRefs = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.security-role-ref"));
        if (roleRefs.isEmpty()) {
            roleRefs.add("administrator");
            roleRefs.add("guest");
            roleRefs.add("power-user");
            roleRefs.add("user");
        }
        for (String roleRef : roleRefs) {
            for (String curRoleRef : StringUtil.split((String)roleRef)) {
                unlinkedRoles.add(curRoleRef);
            }
        }
        portletModel.setUnlinkedRoles(unlinkedRoles);
        portletModel.linkRoles();
    }

    private void _collectSupportedLocales(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        LinkedHashSet supportedLocales = new LinkedHashSet();
        supportedLocales.addAll(StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.supported-locale")));
        portletModel.setSupportedLocales(supportedLocales);
    }

    private void _collectSupportedProcessingEvents(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<QName> processingEvents = new HashSet<QName>();
        PortletApp portletApp = portletModel.getPortletApp();
        List supportedProcessingEvents = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.supported-processing-event"));
        Iterator iterator = supportedProcessingEvents.iterator();
        while (iterator.hasNext()) {
            String supportedProcessingEvent;
            String name = supportedProcessingEvent = (String)iterator.next();
            String uri = null;
            String[] parts = StringUtil.split((String)supportedProcessingEvent, (char)';');
            if (parts.length == 2) {
                name = parts[0];
                uri = parts[1];
            }
            QName qName = this._getQName(name, uri, portletApp.getDefaultNamespace());
            processingEvents.add(qName);
            Set eventDefinitions = portletApp.getEventDefinitions();
            for (EventDefinition eventDefinition : eventDefinitions) {
                Set qNames = eventDefinition.getQNames();
                if (!qNames.contains(qName)) continue;
                processingEvents.addAll(qNames);
            }
        }
        portletModel.setProcessingEvents(processingEvents);
    }

    private void _collectSupportedPublicRenderParameters(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<PublicRenderParameterImpl> publicRenderParameters = new HashSet<PublicRenderParameterImpl>();
        PortletApp portletApp = portletModel.getPortletApp();
        List supportedPublicRenderParameters = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.supported-public-render-parameter"));
        Iterator iterator = supportedPublicRenderParameters.iterator();
        while (iterator.hasNext()) {
            String supportedPublicRenderParameter;
            String name = supportedPublicRenderParameter = (String)iterator.next();
            String uri = null;
            String[] parts = StringUtil.split((String)supportedPublicRenderParameter, (char)';');
            if (parts.length == 2) {
                name = parts[0];
                uri = parts[1];
            }
            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(name, this._getQName(name, uri, portletApp.getDefaultNamespace()), portletApp);
            publicRenderParameters.add(publicRenderParameter);
        }
        portletModel.setPublicRenderParameters(publicRenderParameters);
    }

    private void _collectSupportedPublishingEvents(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<QName> publishingEvents = new HashSet<QName>();
        PortletApp portletApp = portletModel.getPortletApp();
        List supportedPublishingEvents = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.supported-publishing-event"));
        Iterator iterator = supportedPublishingEvents.iterator();
        while (iterator.hasNext()) {
            String supportedPublishingEvent;
            String name = supportedPublishingEvent = (String)iterator.next();
            String uri = null;
            String[] parts = StringUtil.split((String)supportedPublishingEvent, (char)';');
            if (parts.length == 2) {
                name = parts[0];
                uri = parts[1];
            }
            publishingEvents.add(this._getQName(name, uri, portletApp.getDefaultNamespace()));
        }
        portletModel.setPublishingEvents(publishingEvents);
    }

    private void _collectWindowStates(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        Map<String, Set<String>> windowStates = null;
        List windowStatesStrings = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.window-state"));
        for (String windowStatesString : windowStatesStrings) {
            String[] windowStatesStringParts = StringUtil.split((String)windowStatesString, (char)';');
            if (windowStatesStringParts.length != 2) continue;
            String mimeType = windowStatesStringParts[0];
            HashSet<String> mimeTypeWindowStates = new HashSet<String>();
            mimeTypeWindowStates.add(this._toLowerCase(WindowState.NORMAL));
            Set<String> windowStatesSet = this._toLowerCaseSet(windowStatesStringParts[1]);
            if (windowStatesSet.isEmpty()) {
                mimeTypeWindowStates.add(this._toLowerCase(LiferayWindowState.EXCLUSIVE));
                mimeTypeWindowStates.add(this._toLowerCase(LiferayWindowState.POP_UP));
                mimeTypeWindowStates.add(this._toLowerCase(WindowState.MAXIMIZED));
                mimeTypeWindowStates.add(this._toLowerCase(WindowState.MINIMIZED));
            } else {
                mimeTypeWindowStates.addAll(windowStatesSet);
            }
            if (windowStates == null) {
                windowStates = new HashMap<String, Set<String>>(_defaultWindowStates);
            }
            windowStates.put(mimeType, mimeTypeWindowStates);
        }
        if (windowStates == null) {
            windowStates = _defaultWindowStates;
        }
        portletModel.setWindowStates(windowStates);
    }

    private PortletApp _createBundlePortletApp(Bundle bundle, ClassLoader classLoader, ServiceRegistrations serviceRegistrations) {
        PortletApp portletApp = serviceRegistrations.getPortletApp();
        if (portletApp != null) {
            return portletApp;
        }
        BundleContext bundleContext = bundle.getBundleContext();
        this._servletContextHelperRegistrationServiceReference = bundleContext.getServiceReference(ServletContextHelperRegistration.class);
        ServletContextHelperRegistration servletContextHelperRegistration = (ServletContextHelperRegistration)bundleContext.getService(this._servletContextHelperRegistrationServiceReference);
        BundlePortletAppDelegate bundlePortletAppDelegate = new BundlePortletAppDelegate(this._portalPortletModel, servletContextHelperRegistration.getServletContext());
        PortletApp portletAppDefault = this._portalPortletModel.getPortletApp();
        portletApp = (PortletApp)this._delegateProxyFactory.newDelegateProxyInstance(PortletTracker.class.getClassLoader(), PortletApp.class, (Object)bundlePortletAppDelegate, (Object)portletAppDefault);
        serviceRegistrations.setPortletApp(portletApp);
        serviceRegistrations.doConfiguration(classLoader);
        return portletApp;
    }

    private void _deployPortlet(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) throws PortalException {
        Long companyId = (Long)serviceReference.getProperty("com.liferay.portlet.company");
        List categoryNames = StringPlus.asList((Object)this.get(serviceReference, "display-category"));
        if (categoryNames.isEmpty()) {
            categoryNames.add("category.undefined");
        }
        if (companyId != null) {
            this._portletLocalService.deployRemotePortlet(new long[]{companyId}, portletModel, ArrayUtil.toStringArray((Collection)categoryNames), false, false);
            this._portletLocalService.clearCache();
            return;
        }
        for (Company company : this._companyLocalService.getCompanies()) {
            this._portletLocalService.deployRemotePortlet(new long[]{company.getCompanyId()}, portletModel, ArrayUtil.toStringArray((Collection)categoryNames), false, false);
        }
        this._portletLocalService.clearCache();
    }

    private QName _getQName(String name, String uri, String defaultNamespace) {
        if (Validator.isNull((String)name) && Validator.isNull((String)uri)) {
            return null;
        }
        if (Validator.isNull((String)uri)) {
            return this._saxReader.createQName(name, this._saxReader.createNamespace(defaultNamespace));
        }
        return this._saxReader.createQName(name, this._saxReader.createNamespace(uri));
    }

    private ServiceRegistrations _getServiceRegistrations(Bundle bundle) {
        ServiceRegistrations oldServiceRegistrations;
        Long bundleId = bundle.getBundleId();
        ServiceRegistrations serviceRegistrations = (ServiceRegistrations)this._serviceRegistrations.get(bundleId);
        if (serviceRegistrations == null && (oldServiceRegistrations = this._serviceRegistrations.putIfAbsent(bundleId, serviceRegistrations = new ServiceRegistrations(bundle))) != null) {
            serviceRegistrations = oldServiceRegistrations;
        }
        return serviceRegistrations;
    }

    private String _toLowerCase(Object object) {
        String string = String.valueOf(object);
        return StringUtil.toLowerCase((String)string.trim());
    }

    private Set<String> _toLowerCaseSet(String string) {
        Object[] array = StringUtil.split((String)string);
        for (int i = 0; i < array.length; ++i) {
            array[i] = this._toLowerCase(array[i]);
        }
        return SetUtil.fromArray((Object[])array);
    }

    private void _warnPorletProperties(String portletName, ServiceReference<Portlet> serviceReference) {
        if (!_log.isWarnEnabled()) {
            return;
        }
        List<String> invalidKeys = this._portletPropertyValidator.validate(serviceReference.getPropertyKeys());
        for (String invalidKey : invalidKeys) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Invalid property ", invalidKey, " for portlet ", portletName}));
        }
    }

    private class ServiceRegistrations {
        private final Bundle _bundle;
        private PortletApp _portletApp;
        private final List<ServiceReference<Portlet>> _serviceReferences = new ArrayList<ServiceReference<Portlet>>();
        private String[] _sources;

        public synchronized void addServiceReference(ServiceReference<Portlet> serviceReference) {
            this._serviceReferences.add(serviceReference);
        }

        public synchronized String[] getSources() {
            return this._sources;
        }

        public synchronized void removeServiceReference(ServiceReference<Portlet> serviceReference) {
            block3: {
                this._serviceReferences.remove(serviceReference);
                if (!this._serviceReferences.isEmpty()) {
                    return;
                }
                this._serviceReferences.clear();
                this._portletApp = null;
                PortletTracker.this._serviceRegistrations.remove(this._bundle.getBundleId());
                BundleContext bundleContext = this._bundle.getBundleContext();
                try {
                    bundleContext.ungetService(PortletTracker.this._servletContextHelperRegistrationServiceReference);
                }
                catch (IllegalStateException illegalStateException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Throwable)illegalStateException);
                }
            }
        }

        public synchronized void setPortletApp(PortletApp portletApp) {
            this._portletApp = portletApp;
        }

        protected synchronized void doConfiguration(ClassLoader classLoader) {
            if (classLoader.getResource("portlet.properties") != null) {
                Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
                Properties properties = configuration.getProperties();
                this._sources = StringUtil.split((String)properties.getProperty("resource.actions.configs"));
                if (!PropsValues.RESOURCE_ACTIONS_STRICT_MODE_ENABLED) {
                    try {
                        PortletTracker.this._resourceActions.populateModelResources(classLoader, this._sources);
                    }
                    catch (ResourceActionsException resourceActionsException) {
                        _log.error((Object)"Unable to read resource actions config in resource.actions.configs", (Throwable)resourceActionsException);
                    }
                }
            }
        }

        protected synchronized PortletApp getPortletApp() {
            return this._portletApp;
        }

        private ServiceRegistrations(Bundle bundle) {
            this._bundle = bundle;
        }
    }

    private static class StartupIndividualPortletResourcePermissionProvider
    implements ResourcePermissionLocalServiceImpl.IndividualPortletResourcePermissionProvider {
        private final ResourcePermissionLocalService _resourcePermissionLocalService;
        private final Map<Long, DCLSingleton<Map<String, List<ResourcePermission>>>> _resourcePermissionMaps = new ConcurrentHashMap<Long, DCLSingleton<Map<String, List<ResourcePermission>>>>();

        public List<ResourcePermission> getResourcePermissions(long companyId, String name) {
            DCLSingleton<Map<String, List<ResourcePermission>>> resourcePermissionsDCLSingleton = this._resourcePermissionMaps.get(companyId);
            if (resourcePermissionsDCLSingleton == null) {
                resourcePermissionsDCLSingleton = new DCLSingleton<Map<String, List<ResourcePermission>>>();
                DCLSingleton<Map<String, List<ResourcePermission>>> previousResourcePermissionsDCLSingleton = this._resourcePermissionMaps.putIfAbsent(companyId, resourcePermissionsDCLSingleton);
                if (previousResourcePermissionsDCLSingleton != null) {
                    resourcePermissionsDCLSingleton = previousResourcePermissionsDCLSingleton;
                }
            }
            Map resourcePermissions = (Map)resourcePermissionsDCLSingleton.getSingleton(() -> this._resourcePermissionLocalService.getIndividualPortletResourcePermissions(companyId));
            return (List)resourcePermissions.get(name);
        }

        public void removeResourcePermissions(long companyId, String name) {
            Map resourcePermissions;
            DCLSingleton<Map<String, List<ResourcePermission>>> resourcePermissionsDCLSingleton = this._resourcePermissionMaps.get(companyId);
            if (resourcePermissionsDCLSingleton != null && (resourcePermissions = (Map)resourcePermissionsDCLSingleton.getSingleton(() -> null)) != null) {
                resourcePermissions.remove(name);
            }
        }

        private StartupIndividualPortletResourcePermissionProvider(ResourcePermissionLocalService resourcePermissionLocalService) {
            this._resourcePermissionLocalService = resourcePermissionLocalService;
        }
    }
}

