/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.detection.fiftyonedegrees.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Capability;
import com.liferay.portal.kernel.mobile.device.KnownDevices;
import com.liferay.portal.kernel.mobile.device.NoKnownDevices;
import com.liferay.portal.kernel.mobile.device.VersionableName;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.mobile.device.detection.fiftyonedegrees.internal.FiftyOneDegreesEngineProxy;
import com.liferay.portal.mobile.device.detection.fiftyonedegrees.internal.constants.FiftyOneDegreesPropertyNames;
import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.Profile;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FiftyOneDegreesKnownDevices.class, KnownDevices.class})
public class FiftyOneDegreesKnownDevices
implements KnownDevices {
    private static final Log _log = LogFactoryUtil.getLog(FiftyOneDegreesKnownDevices.class);
    private final Set<VersionableName> _brands = new TreeSet<VersionableName>();
    private final Set<VersionableName> _browswers = new TreeSet<VersionableName>();
    @Reference
    private FiftyOneDegreesEngineProxy _fiftyOneDegreesEngineProxy;
    private boolean _initialized;
    private final Set<VersionableName> _operatingSystems = new TreeSet<VersionableName>();
    private Set<String> _pointingMethods;

    public Set<VersionableName> getBrands() {
        if (!this._initialized) {
            NoKnownDevices noKnownDevices = NoKnownDevices.getInstance();
            return noKnownDevices.getBrands();
        }
        return this._brands;
    }

    public Set<VersionableName> getBrowsers() {
        if (!this._initialized) {
            NoKnownDevices noKnownDevices = NoKnownDevices.getInstance();
            return noKnownDevices.getBrowsers();
        }
        return this._browswers;
    }

    @Deprecated
    public Map<Capability, Set<String>> getDeviceIds() {
        return null;
    }

    public Set<VersionableName> getOperatingSystems() {
        if (!this._initialized) {
            NoKnownDevices noKnownDevices = NoKnownDevices.getInstance();
            return noKnownDevices.getOperatingSystems();
        }
        return this._operatingSystems;
    }

    public Set<String> getPointingMethods() {
        return this._pointingMethods;
    }

    public synchronized void reload() throws Exception {
        this._initialized = false;
        Dataset dataset = this._fiftyOneDegreesEngineProxy.getDataset();
        this.addProperties(this._brands, dataset.getHardware(), "HardwareVendor", "HardwareModel", "HardwareName");
        this.addProperties(this._browswers, dataset.getBrowsers(), "BrowserName", "BrowserVersion", null);
        this.addProperties(this._operatingSystems, dataset.getSoftware(), "PlatformName", "PlatformVersion", null);
        List<String> pointingMethodsList = Arrays.asList(FiftyOneDegreesPropertyNames.TOUCH_EVENTS);
        this._pointingMethods = new TreeSet<String>(pointingMethodsList);
        this._initialized = true;
    }

    protected void addProperties(Set<VersionableName> propertiesSet, fiftyone.mobile.detection.entities.Component component, String namePropertyName, String versionPropertyName, String secondaryVersionPropertyName) throws IOException {
        block4: {
            try {
                for (Profile profile : component.getProfiles()) {
                    String propertyValue = String.valueOf(profile.getValues(namePropertyName));
                    String propertyVersion = String.valueOf(profile.getValues(versionPropertyName));
                    VersionableName versionableName = new VersionableName(propertyValue, propertyVersion);
                    if (Validator.isNotNull((String)secondaryVersionPropertyName)) {
                        String secondaryVersion = String.valueOf(profile.getValues(secondaryVersionPropertyName));
                        versionableName.addVersion(secondaryVersion);
                    }
                    propertiesSet.add(versionableName);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!_log.isInfoEnabled()) break block4;
                StringBundler sb = new StringBundler(6);
                sb.append("Data file does not support property: ");
                sb.append(namePropertyName);
                sb.append(", ");
                sb.append(versionPropertyName);
                sb.append(". Please upgrade to the premium Liferay Device ");
                sb.append("Detection module");
                _log.info((Object)sb.toString());
            }
        }
    }
}

