/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.detection.fiftyonedegrees.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.BaseDevice;
import com.liferay.portal.kernel.mobile.device.Capability;
import com.liferay.portal.kernel.mobile.device.Dimensions;
import com.liferay.portal.kernel.mobile.device.VersionableName;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.mobile.device.detection.fiftyonedegrees.internal.constants.FiftyOneDegreesPropertyNames;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.entities.Values;
import java.io.IOException;
import java.util.Map;

public class FiftyOneDegreesDevice
extends BaseDevice {
    private static final String _VALUE_UNKNOWN = "unknown";
    private static final Log _log = LogFactoryUtil.getLog(FiftyOneDegreesDevice.class);
    private final Match _match;

    public FiftyOneDegreesDevice(Match match) {
        this._match = match;
    }

    public String getBrand() {
        return this.getValueString("HardwareVendor");
    }

    public String getBrowser() {
        return this.getValueString("BrowserName");
    }

    public String getBrowserVersion() {
        return this.getValueString("BrowserVersion");
    }

    @Deprecated
    public Map<String, Capability> getCapabilities() {
        return null;
    }

    @Deprecated
    public String getCapability(String name) {
        return null;
    }

    public String getModel() {
        return this.getValueString("HardwareModel");
    }

    public String getOS() {
        return this.getValueString("PlatformName");
    }

    public String getOSVersion() {
        return this.getValueString("PlatformVersion");
    }

    public String getPointingMethod() {
        for (String pointingMethod : FiftyOneDegreesPropertyNames.TOUCH_EVENTS) {
            if (!this.getValueBoolean(pointingMethod)) continue;
            return pointingMethod;
        }
        return _VALUE_UNKNOWN;
    }

    public Dimensions getScreenPhysicalSize() {
        return this.getDimensions("ScreenMMHeight", "ScreenMMWidth");
    }

    public Dimensions getScreenResolution() {
        return this.getDimensions("ScreenPixelsHeight", "ScreenPixelsWidth");
    }

    public boolean hasQwertyKeyboard() {
        return this.getValueBoolean("HasQwertyPad") || this.getValueBoolean("HasVirtualQwerty");
    }

    public boolean isTablet() {
        return this.getValueBoolean("IsTablet");
    }

    protected Dimensions getDimensions(String heightPropertyName, String widthPropertyName) {
        double height = this.getValueDouble(heightPropertyName);
        double width = this.getValueDouble(widthPropertyName);
        if (height == 0.0 || width == 0.0) {
            return Dimensions.UNKNOWN;
        }
        return new Dimensions((float)height, (float)width);
    }

    protected boolean getValueBoolean(String propertyName) {
        boolean value;
        block3: {
            value = false;
            try {
                Values values = this._match.getValues(propertyName);
                if (values != null) {
                    value = values.toBool();
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to get boolean value for property name: " + propertyName), (Throwable)ioException);
            }
        }
        return value;
    }

    protected double getValueDouble(String propertyName) {
        double value;
        block3: {
            value = 0.0;
            try {
                Values values = this._match.getValues(propertyName);
                if (values != null) {
                    value = values.toDouble();
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to get double value for property name: " + propertyName), (Throwable)ioException);
            }
        }
        return value;
    }

    protected String getValueString(String propertyName) {
        String value;
        block3: {
            value = VersionableName.UNKNOWN.getName();
            try {
                String matchValue;
                Values values = this._match.getValues(propertyName);
                if (values != null && !StringUtil.equalsIgnoreCase((String)(matchValue = String.valueOf(values)), (String)_VALUE_UNKNOWN)) {
                    value = matchValue;
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to get string value for property name: " + propertyName), (Throwable)ioException);
            }
        }
        return value;
    }
}

